
/*	$Id: icns.r,v 1.3 2005/01/11 22:48:54 andreradke Exp $    */

/******************************************************************************

    UserLand Frontier(tm) -- High performance Web content management,
    object database, system-level and Internet scripting environment,
    including source code editing and debugging.

    Copyright (C) 1992-2004 UserLand Software, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

******************************************************************************/

#include "frontier.r"


data 'icns' (128) {
	$"6963 6E73 0000 CEEE 6963 7323 0000 0048"            /* icns..ics#...H */
	$"00E0 0170 1AF0 3EFC 2DFE 7DFE 7DFE 5FFE"            /* ..p.>-}}_ */
	$"3BFE 1BFE 0BFC 0BF8 0BC0 0BC0 0BC0 1FF8"            /* ;....... */
	$"00E0 01F0 1BF0 3FFC 3FFE 7FFE 7FFE 7FFE"            /* ...??... */
	$"3FFE 1FFE 0FFC 0FF8 0FC0 0FC0 0FC0 1FF8"            /* ?....... */
	$"6963 7334 0000 0088 0000 0000 FFF0 0000"            /* ics4......... */
	$"0000 000F 88AF 0000 000F F0FB 88AF 0000"            /* .......... */
	$"00FB 8F98 889F FF00 00FB 8FB8 889F 8AF0"            /* ... */
	$"0FB8 AFB8 8AFB 88F0 0FB8 A9B8 8AFB 88F0"            /* .. */
	$"0FB8 8888 8F98 88F0 00F8 AB88 A888 88F0"            /* .. */
	$"000F 9B88 8888 8AF0 0000 FB88 888A 9F00"            /* ..... */
	$"0000 FB88 A9FF F000 0000 FB88 AF00 0000"            /* ........ */
	$"0000 FB88 AF00 0000 0000 FB88 AF00 0000"            /* .......... */
	$"000F FFFF FFFF F000 6963 7338 0000 0108"            /* ...ics8.... */
	$"0000 0000 0000 0000 FFFF FF00 0000 0000"            /* ............. */
	$"0000 0000 0000 00FF 7D7D 7DFF 0000 0000"            /* .......}}}.... */
	$"0000 00FF FF00 FF58 7D7D 7DFF 0000 0000"            /* ....X}}}.... */
	$"0000 FF7C 7DFF A77D 7D7D A7FF FFFF 0000"            /* ..|}}}}.. */
	$"0000 FF7C 7DFF 7C7D 7D7D A7FF 7D7D FF00"            /* ..|}|}}}}}. */
	$"00FF 827D 7DFF 527D 7D7D FF7C 7D7D FF00"            /* .}}R}}}|}}. */
	$"00FF 7C7D 7DA7 7C7D 7D83 FF7C 7D7D FF00"            /* .|}}|}}|}}. */
	$"00FF 7C7D 7D7D 7D7D 7DFF A77D 7D7D FF00"            /* .|}}}}}}}}}. */
	$"0000 FF7D 7D7C 7D7D 7D7D 7D7D 7D7D FF00"            /* ..}}|}}}}}}}}. */
	$"0000 00FF A758 7D7D 7D7D 7D7D 7D7D FF00"            /* ...X}}}}}}}}. */
	$"0000 0000 FF58 7D7D 7D7D 7D7D A7FF 0000"            /* ....X}}}}}}.. */
	$"0000 0000 FF52 7D7D 7DA7 FFFF FF00 0000"            /* ....R}}}... */
	$"0000 0000 FF52 7D7D 83FF 0000 0000 0000"            /* ....R}}...... */
	$"0000 0000 FF52 7D7D 83FF 0000 0000 0000"            /* ....R}}...... */
	$"0000 0000 FF58 7D7D 83FF 0000 0000 0000"            /* ....X}}...... */
	$"0000 00FF FFFF FFFF FFFF FFFF FF00 0000"            /* ...... */
	$"6973 3332 0000 0204 85FF 8000 89FF 0400"            /* is32....... */
	$"7766 5900 84FF 0800 00FF 0083 6666 5600"            /* wfY.....ffV. */
	$"83FF 0800 6C66 004B 7466 664F 8000 81FF"            /* ..lf.KtffO. */
	$"1800 7964 0077 6666 6146 0066 5C00 FFFF"            /* ..yd.wffaF.f\. */
	$"005E 665E 0088 6666 5B00 8066 0C00 FFFF"            /* .^f^.ff[.f.. */
	$"0074 665B 437C 6666 5200 8066 1000 FFFF"            /* .tf[C|ffR.f.. */
	$"007F 6666 5E66 6664 003D 6966 6600 80FF"            /* ..ff^ffd.=iff. */
	$"0600 6659 7966 665A 8266 0000 81FF 0200"            /* ..fYyffZf.... */
	$"3983 8466 015C 0082 FF01 0083 8266 0260"            /* 9f.\...f.` */
	$"4F00 83FF 0500 8E66 6658 4680 0084 FF05"            /* O...ffXF.. */
	$"008E 6666 5200 87FF 0500 8E66 6652 0087"            /* .ffR...ffR. */
	$"FF05 0083 6666 5200 86FF 8700 80FF 85FF"            /* ..ffR.. */
	$"8000 89FF 0400 A499 8600 84FF 0800 00FF"            /* ....... */
	$"00AD 9999 8000 83FF 0800 8F99 006A A399"            /* .....j */
	$"9977 8000 81FF 3C00 A697 009F 9999 9269"            /* w.<..i */
	$"0099 8900 FFFF 007D 998D 00B0 9999 8800"            /* ...}.. */
	$"8699 9900 FFFF 0099 9988 60A8 9999 7C00"            /* ..`|. */
	$"8699 9900 FFFF 00A9 9999 8199 9997 0057"            /* ...W */
	$"9199 9900 80FF 0600 9986 A699 9986 8299"            /* ... */
	$"0000 81FF 0200 54AD 8499 018B 0082 FF01"            /* ....T... */
	$"00AD 8299 028F 7600 83FF 0500 B399 9984"            /* ..v... */
	$"6A80 0084 FF05 00B3 9999 7C00 87FF 0500"            /* j...|... */
	$"B399 997C 0087 FF05 00AD 9999 7C00 86FF"            /* |...|. */
	$"8700 80FF 85FF 8000 89FF 0100 1C80 0084"            /* ...... */
	$"FF04 0000 FF00 3181 0083 FF05 0025 0000"            /* ....1...%.. */
	$"0F18 8300 81FF 0400 2000 0025 8500 03FF"            /* ..... ..%.. */
	$"FF00 2080 0000 3981 0000 2380 0007 FFFF"            /* . ..9..#.. */
	$"0029 0000 0825 8100 0023 8000 06FF FF00"            /* .)...%..#... */
	$"2900 0018 8100 010A 1880 0080 FF80 0000"            /* )......... */
	$"2086 0081 FF02 0002 3186 0082 FF01 0031"            /*  ....1...1 */
	$"8500 83FF 0100 4284 0084 FF01 0042 8100"            /* ...B...B. */
	$"87FF 0100 4281 0087 FF01 0031 8100 86FF"            /* ..B...1. */
	$"8700 80FF 7338 6D6B 0000 0108 0000 0000"            /* .s8mk........ */
	$"0000 0000 FFFF FF00 0000 0000 0000 0000"            /* ............. */
	$"0000 00FF FFFF FFFF 0000 0000 0000 00FF"            /* .......... */
	$"FF00 FFFF FFFF FFFF 0000 0000 0000 FFFF"            /* ....... */
	$"FFFF FFFF FFFF FFFF FFFF 0000 0000 FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FF00 00FF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FF00 00FF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FF00 00FF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 00FF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"            /* ...... */
	$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"            /* ....... */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 00FF"            /* ......... */
	$"FFFF FFFF FFFF FFFF FF00 0000 4943 4E23"            /* ...ICN# */
	$"0000 0108 0000 0000 000F C000 001B E000"            /* .............. */
	$"0033 E000 0037 F000 006F F000 1F6F F000"            /* .3..7..o..o. */
	$"37DF F700 2FDF FF80 6F9F F7C0 5FBF EFC0"            /* 7./o_ */
	$"5FBF EFC0 DF7F EFC0 BF7F EFC0 BF7F EFC0"            /* _... */
	$"BF7F EFC0 BEFF FFC0 7EFF FFC0 3EFF FFE0"            /* .~> */
	$"1EFD FFF0 06F9 FF90 06F9 DF10 04F8 0020"            /* ......  */
	$"05FC 19C0 05FF 3860 05FF B01C 05FF 8002"            /* ...8`.... */
	$"05FF 8077 05FF 801D 07FF 8001 07FF C402"            /* .w...... */
	$"3FFF FBFC 0000 0000 000F C000 001F E000"            /* ?.......... */
	$"003F E000 003F F000 007F F000 1F7F F000"            /* .?..?....... */
	$"3FFF F700 3FFF FF80 7FFF FFC0 7FFF FFC0"            /* ?.?.. */
	$"7FFF FFC0 FFFF FFC0 FFFF FFC0 FFFF FFC0"            /* . */
	$"FFFF FFC0 FFFF FFC0 7FFF FFC0 3FFF FFE0"            /* .? */
	$"1FFF FFF0 07FF FFF0 07FF FFF0 07FF FFE0"            /* .... */
	$"07FF FFC0 07FF FFE0 07FF FFFC 07FF FFFE"            /* .... */
	$"07FF FFFF 07FF FFFF 07FF FFFF 07FF FFFE"            /* .... */
	$"3FFF FBFC 6963 6C34 0000 0208 0000 0000"            /* ?icl4........ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 FFFF FF00 0000 0000 0000 0000 0000"            /* ............. */
	$"000F AB88 89F0 0000 0000 0000 0000 0000"            /* ............ */
	$"00F9 8B88 88F0 0000 0000 0000 0000 0000"            /* ........... */
	$"00F8 B888 889F 0000 0000 0000 0000 0000"            /* ........... */
	$"0FAB 8888 889F 0000 0000 0000 000F FFFF"            /* ......... */
	$"0FBB 8888 899F 0000 0000 0000 00FA B88A"            /* ........ */
	$"F9B8 8888 89AF 0FFF 0000 0000 00FB 8889"            /* ...... */
	$"F8B8 8888 89AF F999 F000 0000 0FBB 88A9"            /* .... */
	$"F8B8 8888 99FF B889 9F00 0000 0FB8 88A9"            /* .... */
	$"FB88 8888 99FB 8888 9F00 0000 0FB8 889F"            /* .... */
	$"AB88 8888 99FB 8888 9F00 0000 F9B8 889F"            /* ... */
	$"B888 8888 9FEB 8888 9F00 0000 FB88 889F"            /* 눈... */
	$"B888 8889 9F9B 8888 AF00 0000 FB88 88AF"            /* ... */
	$"B888 8889 9F9B 8888 AF00 0000 FB88 889A"            /* ... */
	$"B888 889F F99B 8888 AF00 0000 FB88 889B"            /* ... */
	$"8888 88FA 8888 8888 AF00 0000 0F88 88FB"            /* .... */
	$"8888 8A88 8888 8888 9F00 0000 00FA 88FB"            /* .... */
	$"8888 8AFF 8888 8888 9FF0 0000 000F F9FB"            /* .... */
	$"8888 AF0F 8888 888A FFEF 0000 0000 0F9B"            /* ...... */
	$"8888 FD0F 8FFF A8A9 FDCF 0000 0000 0FAB"            /* ...... */
	$"8888 FC0D FEDD FFFF C0CF 0000 0000 0FB8"            /* ...... */
	$"8888 FC00 0000 00C0 CCF0 0000 0000 0FBB"            /* ......... */
	$"8888 AF00 00CF D0CD FF00 0000 0000 0FB8"            /* ........ */
	$"8888 89FF 00FF F000 0DF0 0000 0000 0FB8"            /* ........ */
	$"8888 899F F0EF D000 00CF FF00 0000 0FB8"            /* ...... */
	$"8888 A99A F000 0000 0000 0DF0 0000 0FB8"            /* ......... */
	$"8888 A99A F000 0000 0FFF DEDF 0000 0FB8"            /* ....... */
	$"8888 A99F E000 0000 00CF FDCF 0000 0F88"            /* ....... */
	$"8888 A99A FC00 0000 0000 C0CF 0000 0F88"            /* ........ */
	$"8888 A99A AFC0 0FC0 0000 00F0 00EE FFFF"            /* ..... */
	$"FFFF FFFF FAFF F0FF FFFF FF00 6963 6C38"            /* .icl8 */
	$"0000 0408 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"8352 7D7D 7DA7 FF00 0000 0000 0000 0000"            /* R}}}......... */
	$"0000 0000 0000 0000 0000 0000 0000 FFA7"            /* .............. */
	$"7D52 7D7D 7D7D FF00 0000 0000 0000 0000"            /* }R}}}}......... */
	$"0000 0000 0000 0000 0000 0000 0000 FF7D"            /* ..............} */
	$"527D 7D7D 7D7D A7FF 0000 0000 0000 0000"            /* R}}}}}........ */
	$"0000 0000 0000 0000 0000 0000 00FF 7D52"            /* .............}R */
	$"7D7D 7D7D 7D7D A7FF 0000 0000 0000 0000"            /* }}}}}}........ */
	$"0000 0000 0000 00FF FFFF FFFF 00FF 7D52"            /* ........}R */
	$"7D7D 7D7D 7DA7 A7FF 0000 0000 0000 0000"            /* }}}}}........ */
	$"0000 0000 0000 FF83 527D 7DAD FFA7 527D"            /* ......R}}R} */
	$"7D7D 7D7D 7DA7 ADFF 00FF FFFF 0000 0000"            /* }}}}}..... */
	$"0000 0000 0000 FF52 7D7D 7DA7 FF7D 527D"            /* ......R}}}}R} */
	$"7D7D 7D7D 7DA7 ADFF FFA7 A7A7 FF00 0000"            /* }}}}}... */
	$"0000 0000 00FF 7D52 7D7D 7DA7 FF7D 527D"            /* .....}R}}}}R} */
	$"7D7D 7D7D A7A7 FFFF 527D 7DA7 A7FF 0000"            /* }}}}R}}.. */
	$"0000 0000 00FF 527D 7D7D 7DA7 FF52 7D7D"            /* .....R}}}}R}} */
	$"7D7D 7D7D A7A7 FF52 7D7D 7D7D A7FF 0000"            /* }}}}R}}}}.. */
	$"0000 0000 00FF 527D 7D7D A7FF 7D52 7D7D"            /* .....R}}}}R}} */
	$"7D7D 7D7D A7A7 FF52 7D7D 7D7D A7FF 0000"            /* }}}}R}}}}.. */
	$"0000 0000 FF83 527D 7D7D A7FF 527D 7D7D"            /* ....R}}}R}}} */
	$"7D7D 7D7D A7FF AC52 7D7D 7D7D A7FF 0000"            /* }}}}R}}}}.. */
	$"0000 0000 FF52 7D7D 7D7D A7FF 527D 7D7D"            /* ....R}}}}R}}} */
	$"7D7D 7DA7 A7FF A77C 7D7D 7D7D 7DFF 0000"            /* }}}|}}}}}.. */
	$"0000 0000 FF52 7D7D 7D7D 7DFF 527D 7D7D"            /* ....R}}}}}R}}} */
	$"7D7D 7DA7 A7FF A77C 7D7D 7D7D 7DFF 0000"            /* }}}|}}}}}.. */
	$"0000 0000 FF52 7D7D 7D7D A77D 527D 7D7D"            /* ....R}}}}}R}}} */
	$"7D7D A7FF FFAD A758 7D7D 7D7D 7DFF 0000"            /* }}X}}}}}.. */
	$"0000 0000 FF52 7D7D 7D7D A752 7D7D 7D7D"            /* ....R}}}}R}}}} */
	$"7D7D FF7D 7D7D 7D7D 7D7D 7D7D 7DFF 0000"            /* }}}}}}}}}}}}.. */
	$"0000 0000 00FF 7D7D 7D7D FF52 7D7D 7D7D"            /* .....}}}}R}}}} */
	$"7D7D 7D7D 7D7D 7D7D 7D7D 7D7D A7FF 0000"            /* }}}}}}}}}}}}.. */
	$"0000 0000 0000 FF7D 7D7D FF52 7D7D 7D7D"            /* ......}}}R}}}} */
	$"7DAD FFFF 7D7D 7D7D 7D7D 7D7D A7FF FF00"            /* }}}}}}}}}. */
	$"0000 0000 0000 00FF FFA7 FF52 7D7D 7D7D"            /* .......R}}}} */
	$"7DFF 00FF 7D7D 7D7D 7D7D 7D7D E9FF ACFF"            /* }.}}}}}}}} */
	$"0000 0000 0000 0000 00FF A752 7D7D 7D7D"            /* .........R}}}} */
	$"FFF8 00FF 7DFF FFFF 7D7D 7DA7 FFF9 F8FF"            /* .}}}} */
	$"0000 0000 0000 0000 00FF 8352 7D7D 7D7D"            /* .........R}}}} */
	$"FFF7 00FA FF81 F9FA FFFF FFFF F800 F7FF"            /* .. */
	$"0000 0000 0000 0000 00FF 527D 7D7D 7D7D"            /* .........R}}}}} */
	$"FFF7 0000 0000 00F5 0000 F600 F6F6 FF00"            /* ......... */
	$"0000 0000 0000 0000 00FF 527D 7D7D 7D7D"            /* .........R}}}}} */
	$"7DFF 0000 0000 F8FF FA00 F6FA FFFF 0000"            /* }....... */
	$"0000 0000 0000 0000 00FF 527D 7D7D 7D7D"            /* .........R}}}}} */
	$"7DA7 FFFF 0000 FFFF FF00 00F5 00FA FF00"            /* }...... */
	$"0000 0000 0000 0000 00FF 527D 7D7D 7D7D"            /* .........R}}}}} */
	$"7DA7 A7FE FF00 FBFF F900 0000 0000 F7FF"            /* }...... */
	$"FFFF 0000 0000 0000 00FF 527D 7D7D 7D7D"            /* .......R}}}}} */
	$"7DA7 A7AD FF00 F5F5 0000 0000 0000 0000"            /* }......... */
	$"00F9 FF00 0000 0000 00FF 527D 7D7D 7D7D"            /* .......R}}}}} */
	$"7DA7 A7AD FF00 0000 0000 0000 00FF FFFF"            /* }........ */
	$"F9FB 81FF 0000 0000 00FF 527D 7D7D 7D7D"            /* .....R}}}}} */
	$"7DA7 A7FF FB00 0000 0000 0000 0000 F8FF"            /* }......... */
	$"FF81 2BFF 0000 0000 00FF 7D7D 7D7D 7D7D"            /* +.....}}}}}} */
	$"7DA7 A7AD FF2B 0000 0000 0000 0000 00F5"            /* }+......... */
	$"F600 F8FF 0000 0000 00FF 7D7D 7D7D 7D7D"            /* ......}}}}}} */
	$"7DA7 A7AD ADFF 2B00 00FF F700 0000 0000"            /* }+....... */
	$"0000 FF00 0000 ACAC FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFAD FFFF FF00 FFFF FFFF FFFF"            /* . */
	$"FFFF 0000 696C 3332 0000 06C7 A9FF 8300"            /* ..il32...ǩ. */
	$"96FF 0200 549F 8066 014C 0094 FF03 004E"            /* ..Tf.L...N */
	$"749F 8166 0000 94FF 0200 6B9F 8266 014C"            /* tf....kf.L */
	$"0092 FF02 0059 9F83 6601 4C00 8CFF 8200"            /* ...Yf.L.. */
	$"03FF 0070 9F82 6602 4C4C 008B FF08 0056"            /* ..pf.LL...V */
	$"9F66 6633 0045 9F83 6603 4C34 00FF 8000"            /* ff3.Ef.L4.. */
	$"87FF 0100 9F80 6603 4F00 629F 8366 034C"            /* ..f.O.bf.L */
	$"2C00 0080 4C00 0085 FF09 0063 9F66 6660"            /* ,..L...cff` */
	$"4600 779F 8266 094C 4C00 009F 6666 4C4C"            /* F.wfLL..ffLL */
	$"0084 FF01 009F 8066 0356 3A00 9F83 6603"            /* ...f.V:.f. */
	$"4C4C 009F 8166 014C 0084 FF01 009F 8066"            /* LL.f.L...f */
	$"034F 005C 9F83 6603 4C4C 009F 8166 014C"            /* .O.\f.LL.f.L */
	$"0083 FF08 0057 9F66 6663 4C00 9F84 6603"            /* ...WffcL.f. */
	$"4C00 329F 8166 014C 0083 FF01 009F 8066"            /* L.2f.L...f */
	$"0361 4C00 9F83 6604 4C4C 004C 7981 6601"            /* .aL.f.LL.Lyf. */
	$"5900 83FF 0100 9F81 6602 5B00 9F83 6604"            /* Y...f.[.f. */
	$"4C4C 004C 7F81 6601 5900 83FF 0100 9F81"            /* LL.L.f.Y... */
	$"6602 4D5C 9F82 6605 4C00 0028 4C86 8166"            /* f.M\f.L..(Lf */
	$"0159 0083 FF01 009F 8166 013D 9F83 6601"            /* .Y...f.=f. */
	$"0060 8566 0157 0084 FF00 0081 6601 009F"            /* .`f.W...f.. */
	$"8266 025F 6363 8566 014C 0085 FF05 0059"            /* f._ccf.L...Y */
	$"6666 009F 8266 0230 0000 8466 0364 4C00"            /* ff.f.0..f.dL. */
	$"0085 FF04 0000 3C00 9F81 6603 5E00 FF00"            /* ....<.f.^.. */
	$"8466 0459 1B00 3E00 86FF 0200 4C9F 8166"            /* f.Y..>...Lf */
	$"0400 A0FF 0066 8000 075E 6056 3900 8FA6"            /* ...f..^`V9. */
	$"0086 FF02 0053 9F81 6607 00BF FF73 0061"            /* ...Sf..s.a */
	$"8777 8100 03A2 FFB5 0086 FF02 009F 7781"            /* w.....w */
	$"6601 00B0 82FF 07EF FFFF DFFF D5DF 0087"            /* f.... */
	$"FF02 009F 7081 6601 5900 81FF 07AF 0070"            /* ..pf.Y...p */
	$"FFD0 7F00 0088 FF02 009F 6B82 6604 3700"            /* .....kf.7. */
	$"00FF FF80 0005 FFFF E0FF 7000 87FF 0100"            /* ...p... */
	$"9F83 6607 4C4C 1500 FF50 0080 82FF 00B0"            /* f.LL..P.. */
	$"8000 84FF 0100 9F82 6607 604C 4C2C 00FF"            /* ...f.`LL,. */
	$"E0E0 86FF 0184 0083 FF01 009F 8266 0460"            /* ....f.` */
	$"4C4C 2C00 85FF 8000 038F 5060 0082 FF01"            /* LL,...P`.. */
	$"009F 8266 0460 4C4C 0056 86FF 05A0 0000"            /* .f.`LL.V... */
	$"60CF 0082 FF01 006D 8266 0560 4C4C 2C00"            /* `...mf.`LL,. */
	$"CF86 FF04 EFDF FFAF 0082 FF00 0083 660A"            /* φ....f */
	$"604C 4C2C 2C00 C0FF FF00 BF84 FF00 0080"            /* `LL,,.... */
	$"FF01 3F3F 8A00 002C 8000 00FF 8500 01FF"            /* .??..,.... */
	$"FFA9 FF83 0096 FF02 007D C980 9901 7100"            /* ...}ɀ.q. */
	$"94FF 0300 74A3 C981 9900 0094 FF02 009C"            /* ..tɁ.... */
	$"C982 9901 7100 92FF 0200 86C9 8399 0171"            /* ɂ.q...Ƀ.q */
	$"008C FF82 0003 FF00 9FC9 8299 0271 7100"            /* ....ɂ.qq. */
	$"8BFF 0800 7BC9 9999 4C00 64C9 8399 0371"            /* ..{əL.dɃ.q */
	$"4A00 FF80 0087 FF01 00C9 8099 0377 0091"            /* J....ɀ.w. */
	$"C983 9903 713D 0000 8071 0000 85FF 0900"            /* Ƀ.q=..q... */
	$"88C9 9999 8F69 00A4 C982 9909 7171 0000"            /* əi.ɂqq.. */
	$"C999 9971 7100 84FF 0100 C980 9903 8057"            /* əqq...ɀ.W */
	$"00C9 8399 0371 7100 C981 9901 7100 84FF"            /* .Ƀ.qq.Ɂ.q. */
	$"0100 C980 9903 7700 88C9 8399 0371 7100"            /* ..ɀ.w.Ƀ.qq. */
	$"C981 9901 7100 83FF 0800 7CC9 9999 9471"            /* Ɂ.q...|əq */
	$"00C9 8499 0371 0032 C981 9901 7100 83FF"            /* .Ʉ.q.2Ɂ.q. */
	$"0100 C980 9903 9271 00C9 8399 0471 7100"            /* ..ɀ.q.Ƀ.qq. */
	$"71A6 8199 0186 0083 FF01 00C9 8199 0288"            /* q....Ɂ. */
	$"00C9 8399 0471 7100 71A9 8199 0186 0083"            /* .Ƀ.qq.q.. */
	$"FF01 00C9 8199 0273 88C9 8299 0571 0000"            /* ..Ɂ.sɂ.q.. */
	$"3171 AE81 9901 8600 83FF 0100 C981 9901"            /* 1q....Ɂ. */
	$"5AC9 8399 0100 8F85 9901 8300 84FF 0000"            /* ZɃ...... */
	$"8199 0100 C982 9902 8D95 9485 9901 7100"            /* ..ɂ..q. */
	$"85FF 0500 8699 9900 C982 9902 4800 0084"            /* ...ɂ.H.. */
	$"9903 9771 0000 85FF 0400 0058 00C9 8199"            /* .q.....X.Ɂ */
	$"038D 00FF 0084 9904 8628 003E 0086 FF02"            /* ....(.>.. */
	$"0073 C981 9904 00A1 FF00 9980 0007 8D90"            /* .sɁ..... */
	$"8157 008F A600 86FF 0200 7CC9 8199 0700"            /* W....|Ɂ.. */
	$"BFFF 7400 628B 7B81 0003 A2FF B500 86FF"            /* t.b{... */
	$"0200 C9A4 8199 0100 B182 FF07 EFFF FFDF"            /* ..ɤ... */
	$"FFD5 DF00 87FF 0200 C99F 8199 0186 0081"            /* ...ɟ.. */
	$"FF07 AF00 70FF D07F 0000 88FF 0200 C99C"            /* ..p.....ɜ */
	$"8299 0452 0000 FFFF 8000 05FF FFE0 FF70"            /* .R....p */
	$"0087 FF01 00C9 8399 0771 7115 00FF 5000"            /* ...Ƀ.qq..P. */
	$"8082 FF00 B080 0084 FF01 00C9 8299 078F"            /* ....ɂ. */
	$"7171 3D00 FFE0 E086 FF01 8400 83FF 0100"            /* qq=..... */
	$"C982 9904 8F71 713D 0085 FF80 0003 8F50"            /* ɂ.qq=...P */
	$"6000 82FF 0100 C982 9904 8F71 7100 5686"            /* `...ɂ.qq.V */
	$"FF05 A000 0060 CF00 82FF 0100 9E82 9905"            /* ...`.... */
	$"8F71 713D 00CF 86FF 04EF DFFF AF00 82FF"            /* qq=.φ.. */
	$"0000 8399 0A8F 7171 3D3D 00C0 FFFF 00BF"            /* ..qq==.. */
	$"84FF 0000 80FF 013F 3F8A 0000 3D80 0000"            /* ...??..=.. */
	$"FF85 0001 FFFF A9FF 8300 96FF 0200 014A"            /* ......J */
	$"8200 94FF 0300 0218 4A82 0094 FF02 0008"            /* .....J.... */
	$"4A84 0092 FF02 0000 4A85 008C FF82 0003"            /* J....J... */
	$"FF00 104A 8500 8BFF 0200 0D4A 8100 0105"            /* ..J....J... */
	$"4A84 0002 0700 FF80 0087 FF01 004A 8200"            /* J.......J. */
	$"0104 4A84 0000 0983 0085 FF02 0018 4A82"            /* ..J..ƃ....J */
	$"0001 1C4A 8600 004A 8200 84FF 0100 4A83"            /* ...J..J...J */
	$"0000 4A86 0000 4A83 0084 FF01 004A 8200"            /* ..J..J...J. */
	$"0104 4A86 0000 4A83 0083 FF02 0010 4A82"            /* ..J..J....J */
	$"0000 4A86 0001 324A 8300 83FF 0100 4A83"            /* ..J..2J...J */
	$"0000 4A87 0000 2083 0083 FF01 004A 8300"            /* ..J.. ...J. */
	$"004A 8700 0029 8300 83FF 0100 4A82 0001"            /* .J..)...J.. */
	$"044A 8500 0215 0035 8300 83FF 0100 4A82"            /* .J....5...J */
	$"0000 4A8F 0084 FF83 0000 4A8F 0085 FF82"            /* ..J...J. */
	$"0000 4A90 0085 FF04 0000 0300 4A83 0000"            /* ..J......J.. */
	$"FF88 0001 3E00 86FF 0200 004A 8200 019E"            /* ..>....J.. */
	$"FF87 0002 8FA6 0086 FF02 0000 4A82 0006"            /* ......J.. */
	$"BFFF 6F00 5F80 7081 0003 A2FF B500 86FF"            /* o._p... */
	$"0200 4A1C 8200 00AE 82FF 07EF FFFF DFFF"            /* ..J.... */
	$"D5DF 0087 FF02 004A 1083 0081 FF07 AF00"            /* ...J.... */
	$"70FF D07F 0000 88FF 0200 4A08 8500 01FF"            /* p.....J... */
	$"FF80 0005 FFFF E0FF 7000 87FF 0100 4A85"            /* ..p...J */
	$"0005 1500 FF50 0080 82FF 00B0 8000 84FF"            /* ....P... */
	$"0100 4A85 0004 0900 FFE0 E086 FF01 8400"            /* ..J..... */
	$"83FF 0100 4A85 0001 0900 85FF 8000 038F"            /* ..J..... */
	$"5060 0082 FF01 004A 8600 0056 86FF 05A0"            /* P`...J..V. */
	$"0000 60CF 0082 FF01 000C 8500 0209 00CF"            /* ..`....... */
	$"86FF 04EF DFFF AF00 82FF 8700 0709 0900"            /* ..... */
	$"C0FF FF00 BF84 FF00 0080 FF01 3F3F 8A00"            /* ....??. */
	$"0009 8000 00FF 8500 01FF FF6C 386D 6B00"            /* .ƀ....l8mk. */
	$"0004 0800 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"FFFF FFFF FF00 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 0000 0000 0000 0000 FFFF"            /* .............. */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 0000 0000 0000 0000 0000 00FF FFFF"            /* ............. */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 0000 0000 0000 0000 0000 00FF FFFF"            /* ............. */
	$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 FFFF FFFF"            /* ............ */
	$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 FFFF FFFF FF00 FFFF FFFF"            /* ....... */
	$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FF00 FFFF FF00 0000 0000"            /* ...... */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* .... */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .. */
	$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"            /* . */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"            /* . */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"            /* . */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .. */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .. */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FF00 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ....... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF00 0000 0000 FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF00 0000 0000 FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF00 0000 0000 FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF 00FF FFFF FFFF FFFF"            /* . */
	$"FF00 0069 6368 2300 0002 48FF FFFF FFFF"            /* ..ich#...H */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFF8 0000 0000 0FF8"            /* ..... */
	$"0000 0000 0FF8 0000 0000 0FF8 0000 0000"            /* .............. */
	$"0FF8 000F C000 0FF8 001B E000 0FF8 0033"            /* ..........3 */
	$"E000 0FF8 0037 F000 0FF8 006F F000 0FF8"            /* ...7...o.. */
	$"1F6F F000 0FF8 37DF F700 0FF8 2FDF FF80"            /* .o..7../ */
	$"0FF8 6F9F F7C0 0FF8 5FBF EFC0 0FF8 5FBF"            /* .o._._ */
	$"EFC0 0FF8 DF7F EFC0 0FF8 BF7F EFC0 0FF8"            /* ..... */
	$"BF7F EFC0 0FF8 BF7F EFC0 0FF8 BEFF FFC0"            /* .... */
	$"0FF8 7EFF FFC0 0FF8 3EFF FFE0 0FF8 1EFD"            /* .~.>.. */
	$"FFF0 0FF8 06F9 FF90 0FF8 06F9 DF10 0FF8"            /* ...... */
	$"04F8 0020 0FF8 05FC 19C0 0FF8 05FF 3860"            /* .. .....8` */
	$"0FF8 05FF B01C 0FF8 05FF 8002 0FF8 05FF"            /* ........ */
	$"8077 0FF8 05FF 801D 0FF8 07FF 8001 0FF8"            /* w....... */
	$"07FF C402 0FF8 3FFF FBFC 0FF8 0000 0000"            /* ...?..... */
	$"0FF8 0000 0000 0FF8 0000 0000 0FFF FFFF"            /* ........... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ..... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 000F C000 0000 001F E000 0000 003F"            /* .............? */
	$"E000 0000 003F F000 0000 007F F000 0000"            /* ....?........ */
	$"1F7F F000 0000 3FFF F700 0000 3FFF FF80"            /* .....?...? */
	$"0000 7FFF FFC0 0000 7FFF FFC0 0000 7FFF"            /* ......... */
	$"FFC0 0000 FFFF FFC0 0000 FFFF FFC0 0000"            /* ...... */
	$"FFFF FFC0 0000 FFFF FFC0 0000 FFFF FFC0"            /* .... */
	$"0000 7FFF FFC0 0000 3FFF FFE0 0000 1FFF"            /* .....?... */
	$"FFF0 0000 07FF FFF0 0000 07FF FFF0 0000"            /* ........ */
	$"07FF FFE0 0000 07FF FFC0 0000 07FF FFE0"            /* ....... */
	$"0000 07FF FFFC 0000 07FF FFFE 0000 07FF"            /* ......... */
	$"FFFF 0000 07FF FFFF 0000 07FF FFFF 0000"            /* ........ */
	$"07FF FFFE 0000 3FFF FBFC 0000 0000 0000"            /* ...?...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0069 6368 3400"            /* ...........ich4. */
	$"0004 88FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFF0 0000"            /* .. */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"00FF FFFF FFF0 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 0000 00FF FFFF FFF0 0000"            /* ........... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"00FF FFFF FFF0 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 0000 00FF FFFF FFF0 0000"            /* ........... */
	$"0000 0000 00FF FFFF 0000 0000 0000 0000"            /* ............. */
	$"00FF FFFF FFF0 0000 0000 0000 0FAB 8889"            /* ........ */
	$"F000 0000 0000 0000 00FF FFFF FFF0 0000"            /* .......... */
	$"0000 0000 F98B 8888 F000 0000 0000 0000"            /* ........... */
	$"00FF FFFF FFF0 0000 0000 0000 F8B8 8888"            /* ....... */
	$"9F00 0000 0000 0000 00FF FFFF FFF0 0000"            /* .......... */
	$"0000 000F AB88 8888 9F00 0000 0000 0000"            /* ........... */
	$"00FF FFFF FFF0 0000 0FFF FF0F BB88 8889"            /* ..... */
	$"9F00 0000 0000 0000 00FF FFFF FFF0 0000"            /* .......... */
	$"FAB8 8AF9 B888 8889 AF0F FF00 0000 0000"            /* ...... */
	$"00FF FFFF FFF0 0000 FB88 89F8 B888 8889"            /* ... */
	$"AFF9 99F0 0000 0000 00FF FFFF FFF0 000F"            /* ....... */
	$"BB88 A9F8 B888 8899 FFB8 899F 0000 0000"            /* .... */
	$"00FF FFFF FFF0 000F B888 A9FB 8888 8899"            /* ... */
	$"FB88 889F 0000 0000 00FF FFFF FFF0 000F"            /* ....... */
	$"B888 9FAB 8888 8899 FB88 889F 0000 0000"            /* .... */
	$"00FF FFFF FFF0 00F9 B888 9FB8 8888 889F"            /* .. */
	$"EB88 889F 0000 0000 00FF FFFF FFF0 00FB"            /* 눈...... */
	$"8888 9FB8 8888 899F 9B88 88AF 0000 0000"            /* .... */
	$"00FF FFFF FFF0 00FB 8888 AFB8 8888 899F"            /* .. */
	$"9B88 88AF 0000 0000 00FF FFFF FFF0 00FB"            /* ...... */
	$"8888 9AB8 8888 9FF9 9B88 88AF 0000 0000"            /* .... */
	$"00FF FFFF FFF0 00FB 8888 9B88 8888 FA88"            /* .. */
	$"8888 88AF 0000 0000 00FF FFFF FFF0 000F"            /* ....... */
	$"8888 FB88 888A 8888 8888 889F 0000 0000"            /* .... */
	$"00FF FFFF FFF0 0000 FA88 FB88 888A FF88"            /* ... */
	$"8888 889F F000 0000 00FF FFFF FFF0 0000"            /* ...... */
	$"0FF9 FB88 88AF 0F88 8888 8AFF EF00 0000"            /* ..... */
	$"00FF FFFF FFF0 0000 000F 9B88 88FD 0F8F"            /* ...... */
	$"FFA8 A9FD CF00 0000 00FF FFFF FFF0 0000"            /* ...... */
	$"000F AB88 88FC 0DFE DDFF FFC0 CF00 0000"            /* ...... */
	$"00FF FFFF FFF0 0000 000F B888 88FC 0000"            /* ....... */
	$"0000 C0CC F000 0000 00FF FFFF FFF0 0000"            /* ........ */
	$"000F BB88 88AF 0000 CFD0 CDFF 0000 0000"            /* ........ */
	$"00FF FFFF FFF0 0000 000F B888 8889 FF00"            /* ...... */
	$"FFF0 000D F000 0000 00FF FFFF FFF0 0000"            /* ........ */
	$"000F B888 8889 9FF0 EFD0 0000 CFFF 0000"            /* ...... */
	$"00FF FFFF FFF0 0000 000F B888 88A9 9AF0"            /* ..... */
	$"0000 0000 000D F000 00FF FFFF FFF0 0000"            /* .......... */
	$"000F B888 88A9 9AF0 0000 000F FFDE DF00"            /* ....... */
	$"00FF FFFF FFF0 0000 000F B888 88A9 9FE0"            /* ..... */
	$"0000 0000 CFFD CF00 00FF FFFF FFF0 0000"            /* ........ */
	$"000F 8888 88A9 9AFC 0000 0000 00C0 CF00"            /* ........ */
	$"00FF FFFF FFF0 0000 000F 8888 88A9 9AAF"            /* ..... */
	$"C00F C000 0000 F000 00FF FFFF FFF0 0000"            /* ........ */
	$"EEFF FFFF FFFF FFFA FFF0 FFFF FFFF 0000"            /* .. */
	$"00FF FFFF FFF0 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 0000 00FF FFFF FFF0 0000"            /* ........... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"00FF FFFF FFF0 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"            /* ......... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF69 6368 3800 0009 08FF FFFF FFFF"            /* ich8... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"FFFF FFFF FF00 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 FF83"            /* .............. */
	$"527D 7D7D A7FF 0000 0000 0000 0000 0000"            /* R}}}.......... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 00FF A77D"            /* .............} */
	$"527D 7D7D 7DFF 0000 0000 0000 0000 0000"            /* R}}}}.......... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 00FF 7D52"            /* .............}R */
	$"7D7D 7D7D 7DA7 FF00 0000 0000 0000 0000"            /* }}}}}......... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 FF7D 527D"            /* ............}R} */
	$"7D7D 7D7D 7DA7 FF00 0000 0000 0000 0000"            /* }}}}}......... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 FFFF FFFF FF00 FF7D 527D"            /* .......}R} */
	$"7D7D 7D7D A7A7 FF00 0000 0000 0000 0000"            /* }}}}......... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 00FF 8352 7D7D ADFF A752 7D7D"            /* .....R}}R}} */
	$"7D7D 7D7D A7AD FF00 FFFF FF00 0000 0000"            /* }}}}...... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 00FF 527D 7D7D A7FF 7D52 7D7D"            /* .....R}}}}R}} */
	$"7D7D 7D7D A7AD FFFF A7A7 A7FF 0000 0000"            /* }}}}.... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 FF7D 527D 7D7D A7FF 7D52 7D7D"            /* ....}R}}}}R}} */
	$"7D7D 7DA7 A7FF FF52 7D7D A7A7 FF00 0000"            /* }}}R}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 FF52 7D7D 7D7D A7FF 527D 7D7D"            /* ....R}}}}R}}} */
	$"7D7D 7DA7 A7FF 527D 7D7D 7DA7 FF00 0000"            /* }}}R}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 FF52 7D7D 7DA7 FF7D 527D 7D7D"            /* ....R}}}}R}}} */
	$"7D7D 7DA7 A7FF 527D 7D7D 7DA7 FF00 0000"            /* }}}R}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 00FF 8352 7D7D 7DA7 FF52 7D7D 7D7D"            /* ...R}}}R}}}} */
	$"7D7D 7DA7 FFAC 527D 7D7D 7DA7 FF00 0000"            /* }}}R}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 00FF 527D 7D7D 7DA7 FF52 7D7D 7D7D"            /* ...R}}}}R}}}} */
	$"7D7D A7A7 FFA7 7C7D 7D7D 7D7D FF00 0000"            /* }}|}}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 00FF 527D 7D7D 7D7D FF52 7D7D 7D7D"            /* ...R}}}}}R}}}} */
	$"7D7D A7A7 FFA7 7C7D 7D7D 7D7D FF00 0000"            /* }}|}}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 00FF 527D 7D7D 7DA7 7D52 7D7D 7D7D"            /* ...R}}}}}R}}}} */
	$"7DA7 FFFF ADA7 587D 7D7D 7D7D FF00 0000"            /* }X}}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 00FF 527D 7D7D 7DA7 527D 7D7D 7D7D"            /* ...R}}}}R}}}}} */
	$"7DFF 7D7D 7D7D 7D7D 7D7D 7D7D FF00 0000"            /* }}}}}}}}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 FF7D 7D7D 7DFF 527D 7D7D 7D7D"            /* ....}}}}R}}}}} */
	$"7D7D 7D7D 7D7D 7D7D 7D7D 7DA7 FF00 0000"            /* }}}}}}}}}}}... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 00FF 7D7D 7DFF 527D 7D7D 7D7D"            /* .....}}}R}}}}} */
	$"ADFF FF7D 7D7D 7D7D 7D7D 7DA7 FFFF 0000"            /* }}}}}}}}.. */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 FFFF A7FF 527D 7D7D 7D7D"            /* ......R}}}}} */
	$"FF00 FF7D 7D7D 7D7D 7D7D 7DE9 FFAC FF00"            /* .}}}}}}}}. */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 FFA7 527D 7D7D 7DFF"            /* ........R}}}} */
	$"F800 FF7D FFFF FF7D 7D7D A7FF F9F8 FF00"            /* .}}}}. */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 FF83 527D 7D7D 7DFF"            /* ........R}}}} */
	$"F700 FAFF 81F9 FAFF FFFF FFF8 00F7 FF00"            /* ... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7DFF"            /* ........R}}}}} */
	$"F700 0000 0000 F500 00F6 00F6 F6FF 0000"            /* .......... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7D7D"            /* ........R}}}}}} */
	$"FF00 0000 00F8 FFFA 00F6 FAFF FF00 0000"            /* ........ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7D7D"            /* ........R}}}}}} */
	$"A7FF FF00 00FF FFFF 0000 F500 FAFF 0000"            /* ....... */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7D7D"            /* ........R}}}}}} */
	$"A7A7 FEFF 00FB FFF9 0000 0000 00F7 FFFF"            /* ...... */
	$"FF00 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7D7D"            /* ........R}}}}}} */
	$"A7A7 ADFF 00F5 F500 0000 0000 0000 0000"            /* .......... */
	$"F9FF 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ..... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7D7D"            /* ........R}}}}}} */
	$"A7A7 ADFF 0000 0000 0000 0000 FFFF FFF9"            /* ........ */
	$"FB81 FF00 0000 00FF FFFF FFFF FFFF FFFF"            /* .... */
	$"0000 0000 0000 0000 FF52 7D7D 7D7D 7D7D"            /* ........R}}}}}} */
	$"A7A7 FFFB 0000 0000 0000 0000 00F8 FFFF"            /* ......... */
	$"812B FF00 0000 00FF FFFF FFFF FFFF FFFF"            /* +.... */
	$"0000 0000 0000 0000 FF7D 7D7D 7D7D 7D7D"            /* ........}}}}}}} */
	$"A7A7 ADFF 2B00 0000 0000 0000 0000 F5F6"            /* +......... */
	$"00F8 FF00 0000 00FF FFFF FFFF FFFF FFFF"            /* ..... */
	$"0000 0000 0000 0000 FF7D 7D7D 7D7D 7D7D"            /* ........}}}}}}} */
	$"A7A7 ADAD FF2B 0000 FFF7 0000 0000 0000"            /* +........ */
	$"00FF 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"0000 0000 00AC ACFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF ADFF FFFF 00FF FFFF FFFF FFFF"            /* . */
	$"FF00 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"            /* ....... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF69 6833 3200"            /* ih32. */
	$"0008 98FF 00F0 00A4 FF86 00A4 FF86 00A4"            /* ...... */
	$"FF86 00A4 FF86 008C FF83 008F FF86 008B"            /* .... */
	$"FF02 0054 9F80 6601 4C00 8EFF 8600 8AFF"            /* ..Tf.L.. */
	$"0300 4E74 9F81 6600 008E FF86 008A FF02"            /* ..Ntf.... */
	$"006B 9F82 6601 4C00 8DFF 8600 89FF 0200"            /* .kf.L.... */
	$"599F 8366 014C 008D FF86 0083 FF82 0003"            /* Yf.L.... */
	$"FF00 709F 8266 024C 4C00 8DFF 8600 82FF"            /* .pf.LL.. */
	$"0800 569F 6666 3300 459F 8366 034C 3400"            /* ..Vff3.Ef.L4. */
	$"FF80 0089 FF86 0082 FF01 009F 8066 034F"            /* ....f.O */
	$"0062 9F83 6603 4C2C 0000 804C 0000 88FF"            /* .bf.L,..L.. */
	$"8600 81FF 0900 639F 6666 6046 0077 9F82"            /* ..cff`F.w */
	$"6609 4C4C 0000 9F66 664C 4C00 87FF 8600"            /* fLL..ffLL.. */
	$"81FF 0100 9F80 6603 563A 009F 8366 034C"            /* ..f.V:.f.L */
	$"4C00 9F81 6601 4C00 87FF 8600 81FF 0100"            /* L.f.L.... */
	$"9F80 6603 4F00 5C9F 8366 034C 4C00 9F81"            /* f.O.\f.LL. */
	$"6601 4C00 87FF 8600 80FF 0800 579F 6666"            /* f.L....Wff */
	$"634C 009F 8466 034C 0032 9F81 6601 4C00"            /* cL.f.L.2f.L. */
	$"87FF 8600 80FF 0100 9F80 6603 614C 009F"            /* ...f.aL. */
	$"8366 044C 4C00 4C79 8166 0159 0087 FF86"            /* f.LL.Lyf.Y. */
	$"0080 FF01 009F 8166 025B 009F 8366 044C"            /* ...f.[.f.L */
	$"4C00 4C7F 8166 0159 0087 FF86 0080 FF01"            /* L.L.f.Y... */
	$"009F 8166 024D 5C9F 8266 054C 0000 284C"            /* .f.M\f.L..(L */
	$"8681 6601 5900 87FF 8600 80FF 0100 9F81"            /* f.Y.... */
	$"6601 3D9F 8366 0100 6085 6601 5700 87FF"            /* f.=f..`f.W. */
	$"8600 81FF 0000 8166 0100 9F82 6602 5F63"            /* ...f..f._c */
	$"6385 6601 4C00 87FF 8600 82FF 0500 5966"            /* cf.L....Yf */
	$"6600 9F82 6602 3000 0084 6603 644C 0000"            /* f.f.0..f.dL.. */
	$"86FF 8600 83FF 0400 003C 009F 8166 035E"            /* ....<.f.^ */
	$"00FF 0084 6604 591B 003E 0085 FF86 0085"            /* ..f.Y..>.. */
	$"FF02 004C 9F81 6604 00A0 FF00 6680 0007"            /* ..Lf...f.. */
	$"5E60 5639 008F A600 85FF 8600 85FF 0200"            /* ^`V9..... */
	$"539F 8166 0700 BFFF 7300 6187 7781 0003"            /* Sf..s.aw.. */
	$"A2FF B500 85FF 8600 85FF 0200 9F77 8166"            /* ....wf */
	$"0100 B082 FF07 EFFF FFDF FFD5 DF00 86FF"            /* .... */
	$"8600 85FF 0200 9F70 8166 0159 0081 FF07"            /* ...pf.Y.. */
	$"AF00 70FF D07F 0000 87FF 8600 85FF 0200"            /* .p...... */
	$"9F6B 8266 0437 0000 FFFF 8000 05FF FFE0"            /* kf.7.... */
	$"FF70 0086 FF86 0085 FF01 009F 8366 074C"            /* p....f.L */
	$"4C15 00FF 5000 8082 FF00 B080 0083 FF86"            /* L..P... */
	$"0085 FF01 009F 8266 0760 4C4C 2C00 FFE0"            /* ...f.`LL,. */
	$"E086 FF01 8400 82FF 8600 85FF 0100 9F82"            /* ..... */
	$"6604 604C 4C2C 0085 FF80 0003 8F50 6000"            /* f.`LL,...P`. */
	$"81FF 8600 85FF 0100 9F82 6604 604C 4C00"            /* ...f.`LL. */
	$"5686 FF05 A000 0060 CF00 81FF 8600 85FF"            /* V...`.. */
	$"0100 6D82 6605 604C 4C2C 00CF 86FF 04EF"            /* ..mf.`LL,.φ. */
	$"DFFF AF00 81FF 8600 85FF 0000 8366 0A60"            /* ....f` */
	$"4C4C 2C2C 00C0 FFFF 00BF 84FF 0000 82FF"            /* LL,,.... */
	$"8600 82FF 013F 3F8A 0000 2C80 0000 FF85"            /* ..??..,.. */
	$"0083 FF86 00A4 FF86 00A4 FF86 00A4 FFFF"            /* .... */
	$"00EF 00FF 00F0 00A4 FF86 00A4 FF86 00A4"            /* ...... */
	$"FF86 00A4 FF86 008C FF83 008F FF86 008B"            /* .... */
	$"FF02 007D C980 9901 7100 8EFF 8600 8AFF"            /* ..}ɀ.q.. */
	$"0300 74A3 C981 9900 008E FF86 008A FF02"            /* ..tɁ.... */
	$"009C C982 9901 7100 8DFF 8600 89FF 0200"            /* .ɂ.q.... */
	$"86C9 8399 0171 008D FF86 0083 FF82 0003"            /* Ƀ.q.... */
	$"FF00 9FC9 8299 0271 7100 8DFF 8600 82FF"            /* .ɂ.qq.. */
	$"0800 7BC9 9999 4C00 64C9 8399 0371 4A00"            /* ..{əL.dɃ.qJ. */
	$"FF80 0089 FF86 0082 FF01 00C9 8099 0377"            /* ....ɀ.w */
	$"0091 C983 9903 713D 0000 8071 0000 88FF"            /* .Ƀ.q=..q.. */
	$"8600 81FF 0900 88C9 9999 8F69 00A4 C982"            /* ..əi.ɂ */
	$"9909 7171 0000 C999 9971 7100 87FF 8600"            /* qq..əqq.. */
	$"81FF 0100 C980 9903 8057 00C9 8399 0371"            /* ..ɀ.W.Ƀ.q */
	$"7100 C981 9901 7100 87FF 8600 81FF 0100"            /* q.Ɂ.q.... */
	$"C980 9903 7700 88C9 8399 0371 7100 C981"            /* ɀ.w.Ƀ.qq.Ɂ */
	$"9901 7100 87FF 8600 80FF 0800 7CC9 9999"            /* .q....|ə */
	$"9471 00C9 8499 0371 0032 C981 9901 7100"            /* q.Ʉ.q.2Ɂ.q. */
	$"87FF 8600 80FF 0100 C980 9903 9271 00C9"            /* ...ɀ.q. */
	$"8399 0471 7100 71A6 8199 0186 0087 FF86"            /* .qq.q.. */
	$"0080 FF01 00C9 8199 0288 00C9 8399 0471"            /* ...Ɂ..Ƀ.q */
	$"7100 71A9 8199 0186 0087 FF86 0080 FF01"            /* q.q.... */
	$"00C9 8199 0273 88C9 8299 0571 0000 3171"            /* .Ɂ.sɂ.q..1q */
	$"AE81 9901 8600 87FF 8600 80FF 0100 C981"            /* .....Ɂ */
	$"9901 5AC9 8399 0100 8F85 9901 8300 87FF"            /* .ZɃ.... */
	$"8600 81FF 0000 8199 0100 C982 9902 8D95"            /* .....ɂ. */
	$"9485 9901 7100 87FF 8600 82FF 0500 8699"            /* .q.... */
	$"9900 C982 9902 4800 0084 9903 9771 0000"            /* .ɂ.H...q.. */
	$"86FF 8600 83FF 0400 0058 00C9 8199 038D"            /* ....X.Ɂ. */
	$"00FF 0084 9904 8628 003E 0085 FF86 0085"            /* ...(.>.. */
	$"FF02 0073 C981 9904 00A1 FF00 9980 0007"            /* ..sɁ..... */
	$"8D90 8157 008F A600 85FF 8600 85FF 0200"            /* W..... */
	$"7CC9 8199 0700 BFFF 7400 628B 7B81 0003"            /* |Ɂ..t.b{.. */
	$"A2FF B500 85FF 8600 85FF 0200 C9A4 8199"            /* ....ɤ */
	$"0100 B182 FF07 EFFF FFDF FFD5 DF00 86FF"            /* .... */
	$"8600 85FF 0200 C99F 8199 0186 0081 FF07"            /* ...ɟ... */
	$"AF00 70FF D07F 0000 87FF 8600 85FF 0200"            /* .p...... */
	$"C99C 8299 0452 0000 FFFF 8000 05FF FFE0"            /* ɜ.R.... */
	$"FF70 0086 FF86 0085 FF01 00C9 8399 0771"            /* p....Ƀ.q */
	$"7115 00FF 5000 8082 FF00 B080 0083 FF86"            /* q..P... */
	$"0085 FF01 00C9 8299 078F 7171 3D00 FFE0"            /* ...ɂ.qq=. */
	$"E086 FF01 8400 82FF 8600 85FF 0100 C982"            /* .....ɂ */
	$"9904 8F71 713D 0085 FF80 0003 8F50 6000"            /* .qq=...P`. */
	$"81FF 8600 85FF 0100 C982 9904 8F71 7100"            /* ...ɂ.qq. */
	$"5686 FF05 A000 0060 CF00 81FF 8600 85FF"            /* V...`.. */
	$"0100 9E82 9905 8F71 713D 00CF 86FF 04EF"            /* ...qq=.φ. */
	$"DFFF AF00 81FF 8600 85FF 0000 8399 0A8F"            /* .... */
	$"7171 3D3D 00C0 FFFF 00BF 84FF 0000 82FF"            /* qq==.... */
	$"8600 82FF 013F 3F8A 0000 3D80 0000 FF85"            /* ..??..=.. */
	$"0083 FF86 00A4 FF86 00A4 FF86 00A4 FFFF"            /* .... */
	$"00EF 00FF 00F0 00A4 FF86 00A4 FF86 00A4"            /* ...... */
	$"FF86 00A4 FF86 008C FF83 008F FF86 008B"            /* .... */
	$"FF02 0001 4A82 008E FF86 008A FF03 0002"            /* ...J..... */
	$"184A 8200 8EFF 8600 8AFF 0200 084A 8400"            /* .J.....J. */
	$"8DFF 8600 89FF 0200 004A 8500 8DFF 8600"            /* ....J.. */
	$"83FF 8200 03FF 0010 4A85 008D FF86 0082"            /* ....J.. */
	$"FF02 000D 4A81 0001 054A 8400 0207 00FF"            /* ...J...J.... */
	$"8000 89FF 8600 82FF 0100 4A82 0001 044A"            /* ....J...J */
	$"8400 0009 8300 88FF 8600 81FF 0200 184A"            /* ..ƃ.....J */
	$"8200 011C 4A86 0000 4A82 0087 FF86 0081"            /* ...J..J.. */
	$"FF01 004A 8300 004A 8600 004A 8300 87FF"            /* ..J..J..J. */
	$"8600 81FF 0100 4A82 0001 044A 8600 004A"            /* ...J...J..J */
	$"8300 87FF 8600 80FF 0200 104A 8200 004A"            /* .....J..J */
	$"8600 0132 4A83 0087 FF86 0080 FF01 004A"            /* ..2J....J */
	$"8300 004A 8700 0020 8300 87FF 8600 80FF"            /* ..J.. .. */
	$"0100 4A83 0000 4A87 0000 2983 0087 FF86"            /* ..J..J..). */
	$"0080 FF01 004A 8200 0104 4A85 0002 1500"            /* ...J...J.... */
	$"3583 0087 FF86 0080 FF01 004A 8200 004A"            /* 5....J..J */
	$"8F00 87FF 8600 81FF 8300 004A 8F00 87FF"            /* ....J. */
	$"8600 82FF 8200 004A 9000 86FF 8600 83FF"            /* ...J.. */
	$"0400 0003 004A 8300 00FF 8800 013E 0085"            /* .....J....>. */
	$"FF86 0085 FF02 0000 4A82 0001 9EFF 8700"            /* ....J... */
	$"028F A600 85FF 8600 85FF 0200 004A 8200"            /* ......J. */
	$"06BF FF6F 005F 8070 8100 03A2 FFB5 0085"            /* .o._p... */
	$"FF86 0085 FF02 004A 1C82 0000 AE82 FF07"            /* ...J.... */
	$"EFFF FFDF FFD5 DF00 86FF 8600 85FF 0200"            /* .... */
	$"4A10 8300 81FF 07AF 0070 FFD0 7F00 0087"            /* J....p... */
	$"FF86 0085 FF02 004A 0885 0001 FFFF 8000"            /* ...J.... */
	$"05FF FFE0 FF70 0086 FF86 0085 FF01 004A"            /* .p....J */
	$"8500 0515 00FF 5000 8082 FF00 B080 0083"            /* ....P... */
	$"FF86 0085 FF01 004A 8500 0409 00FF E0E0"            /* ...J... */
	$"86FF 0184 0082 FF86 0085 FF01 004A 8500"            /* .....J. */
	$"0109 0085 FF80 0003 8F50 6000 81FF 8600"            /* ....P`.. */
	$"85FF 0100 4A86 0000 5686 FF05 A000 0060"            /* ..J..V...` */
	$"CF00 81FF 8600 85FF 0100 0C85 0002 0900"            /* ........ */
	$"CF86 FF04 EFDF FFAF 0081 FF86 0085 FF87"            /* φ... */
	$"0007 0909 00C0 FFFF 00BF 84FF 0000 82FF"            /* ...... */
	$"8600 82FF 013F 3F8A 0000 0980 0000 FF85"            /* ..??..ƀ.. */
	$"0083 FF86 00A4 FF86 00A4 FF86 00A4 FFFF"            /* .... */
	$"00EF 0068 386D 6B00 0009 0800 0000 0000"            /* ..h8mk........ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 00FF"            /* ............... */
	$"FFFF FFFF FF00 0000 0000 0000 0000 0000"            /* ........... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 FFFF"            /* .............. */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 00FF FFFF"            /* ............. */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 00FF FFFF"            /* ............. */
	$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 FFFF FFFF"            /* ............ */
	$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 FFFF FFFF FF00 FFFF FFFF"            /* ....... */
	$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FF00 FFFF FF00 0000 0000"            /* ...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* .... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .. */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"            /* . */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"            /* . */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"            /* . */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .. */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"            /* ... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .. */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FF00 0000 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF 0000 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF00 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF00 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF00 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF 0000 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF 00FF FFFF FFFF FFFF"            /* . */
	$"FF00 0000 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0069 7433 3200"            /* ...........it32. */
	$"0056 9B00 0000 00FF FFFF FFFF FFFF FFAE"            /* .V.... */
	$"FF0A D39F 7C5D 5150 5B78 9ECA FDEF FF03"            /* ӟ|]QP[x. */
	$"FCC9 6107 8500 0303 44B0 EEEC FF0C AD3C"            /* a....D.< */
	$"0100 000F 1F2C 2F2E 291C 0D80 0002 1E7D"            /* .....,/.).....} */
	$"E9E8 FF08 D661 0000 0C33 5364 6880 6B0A"            /* .a...3Sdhk */
	$"6965 5F4E 320E 0000 269E FBE5 FF09 BF18"            /* ie_N2...&ƿ. */
	$"0001 3E63 6D6C 6867 8466 0964 583E 0E00"            /* ..>cmlhgfdX>.. */
	$"0063 FAFF FEE1 FF09 C718 0011 4D6D 6C6B"            /* .c...Mmlk */
	$"6A68 8466 0C65 625E 5E4D 1B00 007E FEF4"            /* jhf.eb^^M...~ */
	$"F5FE D9FF 00FB 80F8 0BFC C516 002B 5F6E"            /* ....+_n */
	$"6C70 716E 6986 660A 625D 5953 2300 0DB0"            /* lpqnifb]YS#.. */
	$"E1D6 F0D8 FF10 FEBD A8AB B27D 0C00 366C"            /* .}..6l */
	$"6B6E 7579 766E 6887 6609 625C 5552 1F00"            /* knuyvnhfb\UR.. */
	$"44DE D6E7 D8FF 10FA B3AD B4A3 1C00 226A"            /* D..."j */
	$"696C 767D 7D76 6C67 8766 0965 6058 5443"            /* ilv}}vlgfe`XTC */
	$"0304 A5DD E1D8 FF0F F1C3 C4CC 4700 1460"            /* ...G..` */
	$"6A6B 7580 837C 7168 8966 0963 5C53 531D"            /* jku|qhfc\SS. */
	$"003B C1C7 FCD7 FF0E F1DC E77F 0013 5D6A"            /* .;....]j */
	$"6B75 8188 8276 6B8A 6609 655F 5654 3A00"            /* kuvkfe_VT:. */
	$"07AA CEFC D7FF 0EF2 E9DC 2300 496D 6972"            /* ..#.Imir */
	$"818A 8A7C 6F68 8A66 0965 6058 534A 0800"            /* |ohfe`XSJ.. */
	$"76B9 FAD7 FF0E D4A8 4500 2469 686E 7D8B"            /* v.ԨE.$ihn} */
	$"8F85 736A 678B 6608 625A 5451 1A00 4FAF"            /* sjgf.bZTQ..O */
	$"FAD7 FF0D EF82 0008 5A6B 6B78 8A93 8D7C"            /* ...Zkkx| */
	$"6C67 8C66 0863 5C55 542A 0035 AEF7 D7FF"            /* lgf.c\UT*.5 */
	$"0CE1 3700 336D 6972 8493 9285 7268 8D66"            /* .7.3mirrhf */
	$"0863 5D55 5435 001B 6FEF D7FF 0CA6 020C"            /* .c]UT5..o... */
	$"5C6A 6E7B 8E96 8D7C 6D67 8D66 0863 5D56"            /* \jn{|mgf.c]V */
	$"533D 0011 B0FA D7FF 0B59 0046 6D6B 7788"            /* S=...Y.Fmkw */
	$"9794 8373 698E 6608 635D 5652 4300 0DA9"            /* sif.c]VRC.. */
	$"F4D6 FF0B C50B 1266 6971 8494 9A8C 786C"            /* ...fiqxl */
	$"8F66 0863 5D56 5145 0406 6EF3 D6FF 0B56"            /* f.c]VQE..n.V */
	$"0038 6D6B 788E 9B97 8370 688F 6608 635C"            /* .8mkxphf.c\ */
	$"5551 4605 0462 F8C4 FF05 FDF2 E3D9 E2F1"            /* UQF..b. */
	$"88FF 0BDD 0D04 5A6B 7184 979C 8F79 6B90"            /* ...Zkqyk */
	$"6608 635B 5451 4605 0463 F7C1 FF0B F5B8"            /* f.c[TQF..c. */
	$"6F36 1507 0307 1647 8EDB 85FF 0B86 0026"            /* o6.....Gۅ..& */
	$"6B6C 7A90 9D98 8571 6790 6608 615A 5350"            /* klzqgf.aZSP */
	$"4503 0886 FAC0 FF0D BB38 0104 1D2C 312B"            /* E...8...,1+ */
	$"1B07 0000 15A3 84FF 0A37 0047 6D71 8398"            /* .....7.Gmq */
	$"9D92 7C6B 9166 0860 5952 5043 0010 C1FE"            /* |kf.`YRPC.. */
	$"BEFF 06DA 560C 2A52 676A 806B 0668 6042"            /* .V.*Rgjk.h`B */
	$"1300 007F 82FF 0BCF 0411 636D 7A8D 9E99"            /* .......cmz */
	$"8874 6890 6608 655F 5751 503E 000D AAB8"            /* thf.e_WQP>.. */
	$"FF0C FDDD DADB E1D9 7811 1D61 7672 6A81"            /* .x..avrj */
	$"6680 6704 5A33 0200 8781 FF0B 7300 436E"            /* fg.Z3...s.Cn */
	$"7285 979F 917D 6E67 9066 0864 5D54 4F51"            /* r}ngf.d]TOQ */
	$"3700 1B93 B8FF 0CFC CFCA CBD8 5D00 3576"            /* 7...].5v */
	$"7B76 6F69 8366 1464 605D 3500 00B6 FFFF"            /* {voif.d`]5.. */
	$"F720 0460 6C79 909E 9C87 746A 9166 0863"            /*  .`lytjf.c */
	$"5B53 4F52 3100 3EE7 B9FF 0BDF D5C3 8300"            /* [SOR1.>.Ã. */
	$"3A7A 7F7E 766E 6883 6614 6561 5A55 1A00"            /* :z.~vnhf.eaZU.. */
	$"5CFF FFC0 0020 6A6F 8297 A096 7F6F 6791"            /* \. jo.og */
	$"6608 6159 514D 5128 0030 C3B9 FF0A D9D0"            /* f.aYQMQ(.0ù */
	$"7B00 2A7A 8187 8073 6B85 6612 625B 5642"            /* {.*zskf.b[VB */
	$"0119 F0FE 4D00 4470 768D 9E9F 8C76 6A91"            /* ..M.Dpvvj */
	$"6609 655F 564F 4D51 1D00 63EE B9FF 0AE8"            /* fe_VOMQ..c */
	$"9A06 106D 838A 897B 6D68 8566 1262 5C54"            /* ..m{mhf.b\T */
	$"5112 01D4 C400 0760 717E 96A1 9982 6E67"            /* Q....`q~ng */
	$"9166 0963 5C54 4E4D 4E10 0078 EC84 FF05"            /* fc\TNMN..x. */
	$"E4CE C8CC D1EE ACFF 09EC 4600 437F 898F"            /* F.C. */
	$"8674 6986 6611 615A 5254 2400 BA7F 0021"            /* tif.aZRT$...! */
	$"6C74 869C A092 7A6A 9266 0962 5A52 4D4D"            /* ltzjfbZRMM */
	$"4906 0274 DE81 FF0B DA95 4317 0502 0307"            /* I..tށ.ڕC..... */
	$"2468 A7E5 A9FF 09C8 041E 7084 908E 806F"            /* $h..po */
	$"6785 6612 6560 5751 5332 01A0 3300 4072"            /* gf.e`WQS2.3.@r */
	$"7C8F A09B 8973 6891 660F 6560 5850 4C50"            /* |shf.e`XPLP */
	$"3E00 1397 F2FF FFBF 4709 8000 0302 0504"            /* >..Gƀ..... */
	$"0180 0002 1465 CFA7 FF08 6900 5B7F 8C93"            /* ....eϧ.i.[. */
	$"8877 6A86 6611 645D 554F 5136 0965 0505"            /* wjf.d]UOQ6e.. */
	$"5C75 8698 A093 7F6D 9266 2163 5D56 4F4C"            /* \u.mf!c]VOL */
	$"512F 0038 B2FF F57B 0500 0221 3D4E 585D"            /* Q/.8{...!=NX] */
	$"5C56 4B36 2003 0006 59A8 DAC5 ECA1 FF09"            /* \VK6 ...Y */
	$"F215 1775 8392 9080 6F67 8666 1162 5A53"            /* ..uogf.bZS */
	$"4D53 2B05 1C00 1B6B 788F 9E9D 8A77 6992"            /* MS+....kxwi */
	$"6615 625B 534D 4C51 1F00 56BD D342 0000"            /* f.b[SMLQ..VB.. */
	$"2C5B 696D 6A69 6868 8069 0964 5427 0000"            /* ,[imjihhidT'.. */
	$"16B2 B2E1 FAA0 FF08 B700 3C80 8A94 8979"            /* ...<y */
	$"6B86 6612 655F 5751 4D51 2000 0400 3B72"            /* kf.e_WQMQ ...;r */
	$"7F95 A099 8271 6891 6611 655F 5851 4C4D"            /* .qhf.e_XQLM */
	$"4E0E 078F D664 0001 3B6E 6D68 8566 0965"            /* N..d..;nmhfe */
	$"645E 390D 0032 A8E6 F69F FF09 FB4B 0163"            /* d^9..2K.c */
	$"8692 9281 7168 8666 1163 5D54 4F4D 4D12"            /* qhf.c]TOMM. */
	$"0000 0F62 7488 9CA0 9079 6C92 6611 635D"            /* ...btylf.c] */
	$"544F 4C4F 4400 2CC3 A404 0344 7873 6D68"            /* TOLOD.,ä..Dxsmh */
	$"8666 0865 615F 4B0F 0035 CCF3 9FFF 09CA"            /* f.ea_K..5 */
	$"001D 7A8B 948D 796C 6786 6611 615A 514D"            /* ..zylgf.aZQM */
	$"4D48 0600 002A 6E78 8F9F 9C88 7269 9266"            /* MH...*nxrif */
	$"1162 5A52 4E4C 5233 0055 D147 0041 7C7D"            /* .bZRNLR3.UG.A|} */
	$"7870 6887 6607 635E 5B40 0200 83FB 9FFF"            /* xphf.c^[@.. */
	$"0889 003E 8590 9485 7268 8666 1265 6057"            /* ..>rhf.e`W */
	$"504D 4E3E 0200 0042 727E 96A0 9880 6F68"            /* PMN>...Br~oh */
	$"9166 1265 6058 514D 4C52 2000 73B8 0F10"            /* f.e`XQMLR .s.. */
	$"7082 857B 7068 8766 0665 615A 551A 004C"            /* p{phf.eaZU..L */
	$"9FFF 09FC 3C00 618A 9490 7D6C 6786 6612"            /* <.a}lgf. */
	$"635D 544F 4C51 3000 0006 5D73 869C 9E90"            /* c]TOLQ0...]s */
	$"786A 6791 6612 645E 5550 4C4D 4E09 0DB2"            /* xjgf.d^UPLMN. */
	$"7A00 3B84 8A89 7A6C 6788 6606 635E 5936"            /* z.;zlgf.c^Y6 */
	$"0018 EE9E FF08 DB08 1779 8E94 8A76 6987"            /* .....yvi */
	$"6611 615A 524D 4C50 2300 001D 6D78 8E9E"            /* f.aZRMLP#...mx */
	$"9A87 7168 9266 1163 5A53 4E4C 5234 0042"            /* qhf.cZSNLR4.B */
	$"AB41 015B 898F 8773 6889 6606 6460 594A"            /* A.[shf.d`YJ */
	$"0601 BC9E FF08 A900 3884 9192 8471 6886"            /* ....8qh */
	$"6611 655F 5750 4C4C 4E17 0000 3474 7E93"            /* f.e_WPLLN...4t~ */
	$"9E94 806D 9266 1265 6158 514D 4C51 1B00"            /* mf.eaXQMLQ.. */
	$"63A2 1604 6B8C 9184 7067 8966 0665 6259"            /* c..kpgf.ebY */
	$"541E 008A 9EFF 0869 0166 8793 8E7E 6D67"            /* T...i.f~mg */
	$"8666 1163 5D56 4F4C 4D4A 0B00 014F 7784"            /* f.c]VOLMJ...Ow */
	$"999D 8C79 6A92 6611 645F 564F 4C4E 4A08"            /* yjf.d_VOLNJ. */
	$"016B C125 0976 8E91 826F 8B66 0563 5A57"            /* .k%vof.cZW */
	$"3600 579D FF08 F827 1D7B 8C93 8878 6987"            /* 6.W.'.{xi */
	$"6611 625A 534E 4C4E 3F02 000E 667A 8C9C"            /* f.bZSNLN?...fz */
	$"9883 7168 9266 1162 5B53 4E4C 5138 0012"            /* qhf.b[SNLQ8.. */
	$"A3A9 1B0D 7990 9281 6E8B 6606 645C 5545"            /* ..ynf.d\UE */
	$"0025 F49C FF08 D702 3E82 8F91 8273 6886"            /* .%..>sh */
	$"6611 655F 5750 4C4C 5133 0000 2470 7F92"            /* f.e_WPLLQ3..$p. */
	$"9D92 7B6D 9266 1265 6058 504D 4C51 2500"            /* {mf.e`XPMLQ%. */
	$"39BC 9B18 0F7A 9294 836E 8B66 0664 5D55"            /* 9..znf.d]U */
	$"4E09 07D9 9CFF 07A5 0058 8691 8F7D 6E87"            /* N.ٜ..X}n */
	$"6611 645D 554F 4C4C 5127 0000 3976 8497"            /* f.d]UOLLQ'..9v */
	$"9B8C 766A 9266 1263 5E56 4F4C 4D4E 1100"            /* vjf.c^VOLMN.. */
	$"5DC4 9117 107B 9496 856F 8B66 0665 5E56"            /* ]đ..{of.e^V */
	$"5117 00B8 9CFF 076C 0371 8892 8B78 6C87"            /* Q...l.qxl */
	$"6611 635B 534F 4C4C 4E17 0002 5379 8C9B"            /* f.c[SOLLN...Sy */
	$"9984 7068 9266 1362 5A54 4E4C 4F41 0200"            /* phf.bZTNLOA.. */
	$"75A6 7E14 117C 969A 8871 678A 6606 655F"            /* u~..|qgf.e_ */
	$"5655 2600 899B FF08 FE3D 197C 8B93 8774"            /* VU&..=.|t */
	$"6987 6611 6359 524E 4C4D 490A 0014 697B"            /* if.cYRNLMI..i{ */
	$"919C 957D 6C67 9166 1465 6057 514D 4C51"            /* }lgf.e`WQMLQ */
	$"2D00 088F 8668 1013 7D97 9C8B 7267 8A66"            /* -..h..}rgf */
	$"0665 5F56 5432 005C 9BFF 08F0 1731 828D"            /* .e_VT2.\..1 */
	$"9183 7068 8766 1062 5850 4D4C 4F40 0200"            /* phf.bXPMLO@.. */
	$"3672 7F95 9C90 786A 9266 1464 5E55 504C"            /* 6r.xjf.d^UPL */
	$"4C50 1B00 3AD8 9052 0C15 7D98 9E8D 7367"            /* LP..:ؐR..}sg */
	$"8A66 0765 6057 533B 002A F29A FF08 B900"            /* f.e`WS;.*.. */
	$"4B86 9090 7E6D 6786 6611 6560 5750 4D4C"            /* K~mgf.e`WPML */
	$"502D 0000 5174 8599 9A89 7368 9266 1463"            /* P-..Qtshf.c */
	$"5A51 4F4C 4E48 0700 71BF 5B35 0819 7E9A"            /* ZQOLNH..q[5..~ */
	$"A191 7668 8B66 0660 5753 4501 05D7 9AFF"            /* vhf.`WSE..ך */
	$"0776 0061 8691 8D7A 6B87 6610 6560 5750"            /* .v.azkf.e`WP */
	$"4D4C 5023 000C 6477 8C9B 9782 6E92 6615"            /* MLP#..dwnf. */
	$"6560 5750 4D4C 5136 0005 8DA1 603D 021D"            /* e`WPMLQ6..`=.. */
	$"7F9B A393 7769 8B66 0660 5852 4A08 00B5"            /* .wif.`XRJ.. */
	$"9AFF 0756 016D 8791 8B77 6987 6610 6560"            /* .V.mwif.e` */
	$"5750 4D4C 502F 001D 6C7A 909B 937D 6B92"            /* WPMLP/..lz}k */
	$"6615 645D 544F 4C4C 501D 001E EFF9 D09E"            /* f.d]TOLLP...О */
	$"0021 819C A495 7769 8B66 0660 5852 4C10"            /* .!wif.`XRL. */
	$"00A7 99FF 08FE 3D0E 7487 9088 7468 8866"            /* ..=.tthf */
	$"0F62 5951 4E4C 5033 0033 737E 949A 8E78"            /* .bYQNLP3.3s~x */
	$"6992 6615 625B 534E 4C4F 4203 0053 FFFB"            /* if.b[SNLOB..S */
	$"8760 0027 839C A494 7769 8B66 0660 5852"            /* `.'wif.`XR */
	$"4F16 008A 99FF 08F7 221F 7888 8F84 7267"            /* O...".xrg */
	$"8866 0F64 5D55 504D 4F1D 004C 7784 9897"            /* f.d]UPMO..Lw */
	$"8773 6891 6616 645F 5850 4D4C 512E 0000"            /* shf.d_XPMLQ... */
	$"8DFF F665 3B00 2C84 9BA2 9175 688B 6606"            /* e;.,uhf. */
	$"6058 5251 1F00 7899 FF07 F212 2B7B 878D"            /* `XRQ..x..+{ */
	$"8170 8A66 0E61 5B55 5247 0404 5F78 899A"            /* pf.a[URG.._x */
	$"9481 6F67 9166 1663 5D55 4F4C 4C4F 1B00"            /* ogf.c]UOLLO.. */
	$"00BE FFE9 AD61 0034 8798 9E8C 7267 8B66"            /* .a.4rgf */
	$"0660 5851 5125 006E 99FF 07ED 0C32 7C87"            /* .`XQQ%.n..2| */
	$"8B7F 6E8A 660D 6560 5B59 3D00 1369 7B8E"            /* .nf.e`[Y=..i{ */
	$"9A8F 7D6C 9266 1562 5B52 4E4C 4D4B 0B00"            /* }lf.b[RNLMK.. */
	$"12E8 FFD6 763A 003D 8895 9885 6F8C 6606"            /* .v:.=of. */
	$"6058 5151 2800 5F99 FF07 E709 377D 8689"            /* `XQQ(._.7} */
	$"7C6D 8B66 0C64 6263 3100 2972 7F92 9A8B"            /* |mf.dbc1.)r. */
	$"776A 9166 1665 5F58 514D 4C50 3B01 0045"            /* wjf.e_XQMLP;..E */
	$"FEFF F0C3 3200 4985 908E 7D6C 8C66 0660"            /* 2.I}lf.` */
	$"5751 512C 0054 99FF 07E6 0939 7D84 877A"            /* WQQ,.T.9}z */
	$"6C8E 6609 2100 3E77 8396 9885 7369 9166"            /* lf!.>wsif */
	$"1664 5C55 504C 4C52 2900 007E FFFF F4D2"            /* .d\UPLLR)..~ */
	$"0D00 5881 8984 7469 8B66 0765 6057 5051"            /* ..Xtif.e`WPQ */
	$"2E00 4F99 FF07 F10C 387C 8285 796B 8C66"            /* ..O..8|ykf */
	$"0B67 6512 004E 7888 9896 8170 6791 6616"            /* .ge..Nxpgf. */
	$"6259 524F 504F 4B17 0000 A1FB DAB6 6C00"            /* bYROPOK...ڶl. */
	$"0665 7D81 7B6F 678B 6607 655F 5650 5130"            /* .e}{ogf.e_VPQ0 */
	$"004E 99FF 07D2 0C34 797F 8177 6B8C 660A"            /* .N..4y.wkf */
	$"695B 0307 617A 8E99 927C 6D91 6607 655E"            /* i[..az|mf.e^ */
	$"5654 4D33 1909 8000 0B1C 363B 2E00 001E"            /* VTM3.ƀ...6;.... */
	$"7077 7872 6A8C 6607 655E 5650 5130 004E"            /* pwxrjf.e^VPQ0.N */
	$"94FF 0CF0 F0F1 F5DA 921F 2A75 7B7D 7569"            /* .ڒ.*u{}ui */
	$"8C66 0A6B 4800 176C 7D92 998E 776A 9166"            /* fkH..l}wjf */
	$"0463 5C58 4213 8100 0206 0A04 8100 0606"            /* .c\XB........ */
	$"5270 706F 6B67 8C66 0765 5E56 4F51 2F00"            /* Rppokgf.e^VOQ/. */
	$"5194 FF0C FBFB E3AC ABB2 321B 7177 7972"            /* Q.㬫2.qwyr */
	$"698C 660A 6D38 002A 7281 9599 8A74 6990"            /* ifm8.*rti */
	$"6616 6561 5F3E 0100 152C 3F4A 5A62 614F"            /* f.ea_>...,?JZbaO */
	$"3925 1541 6D6A 6C6B 688D 6608 645E 554F"            /* 9%.Amjlkhf.d^UO */
	$"512C 004E F395 FF0A F9C5 9FA9 4B08 6B72"            /* Q,.NşK.kr */
	$"736E 688C 660A 6A27 0042 7585 9798 8671"            /* snhfj'.Buq */
	$"6890 6615 6464 4A09 204B 6269 6A6A 6867"            /* hf.ddJ Kbijjhg */
	$"686A 6C69 6569 6768 6867 8E66 0964 5D54"            /* hjlieighhgfd]T */
	$"4F51 2800 2557 D996 FF08 CBB7 9C0D 566F"            /* OQ(.%Wٖ.˷.Vo */
	$"6C6A 688B 660A 6766 1306 6076 8A99 9581"            /* ljhfgf..`v */
	$"6D91 6606 655D 2444 6668 6785 6601 6767"            /* mf.e]$Dfhgf.gg */
	$"9366 0964 5C53 4E51 2400 429F EC97 FF07"            /* fd\SNQ$.B. */
	$"ECD4 2F33 6E68 6767 8B66 0A68 6004 176C"            /* /3nhggfh`..l */
	$"778E 9991 7B6B 9166 0367 484E 68A0 6608"            /* w{kf.gHNhf. */
	$"635B 524E 501F 0032 D298 FF05 FCCA 5113"            /* c[RNP..2Ҙ.Q. */
	$"6968 8D66 0A69 5400 276E 7B91 998F 7869"            /* ihfiT.'n{xi */
	$"9166 0362 5466 65A0 6608 6259 514E 4E17"            /* f.bTfef.bYQNN. */
	$"0065 F399 FF04 FBC4 0A45 6D8D 660A 6C45"            /* .e.EmflE */
	$"003A 737E 9499 8B75 6891 6601 6565 A166"            /* .:s~uhf.eef */
	$"0865 6057 504E 4B0D 00B2 9CFF 0377 055C"            /* .e`WPNK...w.\ */
	$"6A8C 660A 6D35 004A 7482 9697 8671 67B7"            /* jfm5.Jtqg */
	$"6608 645E 564F 4E44 010A DB9C FF04 E913"            /* f.d^VOND.ۜ.. */
	$"1467 698B 6609 6B29 0058 7486 9795 826F"            /* .gifk).Xto */
	$"B866 0863 5C54 4E4F 3A00 39F6 9DFF 05AC"            /* f.c\TNO:.9. */
	$"071E 656B 6788 660A 6769 1B06 6576 8998"            /* ..ekgfgi..ev */
	$"917F 6DB7 6608 6562 5A52 4D51 2B00 819F"            /* .mf.ebZRMQ+. */
	$"FF05 C015 114E 6A6A 8766 0A67 650C 166B"            /* ...Njjfge..k */
	$"798C 988D 7B6A B766 0864 5F57 504D 4E16"            /* y{jf.d_WPMN. */
	$"01C6 A0FF 07BB 1100 275B 6A6C 6884 660A"            /* .Ơ...'[jlhf */
	$"695A 0324 707B 8F97 8B78 69B7 6608 635C"            /* iZ.$p{xif.c\ */
	$"554F 4D49 041D F1A1 FF09 D356 0700 1E3F"            /* UOMI..V...? */
	$"5B6A 6C68 8166 0A6C 4A00 3375 7E92 9787"            /* [jlhflJ.3u~ */
	$"7568 B766 0760 5952 4E51 3600 66A4 FF16"            /* uhf.`YRNQ6.f. */
	$"CE69 1600 0020 425C 6A6B 6766 6B39 0044"            /* i... B\jkgfk9.D */
	$"7682 9595 8371 67B6 6608 645C 5450 4E4A"            /* vqgf.d\TPNJ */
	$"0E02 C1A6 FF14 EBB5 5E04 0000 1D4B 686B"            /* ...^....Khk */
	$"6E2B 0051 7785 9693 7F6F 67B5 6609 6560"            /* n+.Qw.ogfe` */
	$"5851 4E51 3000 38FD A9FF 11D6 9457 1100"            /* XQNQ0.8.֔W.. */
	$"0B33 5622 015D 7788 9691 7C6D 67B5 6608"            /* .3V".]w|mgf. */
	$"635C 554F 4E4C 1000 9BAD FF0D E497 4200"            /* c\UONL...B. */
	$"0003 0E65 7A8B 968D 796B B566 0963 5E57"            /* ...ezykfc^W */
	$"514D 5129 0038 F7B0 FF0A A30E 001B 6B7C"            /* QMQ).8£...k| */
	$"8E96 8A75 6AB4 6609 635E 5752 4D51 3C02"            /* ujfc^WRMQ<. */
	$"27DC B2FF 098F 0024 6F7E 9095 8772 69B2"            /* 'ܲƏ.$o~ri */
	$"660A 6563 5E57 524E 5046 0C00 A9B3 FF09"            /* fec^WRNPF.. */
	$"DD03 2E73 8192 9484 7168 B066 0D65 6360"            /* ..sqhf.ec` */
	$"5C57 524F 523E 0908 1654 E8B2 FF09 BB00"            /* \WROR>..Tƻ. */
	$"3C75 8393 9381 6E67 AD66 1165 6462 605D"            /* <ungf.edb`] */
	$"5954 5151 5030 051B BCD2 1227 D8B1 FF09"            /* YTQQP0...'ر */
	$"A200 4676 8594 927E 6D67 9666 0368 6B6B"            /* .Fv~mgf.hkk */
	$"688D 6615 6563 6360 5E5B 5855 5251 5244"            /* hf.ecc`^[XURQRD */
	$"2000 002C E3FF B200 2EF0 B0FF 097F 0053"            /*  ..,....S */
	$"7687 948F 7B6B 6795 6605 6B59 2F29 5C69"            /* v{kgf.kY/)\i */
	$"8966 1865 6462 605D 5B59 5553 5253 5248"            /* f.edb`][YUSRSRH */
	$"2500 0043 9804 3CFC FFAF 008D B0FF 0862"            /* %..C.<..b */
	$"005E 768A 948C 7869 9566 076B 4715 4D21"            /* .^vxif.kG.M! */
	$"1967 6783 661E 6565 6462 615F 5D5A 5755"            /* .ggf.eedba_]ZWU */
	$"5251 4F50 503F 2103 003F 9DF7 FF6A 00D5"            /* RQOPP?!..?j. */
	$"FFFF 8312 E7AF FF08 430C 6777 8B93 8A75"            /* ..C.gwu */
	$"6894 6608 6958 08AC FFC1 075E 6880 6616"            /* hf.iX..^hf. */
	$"6564 6362 605D 5B59 5654 5250 4F4F 504F"            /* edcb`][YVTRPOOPO */
	$"4119 0000 22AD FD80 FF07 D404 8DFF FFFA"            /* A...".. */
	$"228F AEFF 09F5 271D 6D78 8C93 8874 6894"            /* "'.mxth */
	$"6620 6C24 4CFF FFEC 1550 6965 6463 615F"            /* f l$L.Piedca_ */
	$"5D5C 5956 5553 514F 4F51 4F48 3313 0000"            /* ]\YVUSQOOQOH3... */
	$"3F9A E582 FF08 FA1B 49FE FFFF 7F38 F9AD"            /* ?..I.8 */
	$"FF09 EA0D 2D6F 7A8D 9285 7267 9366 1F6A"            /* .-ozrgf.j */
	$"5705 BFFF FFF6 2642 655F 5D5B 5956 5452"            /* W.&Be_][YVTR */
	$"5150 4F50 514F 4835 1600 0024 6EC1 FE84"            /* QPOPQOH5...$n */
	$"FF08 FC1F 2BFB FFFF D01A E0AD FF09 D303"            /* ..+.. */
	$"3F72 7B8F 9082 6F67 9366 1C6B 251E F7FF"            /* ?r{ogf.k%. */
	$"FFFC 3633 5E57 5453 514F 4E4F 5052 4E41"            /* 63^WTSQONOPRNA */
	$"2B16 0000 2466 B1F1 86FF 03C7 5200 6480"            /* +...$f.R.d */
	$"FF02 F528 B6AD FF08 C000 4571 7D8E 8F7F"            /* .(..Eq}. */
	$"6E92 6604 6564 630D 4881 FF12 4927 5851"            /* nf.edc.H.I'XQ */
	$"5050 5250 4D4A 3D2B 0F00 0008 3992 F386"            /* PPRPMJ=+....9 */
	$"FF06 F3C7 6B00 0043 E080 FF02 FB2A 89AC"            /* .k..C.* */
	$"FF09 FD99 004F 717E 8E8E 7E6C 9166 0564"            /* .Oq~~lf.d */
	$"615F 5800 6B81 FF0F 6310 524C 463D 301E"            /* a_X.k.c.RLF=0. */
	$"0C00 000D 2F6D B3F0 81FF 0DFC FBFA F5EF"            /* ..../m. */
	$"D7A3 5619 010D 55B1 FB81 FF02 F81B 5AAB"            /* ףV...U..Z */
	$"FF0A A83B 0D06 5871 808E 8C7B 6B90 6606"            /* ¨;..Xq{kf. */
	$"6560 5A57 4800 8781 FF03 8E00 1E08 8000"            /* e`ZWH...... */
	$"1719 497C B1D3 E0D4 B597 8167 4E41 2C29"            /* ..I|ԵgNA,) */
	$"2317 120D 194D 69A5 E684 FF02 F512 48A9"            /* #....Mi..H */
	$"FF0C F867 0000 0907 5C71 818E 8A79 6A90"            /* .g...\qyj */
	$"6606 635C 5553 4000 9381 FF1A C700 092F"            /* f.c\US@.../ */
	$"527C BAED ECB9 6824 0F01 0000 0615 2A3B"            /* R|h$......*; */
	$"4B4F 5667 89BD EC88 FF02 DF00 63A9 FF0C"            /* KOVg..c. */
	$"F203 0005 0E0B 6271 828D 8776 6990 6606"            /* .....bqvif. */
	$"6259 5251 3C00 9981 FF12 F93D 0184 B9B2"            /* bYRQ<..=. */
	$"894E 1E29 496C 8AA4 C3D9 E9F6 FB88 FF01"            /* N.)Il. */
	$"F5E5 82FF 05D2 570C A592 D4A7 FF0C E80C"            /* .W.ԧ.. */
	$"0003 0612 6772 828C 8474 6890 6606 6058"            /* ....grthf.`X */
	$"5150 3A00 9B82 FF08 E355 1015 213C 72B1"            /* QP:..U..!<r */
	$"F38F FF10 FEFF F88A D3FF FFF6 A30F 1062"            /* ...b */
	$"4000 1A92 FDA5 FF0C 5F00 0006 1015 6873"            /* @..._.....hs */
	$"838B 8373 678F 6607 655F 5650 5038 0092"            /* sgf.e_VPP8. */
	$"84FF 02E7 E5F2 90FF 0EE1 9992 F8FF FFD9"            /* ..ᙒ */
	$"49F1 EF2F 003D 490B 8100 0156 F9A2 FF01"            /* I/.=I...V. */
	$"FB66 8000 0904 0A1D 6A73 838B 8071 678F"            /* f...jsqg */
	$"6607 655F 5650 4F41 0080 92FF 01E9 FE83"            /* f.e_VPOA.. */
	$"FF02 F14D 5281 FF06 9D54 322C 7C57 0783"            /* .MR.T2,|W. */
	$"0001 42CE A0FF 01FE 6481 0009 0301 256C"            /* ..BΠ.d...%l */
	$"7383 897E 6F67 8F66 0764 5E55 504D 4D06"            /* s~ogf.d^UPMM. */
	$"5C91 FF03 E13F 6BF4 83FF 02D6 77FA 81FF"            /* \.?k.w */
	$"0497 0033 4201 8500 0112 929F FF00 6D82"            /* ..3B.....m */
	$"0008 1B06 2B6E 7583 867C 6E90 6608 645D"            /* ....+nu|nf.d] */
	$"544F 4C50 2C24 F48E FF06 D364 1600 0035"            /* TOLP,$.d...5 */
	$"D883 FF01 DFE9 82FF 04B2 2900 0C0C 8600"            /* ؃..).... */
	$"015B ED9C FF00 9283 0008 3508 2E6F 7583"            /* .[...5..ou */
	$"8479 6C90 6608 635D 544E 4C4D 4E0B B88D"            /* ylf.c]TNLMN. */
	$"FF01 B817 8200 0154 FE83 FF02 E9D4 FA81"            /* ....T. */
	$"FF08 EC69 030E 1B2B 3417 0482 0001 46DA"            /* .i...+4....F */
	$"9AFF 007F 8300 0918 3A00 3470 7582 8377"            /* ....:.4puw */
	$"6B90 6609 635C 534E 4C4C 5028 41FB 8BFF"            /* kfc\SNLLP(A */
	$"01F2 1D83 0001 11E8 84FF 01F0 F782 FF09"            /* ...... */
	$"E806 0235 505E 5A50 2609 8100 0116 9F98"            /* ..5P^ZP&Ɓ... */
	$"FF00 8983 000A 03AF A800 3A71 7581 8176"            /* ....:quv */
	$"6A90 6609 635B 534E 4C4C 4D4E 147A 8BFF"            /* jfc[SNLLMN.z */
	$"01D6 0683 0001 06D2 8BFF 0CDF 4425 0700"            /* .....ҋ.D%.. */
	$"000F 1F2E 3529 1804 8000 0169 EF95 FF00"            /* ....5)....i. */
	$"A484 000A 21A0 7500 3F71 7480 7F74 6990"            /* .!u.?qt.ti */
	$"6603 635B 524E 804C 0450 3D03 53F6 89FF"            /* f.c[RNL.P=.S */
	$"00B8 8400 0107 D48C FF11 FEF6 DCB5 8137"            /* ....Ԍ.ܵ7 */
	$"0400 0001 1310 1004 0000 2DC2 93FF 01AB"            /* ..........-. */
	$"1484 000A 4072 4C00 4171 747F 7C72 6990"            /* ..@rL.Aqt.|ri */
	$"6603 625A 524E 804C 064F 3908 0040 B9FB"            /* f.bZRNL.O9..@ */
	$"83FF 00FA 80FF 009A 8400 0110 E591 FF0D"            /* ...... */
	$"FBDA AB78 4824 0700 030F 0000 17AC 85FF"            /* ګxH$....... */
	$"0364 ADE4 E485 FF01 A302 8400 0B0B 4145"            /* .d.....AE */
	$"3000 4570 747E 7B71 698F 6604 6562 5A52"            /* 0.Ept~{qif.ebZR */
	$"4D80 4C0D 5038 0004 2317 346F A3CB DDE0"            /* ML.P8..#.4o */
	$"9FE0 80FF 0091 8400 012B F896 FF0A F6D2"            /* ...+ */
	$"9A32 0310 0000 0175 EE83 FF06 0000 120E"            /* 2.....u..... */
	$"4390 ED81 FF01 BD07 8500 0B0F 201E 1700"            /* C..... ... */
	$"4970 737C 786F 688F 6604 6562 5A51 4D80"            /* Ips|xohf.ebZQM */
	$"4C0D 5037 0000 3044 3106 0003 0A0C 68FD"            /* L.P7..0D1....h */
	$"80FF 01DD 0A83 0000 5E9A FF03 EC2E 1226"            /* ...^...& */
	$"8000 0126 CE82 FF83 0005 194E 8ED2 D324"            /* ..&΂...N$ */
	$"8500 0C22 6261 6639 004D 6E73 7B76 6E67"            /* .."baf9.Mns{vng */
	$"8F66 0465 625A 514D 804C 0C50 3600 030A"            /* f.ebZQML.P6.. */
	$"031B 201D 1600 24EE 82FF 005A 8200 0123"            /* .. ...$.Z..# */
	$"C99B FF03 C511 451D 8000 051D B6FF F5C8"            /* ɛ..E.... */
	$"9C86 0001 070A 8500 0D02 94DC D2E0 7000"            /* ......p. */
	$"526E 7279 756D 678F 6604 6562 5A51 4D80"            /* Rnryumgf.ebZQM */
	$"4C04 5038 0005 1280 0004 0111 0F0E DE82"            /* L.P8.........ނ */
	$"FF06 DA20 0002 45A3 EC8D FF13 FAD1 FEFF"            /* . ..E. */
	$"FFFD EACC A5B5 F6FF FFFD 9435 031D 6317"            /* ̥5..c. */
	$"8000 0306 4D20 0491 000C 2DB0 ADAC B85B"            /* ...M ...-[ */
	$"0053 6D71 7673 6C90 6604 6562 5A51 4D80"            /* .Smqvslf.ebZQM */
	$"4C04 5038 0005 1482 0003 0C06 48D3 82FF"            /* L.P8.......Hӂ */
	$"02D7 89BC 90FF 14F9 3B42 6159 3B18 0500"            /* .׉.;BaY;... */
	$"0032 B3FF DE02 0114 042E 753E 9700 0C5E"            /* .2.....u>..^ */
	$"9E94 959F 4F00 536C 6F75 716B 9066 0465"            /* O.Slouqkf.e */
	$"625A 514D 804C 044F 3A00 0410 8200 0401"            /* bZQML.O:...... */
	$"1100 14C8 97FF 01FB 2F86 000B 0DC3 8100"            /* ...ȗ./...Á. */
	$"096D 4400 2B9A 3B01 9400 0D15 8185 8383"            /* mD.+;.... */
	$"8C45 0054 6C6E 726F 6A90 6604 6562 5A52"            /* E.Tlnrojf.ebZR */
	$"4D80 4C04 4F3C 0101 0784 0002 1100 8C98"            /* ML.O<....... */
	$"FF00 6787 0000 0380 0006 0A9E A90C 3C52"            /* .g......<R */
	$"0E94 000D 4A7E 7677 777F 3E00 556B 6D6F"            /* ...J~vww.>.Ukmo */
	$"6D68 9066 0465 625A 524D 804C 044F 3F02"            /* mhf.ebZRML.O?. */
	$"0104 8300 030A 2C18 DA98 FF03 ECA2 6622"            /* ....,.ژ.f" */
	$"8500 0916 1602 22C0 FF5F 0006 0693 0002"            /* ...."_..... */
	$"0F68 6C80 6A08 7137 0056 6B6B 6C6A 6890"            /* .hlj.q7.Vkkljh */
	$"6604 6562 5A52 4D80 4C04 4E42 0202 1183"            /* f.ebZRML.NB... */
	$"0002 4116 7C9C FF02 ED8F 1582 0007 47E9"            /* ..A.|....G */
	$"EBC3 E5FF FF8A 9500 0301 3B69 6580 6408"            /* ...;ied. */
	$"6B34 0056 6A69 6A69 6791 6603 625A 524E"            /* k4.Vjijigf.bZRN */
	$"804C 054E 4303 011C 0982 0002 3002 A79E"            /* L.NC...Ƃ..0. */
	$"FF02 DA86 2D80 0000 7483 FF00 9F95 0002"            /* .چ-..t... */
	$"1F69 6781 6508 6C34 0057 6968 6867 6791"            /* .ige.l4.Wihhgg */
	$"6603 635B 524E 804C 0D4E 4404 001A 1904"            /* f.c[RNL.ND..... */
	$"0000 0219 1C00 80A0 FF04 F4B0 6754 CE83"            /* .......gT΃ */
	$"FF00 B795 000B 1861 6A65 6465 656B 3400"            /* ....ajedeek4. */
	$"5769 9566 0363 5B52 4E80 4C0E 4E46 0400"            /* Wif.c[RNL.NF.. */
	$"86BC B94B 0035 7D74 0F20 F3AA FF02 8300"            /* K.5}t. .. */
	$"1580 1601 170C 8F00 0A0D 4D74 6F6D 6D74"            /* .......Mtommt */
	$"3900 5669 9566 0363 5B52 4E80 4C0E 4D49"            /* 9.Vif.c[RNL.MI */
	$"0700 A2E7 E5B6 2581 989A 4400 ACA9 FF09"            /* ..%D. */
	$"E312 3B9F 999A 9B9D 8E10 8F00 0902 3B77"            /* .;...;w */
	$"7D77 7F3E 0056 6995 6603 635B 524E 804C"            /* }w.>.Vif.c[RNL */
	$"0F4D 4C0C 0075 A6A1 835C A2B2 B595 0434"            /* .ML..u\.4 */
	$"F9A8 FF09 5C03 91AE AEAD A8A8 AE43 9100"            /* \.C. */
	$"071E 668E 8F46 0054 6995 6603 635B 524E"            /* ..fF.Tif.c[RN */
	$"804C 0F4D 4D0F 004D 6DA2 4546 B477 B7E4"            /* L.MM..MmEFw */
	$"6B00 8AA7 FF0A 8900 5AC2 BCA2 5534 3437"            /* k..Z¼U447 */
	$"2892 0006 0675 B355 0056 6B80 6803 696A"            /* (...uU.Vkh.ij */
	$"6B6B 8E6C 0369 6158 5480 5110 5252 1400"            /* kkl.iaXTQ.RR.. */
	$"2E66 C24A 47B5 3964 D4D0 350E E3A6 FF05"            /* .fJG9d5.. */
	$"5400 607B 7015 9800 1205 7A67 004A 5D5B"            /* T.`{p....zg.J][ */
	$"5B5A 5952 4B46 433E 3937 3232 852F 0030"            /* [ZYRKFC>9722/.0 */
	$"8032 1733 2F30 3135 3739 3E14 0027 70BB"            /* 2.3/01579>..'p */
	$"484A BB43 6E8A 79A8 153D DE8A FF00 F396"            /* HJCny.=ފ. */
	$"FF05 F583 0015 1204 9A00 0305 1D00 0480"            /* ........... */
	$"0502 0404 0299 0010 0100 0816 240F 1E48"            /* ...........$..H */
	$"1F40 4D2F 834D 0921 C188 FF05 DD2E 4576"            /* .@M/M!..Ev */
	$"B4FA 80FF 02F9 CCE9 89FF 07CF A275 2908"            /* ..Ϣu). */
	$"0927 05CC 0006 0201 0915 030A 9486 FF01"            /* '........ */
	$"DC2C 8100 0630 6CED DA3B 0443 85FF 04FE"            /* ,..0l;.C. */
	$"9E4B 4B0E 8000 020A 0702 9400 0308 1A10"            /* KK.......... */
	$"0080 01B3 0021 0805 0048 92D3 F1F1 E5CB"            /* ...!...H */
	$"A977 1B00 0B0B 0906 0000 2215 0004 0870"            /* w......."....p */
	$"8B97 9DA0 9894 833F 8000 0408 0F0A 0701"            /* ?...... */
	$"9600 061C 5E3A 0004 0302 B400 1705 1507"            /* ...^:......... */
	$"0004 1517 0B01 0000 150E 0300 0103 0206"            /* ................ */
	$"0806 0412 1780 0002 0101 0380 0005 192C"            /* ............., */
	$"2F41 2208 9800 061C 5E3B 0004 0302 B500"            /* /A"....^;..... */
	$"0B24 5344 271A 1626 1C15 395B 1083 0013"            /* .$SD'..&..9[... */
	$"130D 0021 5236 4B52 3B3D 3522 0000 2F43"            /* ...!R6KR;=5"../C */
	$"3643 2008 8900 FFFF FBFF FFFF FFFF 03FF"            /* 6C ... */
	$"FFFE ED9C E001 DFED 88FF 02FB E4DF 82E0"            /* ..߂ */
	$"03E1 E2E2 E18A E001 DFF2 87FF 02F7 E3DF"            /* ... */
	$"96E0 02DE E8FE 8DFF 02F9 EAE9 8BEA 01E4"            /* ... */
	$"DF89 E001 DEF3 89FF 0EFB EAE9 EAF0 F6F7"            /* ߉.. */
	$"F0ED ECEF F7F7 ECE2 86E0 01E1 FB88 FF01"            /* .. */
	$"F5E8 87EA 01E5 DF89 E002 DFE5 FB8F FF03"            /* .߉.. */
	$"F9ED EDEE 80ED 86EE 01EB E189 E001 DFE9"            /* .. */
	$"8AFF 0FF3 F6F3 C596 7458 4C4B 5571 95B7"            /* .ŖtXLKUq */
	$"DFEC E483 E002 DFE2 FD88 FF01 F5ED 87EE"            /* .. */
	$"01E4 DF89 E001 DFF7 91FF 02F4 ECED 84EE"            /* .߉.. */
	$"82ED 02EE E5DF 89E0 01E1 FC89 FF03 F2BE"            /* .߉.. */
	$"5B06 8500 0503 3E9E D4EA E581 E002 DFE4"            /* [....>. */
	$"FE88 FF01 F1EC 86ED 01EC E189 E002 DFE5"            /* ... */
	$"FE91 FF02 FEF1 ED88 EE03 EDEE EBE1 89E0"            /* .. */
	$"01DF F388 FF01 AD3A 8000 0717 2F41 4746"            /* ..:.../AGF */
	$"3D29 1380 0008 1C70 D1EC E2E0 E0DF E988"            /* =)....p */
	$"FF01 FCEE 86ED 01EE E98A E001 DEF4 93FF"            /* ... */
	$"01FB EF89 EE02 EDEE E689 E002 DFE2 FD85"            /* ... */
	$"FF1A D661 0000 134D 7C96 9CA0 A09F 9E98"            /* .a...M| */
	$"8E75 4A17 0000 228F E1E4 DFDF E988 FF01"            /* uJ...". */
	$"F6EC 86ED 02EE E5DF 88E0 02DF E8FE 94FF"            /* .߈. */
	$"01F6 ED8A EE02 EDE3 DF88 E001 DFF4 84FF"            /* ..߈. */
	$"09BF 1800 035D 94A2 A09B 9A80 9900 9A80"            /* ƿ...]. */
	$"990A 9683 5D15 0000 59E2 E4E0 EA88 FF01"            /* ]...Y. */
	$"F2EC 87ED 00E2 89E0 01DF F695 FF07 FEF1"            /* ... */
	$"EEEF EFEE EFEF 85EE 01E9 DF88 E001 DFE7"            /* .߈. */
	$"83FF 09C7 1800 1973 A39F 9C9C 9B84 990C"            /* ...s. */
	$"9793 8D8C 7329 0000 7CFD F2F3 FE87 FF00"            /* s)..|. */
	$"F086 ED01 EEEA 89E0 02DF E5FD 96FF 01FC"            /* ... */
	$"F182 EF86 EE01 E3DF 88E0 01E1 F780 F80B"            /* .߈.. */
	$"FCC5 1600 408F A39D A0A0 9E9B 8599 0B98"            /* ..@. */
	$"938B 867C 3500 0DB1 E2D7 F086 FF00 FC87"            /* |5... */
	$"ED02 EEE5 DF88 E001 DFF4 98FF 00FB 84EF"            /* .߈.. */
	$"83EE 01EF EA88 E011 E1DF B6A9 ABB2 7D0C"            /* ..߶}. */
	$"0050 A29F 9EA3 A6A4 9E9A 8699 0A98 9389"            /* .P */
	$"807C 2E00 44DE D6E7 86FF 01F8 EC85 ED02"            /* |..D.. */
	$"EEEB E188 E001 DEEC 9AFF 01F4 EE83 EF84"            /* .. */
	$"EE01 E4DF 86E0 10E1 DDB1 ADB4 A31C 0032"            /* .߆.ݱ..2 */
	$"9F9C 9DA4 A9A9 A39D 8899 0997 8E83 7D64"            /* Ɨ}d */
	$"0403 A5DD E186 FF01 F5EC 85ED 02EE E8DF"            /* .... */
	$"89E0 00F9 9AFF 01FD F184 EF82 EE01 EFEB"            /* ... */
	$"87E0 10E1 D9C3 C4CC 4700 1E90 9E9D A3AB"            /* .G.. */
	$"ACA8 A09A 8999 0993 897D 7B2B 003B C1C7"            /* Ɠ}{+.; */
	$"FC85 FF01 F2EC 85ED 02EE E5DF 87E0 01DE"            /* ..߇. */
	$"EC9C FF00 FA85 EF82 EE01 EFE8 88E0 0DDE"            /* ... */
	$"E77F 001D 8C9F 9DA3 ABB0 ACA3 9C8A 9909"            /* ... */
	$"968E 817E 5800 07AA CEFC 84FF 01FE EF86"            /* ~X... */
	$"ED01 ECE1 89E0 00F8 9DFF 00F7 85EF 82EE"            /* ... */
	$"01ED E286 E00E E2EB DC22 006E A49B A0AB"            /* ..".n */
	$"B1B1 A89F 9A8A 9909 9890 847C 6F0C 0076"            /* Ƙ|o..v */
	$"B9FA 84FF 00FC 86ED 01EE E988 E001 DFEB"            /* ... */
	$"8BFF 01F7 F68F FF00 F485 EF81 EE02 EFE8"            /* ... */
	$"DF84 E00E E4C5 A945 0036 9E9B 9EA8 B2B4"            /* ߄.ũE.6 */
	$"AEA2 9C8C 9908 9387 7D79 2600 4FAF FA84"            /* .}y&.O */
	$"FF01 F9EC 85ED 02EE E6DF 88E0 00F7 8AFF"            /* ..߈. */
	$"02F7 E0E0 8FFF 01FD F185 EF82 EE00 E384"            /* ... */
	$"E00D E2E0 8500 0D87 9F9D A5B1 B7B3 A79D"            /* ... */
	$"8D99 0894 8A7E 7E3F 0035 AEF7 84FF 02F5"            /* .~~?.5. */
	$"ECEE 83ED 02EE EDE2 87E0 01DF EE8B FF05"            /* ... */
	$"E9DF E0F0 EEF7 8DFF 00F8 85EF 81EE 01EF"            /* .. */
	$"EA84 E00D E1D6 3900 4DA3 9CA1 ACB7 B7AE"            /* .9.M */
	$"A19B 8D99 0895 8B7F 7E4E 001B 6FEF 84FF"            /* ..~N..o */
	$"01F2 ED81 EE00 ED80 EE00 EA87 E002 DFE1"            /* .... */
	$"FC8A FF00 F780 E003 DEDD E2F5 8CFF 01FE"            /* ... */
	$"F386 EF81 EE01 E2DF 82E0 0CE8 9D02 128A"            /* .߂... */
	$"9E9F A7B3 B9B4 A89E 8E99 0895 8C80 7B5B"            /* .{[ */
	$"0010 B0FA 83FF 01FE EF86 EE01 E7DF 86E0"            /* ....߆ */
	$"01DF F08B FF01 EDDE 81E0 02DF E0F3 8CFF"            /* ..ށ. */
	$"02FD F2EE 86EF 03EE EEEB E181 E00D E1EB"            /* ... */
	$"5000 69A3 9CA5 B0BA B8AC A29B 8E99 0895"            /* P.i. */
	$"8C80 7A64 020C A9F4 83FF 00FB 87EE 00E3"            /* zd.... */
	$"86E0 02DF E2FB 8AFF 02FB E7DF 84E0 00F3"            /* ..߄. */
	$"8CFF 01FB F087 EF03 EEEF E8DF 80E0 0DE8"            /* ..߀. */
	$"B00A 1D99 9CA0 ADB8 BCB2 A59D 9A8E 9908"            /* .. */
	$"958B 8079 6806 056E F383 FF01 F7ED 84EE"            /* yh..n. */
	$"01EF E987 E001 DFEE 8AFF 03FD F0E6 DF83"            /* ...߃ */
	$"E002 DFE1 FB8C FF07 F6F1 F3F4 F6F5 F3F1"            /* .. */
	$"82EF 11ED E1E0 E0E1 E94D 0055 A39C A6B4"            /* .M.U */
	$"BCB9 ACA0 9B8F 9908 948A 7F78 6909 0362"            /* ..xi.b */
	$"F883 FF01 F3ED 85EE 01E4 DF86 E001 E1FB"            /* ..߆. */
	$"8AFF 03F4 EDE7 DF84 E002 DFE4 F48C FF08"            /* .߄.. */
	$"F0E3 D6CD D5E2 F0FC F680 EF11 F0E8 E0E0"            /* . */
	$"E6C4 0C08 879E A0AD BABD B5A7 9C9A 8F99"            /* .. */
	$"0894 897E 7869 0903 63F7 82FF 01FD EF85"            /* .~xi.c. */
	$"EE01 EDE2 86E0 01DE ED8A FF04 F8ED EEE7"            /* ... */
	$"DF85 E002 DFE0 F388 FF1F F5B8 6E32 1104"            /* ߅..n2.. */
	$"0004 1443 86CF FAF0 EFEF EEE3 E0EC 7700"            /* ...Cw. */
	$"3AA0 9EA6 B5BE BBAE A19A 9099 0893 877C"            /* :.| */
	$"7867 0607 86FA 82FF 00FA 85EE 02EF E9DF"            /* xg.... */
	$"85E0 02DF E7FE 89FF 05FA EEED EEE7 DF86"            /* ..߆ */
	$"E002 DFE0 F986 FF1F BA35 010E 3045 4C42"            /* ..5..0ELB */
	$"2B0E 0000 149B F9F2 EFF0 E8E1 E131 006A"            /* +....1.j */
	$"A3A0 ACBA BEB6 A89D 9099 0998 9185 7B77"            /* Ƙ{w */
	$"6502 0FC1 FE82 FF01 F7ED 84EE 02EF E6DF"            /* e.... */
	$"85E0 01DE F389 FF06 FEF0 EDEE EEE7 DF87"            /* ..߇ */
	$"E002 DFE6 FA83 FF21 D954 1142 7A98 9FA1"            /* .!T.Bz */
	$"A1A0 9D90 631D 0000 78F8 F2EF EFEC B603"            /* c...x. */
	$"1A93 A0A6 B4BF BBB0 A39B 9099 0898 8F82"            /* .. */
	$"7978 5E00 0CAA 83FF 03F5 EEEF EF83 EE00"            /* yx^.... */
	$"E285 E002 DFE5 FC89 FF01 F5ED 80EE 01E6"            /* ... */
	$"DF88 E00E DFE2 DCDB DBE1 D977 102D 8BA9"            /* ߈.w.- */
	$"A59D 9A80 9917 9A9B 9A86 4C04 007F F6F0"            /* .L... */
	$"F1F8 6600 65A4 A2AE BBC0 B5A8 9E9A 9099"            /* f.e */
	$"0896 8B7E 767A 5200 1B93 83FF 00F2 81EF"            /* .~vzR... */
	$"80EE 01EF EB87 E000 F589 FF00 F981 EE02"            /* .... */
	$"EFE6 DF89 E00C DECC CBCB D85D 004D A7AB"            /* ߉.].M */
	$"A49F 9B83 9914 958F 8B50 0000 ABFB F2E8"            /* .P.. */
	$"1E09 909F A6B5 BFBD AFA3 9B91 9908 9388"            /* .Ɛ. */
	$"7C75 7B49 003E E782 FF01 FCF0 81EF 80EE"            /* |u{I.>. */
	$"02EF E7DF 84E0 01DF E789 FF01 FBEF 81EE"            /* .߄.. */
	$"02EF E7DF 8AE0 0BD6 D7C4 8300 54AB AAA9"            /* .ߊ.ă.T */
	$"A49F 9A83 9914 9890 877F 2700 58F7 FCB5"            /* ..'.X */
	$"0032 9FA0 ACBA C0B8 AA9F 9A90 9909 9891"            /* .2Ƙ */
	$"867A 757B 3C00 30C3 82FF 01FA EE83 EF03"            /* zu{<.0Â.. */
	$"EEEE E3DF 84E0 01DE F188 FF01 FEF1 82EE"            /* ߄.. */
	$"02EF E7DF 8AE0 0AD0 D17A 003D AAAC AFAA"            /* .ߊz.= */
	$"A29D 8599 1293 8881 6302 18E1 F64A 0066"            /* .c..J.f */
	$"A4A4 B3BF BFB2 A49C 9199 0996 8F82 7774"            /* Ɩwt */
	$"782C 0063 EE82 FF0A F7F0 F4F7 F8F7 F7F3"            /* x,.c */
	$"F1EC E184 E002 DFE5 FC88 FF01 F4ED 82EE"            /* .. */
	$"02EF E7DF 89E0 0BE1 DB9C 0618 9AAF B1B1"            /* .߉.ۜ.. */
	$"A79E 9A85 9912 9388 7D7A 1E00 C8B7 000D"            /* .}z..ȷ.. */
	$"8FA2 AABA C0BB AC9F 9A91 9909 948B 7E75"            /* Ɣ~u */
	$"7475 1800 78EC 83FF 0AEF D6C2 BCC0 C4E0"            /* tu..x¼ */
	$"F9F3 E4E1 83E0 01E1 F988 FF01 F7ED 83EE"            /* .. */
	$"02EF E7DF 89E0 0AE3 DB47 0061 AFB1 B5AF"            /* .߉G.a */
	$"A39B 8599 1298 9288 7C7E 3700 AF77 0031"            /* .|~7.w.1 */
	$"9FA3 AFBD BFB6 A79C 9199 0A98 9287 7B74"            /* {t */
	$"756D 0A01 74DE 81FF 0EDA 8E40 1604 0102"            /* um.tށ.ڎ@.... */
	$"0623 6399 CBEA E8E1 80E0 01DF EA88 FF01"            /* .#c.. */
	$"FDEF 84EE 02EF E7DF 89E0 09E9 B303 2CA0"            /* .߉., */
	$"AEB5 B4AA 9F86 9912 978F 847A 7D4B 0097"            /* .z}K. */
	$"3000 5FA6 A7B4 C0BD B0A2 9A91 990F 9690"            /* 0._. */
	$"8479 7377 5D00 1397 F2FF FFBF 4708 8000"            /* ysw]..G.. */
	$"0305 0908 0480 0004 115A BAE7 E680 E000"            /* .......Z. */
	$"F587 FF02 FDF2 ED84 EE02 EFE7 DF88 E00A"            /* ..߈ */
	$"E1EB 5D00 84AD B3B7 B0A5 9C86 9911 958B"            /* ].. */
	$"8077 7A52 0861 0508 8AA5 AEBB C0B7 AA9E"            /* wzR.a.. */
	$"9299 2194 8C80 7672 7A46 0037 B2FF F57B"            /* !vrzF.7{ */
	$"0400 0531 5C74 848C 8982 7150 3007 0005"            /* ...1\tqP0... */
	$"519E D2BC E587 FF02 FEF3 ED85 EE02 EFE6"            /* QҼ.. */
	$"DF88 E009 E4D6 1025 A5AE B7B4 AA9F 8699"            /* ߈.% */
	$"1298 9287 7C74 7C40 041C 002A 9EA7 B4BE"            /* .|t|@...* */
	$"BEB2 A59C 9199 2398 9287 7C74 727A 2F00"            /* #|trz/. */
	$"56BD D342 0000 4288 9EA3 A09D 9C9C 9D9E"            /* VB..B */
	$"9D96 7D3A 0000 18B3 B4E2 FB86 FF01 F7ED"            /* }:.... */
	$"85EE 02EF EBE1 84E0 00DF 81E0 09EC A200"            /* ..߁. */
	$"57AF B2B8 B0A6 9C86 9912 978F 8279 7479"            /* W.yty */
	$"3000 0300 58A5 AAB9 C0BA ACA1 9A91 9911"            /* 0...X. */
	$"978F 8479 7373 7517 068F D664 0002 56A2"            /* yssu..d..V */
	$"A19B 8599 0997 958B 5613 0032 A8E6 F685"            /* ƗV..2 */
	$"FF01 FDEF 85EE 03EF EDE3 DF83 E001 E3E3"            /* ..߃. */
	$"80E0 0AE2 E344 048C B1B6 B7AB A09A 8699"            /* D. */
	$"1195 8B7E 7673 731B 0000 1692 A4B0 BDC0"            /* .~vss.... */
	$"B6A6 9D92 9911 958B 8077 7276 6701 2BC3"            /* .wrvg.+ */
	$"A403 0360 AAA3 9E9B 8699 0897 918E 7016"            /* ..`.p. */
	$"0035 CCF3 84FF 02FD F1ED 84EE 03EF EEE3"            /* .5.. */
	$"DF83 E00F DFE6 F0E5 DFE0 E8B3 002B A8B2"            /* ߃..+ */
	$"B8B3 A69C 8699 1298 9387 7A74 746C 0900"            /* .zttl. */
	$"003F A4A5 B4BF BEB0 A29B 9299 1192 887C"            /* .?.| */
	$"7472 7A4C 0055 D147 005B ADA9 A6A0 9B87"            /* trzL.UG.[ */
	$"9907 958C 8961 0300 83FB 84FF 01F2 ED85"            /* .a... */
	$"EE02 EDE3 DF84 E00F DFE4 F1EF E7E1 ED7A"            /* .߄.z */
	$"0058 B2B5 B7AF A19B 8699 1296 9083 7874"            /* .X.xt */
	$"765D 0300 0063 A6A9 B9C0 BAAA 9F9B 9199"            /* v]...c */
	$"1297 9084 7973 737B 3200 74B8 0F16 9DAE"            /* .yss{2.t.. */
	$"AEA7 A09A 8799 0697 9187 7F27 004C 84FF"            /* ..'.L */
	$"01F8 ED86 EE01 E5DF 85E0 0EDF E4F0 F0F1"            /* ..߅. */
	$"EEE3 3501 88B4 B8B6 A89D 8799 1194 8B7E"            /* 5..~ */
	$"7572 7947 0000 0A8A A5AE BDBF B5A5 9C92"            /* uryG.. */
	$"9911 968D 8077 7275 7410 0CB2 7A00 53B2"            /* .wrut..z.S */
	$"B1B1 A69D 8999 0695 8C85 5200 17EE 82FF"            /* .R.. */
	$"01FB EF85 EE01 EFE6 87E0 01DF E480 F009"            /* ... */
	$"F8CD 0621 A6B5 B8B2 A49B 8699 1297 9187"            /* .!. */
	$"7A74 7278 3400 002C A0A6 B4BE BBAF A19A"            /* ztrx4.., */
	$"9199 1298 9488 7C75 727B 4E00 42AB 4001"            /* .|ur{N.B@. */
	$"7EB5 B5AF A39B 8999 0696 9085 6F0A 01BC"            /* ~.o. */
	$"81FF 01FE F185 EE01 EFE7 88E0 01DF E480"            /* ... */
	$"F009 FDA1 0050 B1B6 B7AD A09A 8699 1196"            /* .P. */
	$"8E84 7973 7374 2200 004E A7A8 B8BF B8AA"            /* ysst"..N */
	$"9E92 9912 9791 8479 7373 7929 0063 A215"            /* .yssy).c. */
	$"0793 B4B6 ADA0 9A89 9906 9892 867F 2D00"            /* ...-. */
	$"8A81 FF01 F5ED 84EE 01EF E889 E00D DFE4"            /* ... */
	$"F0F0 F1FB 6305 8FB2 B7B4 A99E 8799 1194"            /* c.. */
	$"8A80 7672 736E 0F00 0175 A8AD BABE B3A6"            /* vrsn...u */
	$"9D92 9911 968E 8177 7375 6F0D 006B C124"            /* .wsuo..k$ */
	$"0EA1 B5B6 AC9F 8B99 0593 8782 5100 5780"            /* ..Q.W */
	$"FF02 F7EE EF83 EE01 EFE8 8AE0 0DDF E4F0"            /* ... */
	$"F0F4 E923 2EAA B2B7 B0A5 9C86 9912 9892"            /* #.. */
	$"877C 7472 755E 0400 1596 A7B2 BDBB ACA2"            /* |tru^... */
	$"9A92 9911 938A 7D75 7279 5400 11A3 A91A"            /* .}uryT... */
	$"13A4 B6B7 AC9E 8B99 0B95 8A80 6801 25F4"            /* ..h.% */
	$"FFFA EFEE EF82 EE01 EFE9 8BE0 0DDF E5F0"            /* .. */
	$"F0F7 CB00 5AB2 B5B6 ACA1 9A86 9911 978F"            /* .Z. */
	$"827A 7471 784C 0000 36A3 AAB6 BEB6 A89E"            /* ztqxL..6 */
	$"9299 1297 9085 7974 727A 3700 39BC 9B17"            /* .ytrz7.9. */
	$"15A4 B7B8 AD9F 8B99 0996 8C80 740F 06DA"            /* .Ɩt.. */
	$"FFF0 EE80 EF80 EE01 EFEB 8CE0 0CDF E4EF"            /* .. */
	$"F0FC 9B00 7DB2 B6B4 A99F 8799 1196 8C80"            /* .}. */
	$"7772 7178 3A00 0055 A9AD BABD B2A4 9C92"            /* wrqx:..U */
	$"9912 958C 8177 7273 751A 005D C491 1616"            /* .wrsu..]đ.. */
	$"A5B8 B9AE 9F8B 9907 978D 8079 2300 B8FF"            /* .y#. */
	$"81EF 80EE 02EF EAE2 8CE0 0CDF E4EF F0FC"            /* .. */
	$"6508 9CB1 B7B1 A59D 8799 1194 897D 7672"            /* e..}vr */
	$"7274 2200 037C A9B2 BDBC ADA0 9A92 9913"            /* rt"..|. */
	$"9287 7D75 7277 6103 0075 A67E 1318 A6BA"            /* }urwa..u~.. */
	$"BCAF A19A 8A99 0797 8E82 7F39 0083 FC81"            /* ..9. */
	$"EF04 EEEE EFEB E18D E00C DFE4 EFF2 EF38"            /* ..8 */
	$"29AA B2B7 AFA2 9B87 9910 9387 7A74 7273"            /* ).ztrs */
	$"6D0F 001D 9AA8 B5BD B8A9 9E92 9914 978F"            /* m.... */
	$"847A 7472 7A44 0008 8F86 680F 1AA6 BBBD"            /* ztrzD..h.. */
	$"B2A1 9A8A 9908 978F 827F 4B00 57F6 F081"            /* ..K.W */
	$"EF02 EEED E187 E000 DF83 E00C DFE3 EFF4"            /* ..߃. */
	$"E113 49B1 B4B6 ADA0 9A86 9911 9891 8579"            /* .I.y */
	$"7471 755F 0300 50A7 AAB8 BDB5 A59B 9299"            /* tqu_..P */
	$"1496 8C80 7872 7278 2800 3AD8 9052 0B1E"            /* .xrrx(.:ؐR.. */
	$"A7BC BEB4 A29A 8A99 0898 9082 7D58 0028"            /* .}X.( */
	$"E3F3 81EF 02EE E4DF 86E0 02DE E7F6 80F7"            /* .߆. */
	$"80DE 0AE6 F1F9 AF00 6CB3 B5B5 A99E 8799"            /* .l */
	$"1197 9083 7873 7178 4400 0178 A6AE BBBC"            /* .xsqxD..x */
	$"B0A1 9A91 9915 9893 887B 7572 756C 0A00"            /* .{urul. */
	$"72BF 5B35 0623 A9BD C1B6 A49B 8A99 0E98"            /* r[5.#. */
	$"9083 7C68 0204 CAF6 EFEF F0EE E3DF 85E0"            /* |h..߅ */
	$"03DF DFE9 FD81 FF0D F0EF F3FB FDFF 6F00"            /* ..o. */
	$"89B1 B5B4 A79C 8799 1097 9083 7873 7277"            /* .xsrw */
	$"3500 1293 A5B2 BCBA AC9E 9299 1597 9083"            /* 5... */
	$"7874 727A 5100 048A A060 3D01 29AA BDC2"            /* xtrzQ..`=.) */
	$"B8A5 9B8A 990D 9890 847B 6F0E 00AA FAEF"            /* .{o.. */
	$"F0EF E3DF 85E0 02DF E4F2 89FF 0754 0499"            /* ߅..T. */
	$"B1B5 B2A5 9B87 9910 9790 8378 7372 7846"            /* .xsrxF */
	$"002C 9EA6 B5BC B7A8 9D92 9915 958D 7F76"            /* .,..v */
	$"7272 782B 001B D3DF CE9F 002F ACBE C2B8"            /* rrx+..Ο./¸ */
	$"A59B 8A99 0C98 9084 7B73 1800 9DFB EFF0"            /* .{s.. */
	$"E6DF 85E0 02DE E3FA 89FF 08FE 3B18 A3B1"            /* ߅..;. */
	$"B5B0 A39B 8799 1098 9186 7B74 7278 4C00"            /* .{trxL. */
	$"4CA7 A9B8 BCB4 A69C 9199 1698 9389 7C75"            /* L.|u */
	$"7276 6305 004C E8DD 8560 0036 ADBE C2B8"            /* rvc..L݅`.6¸ */
	$"A59B 8A99 0A98 9084 7B76 2200 82FC F0E7"            /* {v". */
	$"86E0 02DE E6F9 8AFF 08F7 2030 A8B0 B4AD"            /* .. 0 */
	$"A29A 8899 0F95 8B80 7875 762C 006F A8AD"            /* .xuv,.o */
	$"BBBA AFA2 9B91 9916 9790 8478 7272 7A44"            /* .xrrzD */
	$"0000 7EF1 D963 3C00 3FB0 BDC2 B5A4 9B8A"            /* ..~c<.?µ */
	$"9909 9890 847A 792E 0072 FEE7 87E0 01EE"            /* Ƙzy..r. */
	$"FD8B FF07 F20F 3FAB B0B3 AB9F 8999 0E98"            /* ..?. */
	$"9187 7F7B 6A06 078C A7B1 BBB7 AB9F 9299"            /* .{j.. */
	$"1694 8C7F 7672 7377 2800 01A9 EBD2 AC61"            /* ..vrsw(..Ҭa */
	$"004A B3BB BEB1 A29A 8A99 0898 9084 7A7B"            /* .J.z{ */
	$"3600 69F4 85E0 02DF E0F4 8DFF 07ED 094B"            /* 6.i..K */
	$"ADAF B2AA 9E8A 990D 968F 8886 5C00 1C99"            /* .\.. */
	$"A9B4 BCB5 A89D 9299 1691 887C 7572 7370"            /* .|ursp */
	$"1100 11CD EAC0 763A 0057 B5B9 BAAE A09A"            /* ...v:.W */
	$"8A99 0998 9084 7A7A 3B00 57E9 E183 E002"            /* Ƙzz;.W. */
	$"DFE4 F58E FF07 E706 53AE AEB0 A89D 8B99"            /* ..S */
	$"0C96 9295 4900 3DA5 AAB7 BCB2 A59C 9199"            /* .I.= */
	$"1697 8E83 7974 7177 5901 0041 E5E3 DBC4"            /* .ytqwY..A */
	$"3200 67B3 B6B5 A99D 8B99 0998 9083 797A"            /* 2.gƘyz */
	$"4100 4BE5 E282 E002 DFED FE8F FF07 E606"            /* A.K... */
	$"57AE ADAF A79D 8E99 0932 005B A9AC B9BB"            /* W2.[ */
	$"AEA2 9B91 9916 958A 7F76 7272 7B3D 0000"            /* ..vrr{=.. */
	$"77F6 E1EA D40D 007D AFB0 ADA3 9B8B 9909"            /* w..} */
	$"9890 8379 7A44 0047 E4E2 81E0 01DE EB89"            /* yzD.G. */
	$"FF02 FBE9 E882 FF07 F109 56AD ACAD A69C"            /* ..V */
	$"8C99 0B9A 961B 0074 A9B0 BAB9 ABA0 9A90"            /* ...t */
	$"9917 9892 867C 7679 7670 2100 0098 EDCB"            /* .|vyvp!.. */
	$"B76C 000A 91AA ABA7 9F9A 8B99 0F97 9082"            /* l.. */
	$"7979 4700 45E3 E2E0 E0DF E0EE FE89 FF02"            /* yyG.E. */
	$"EEDE DF82 FF07 D20A 4EAB AAAB A49B 8C99"            /* ߂.N */
	$"0A9D 8804 098E A8B4 BBB6 A89D 9199 0797"            /* .Ǝ. */
	$"8E81 7D75 4C25 0E80 000B 1931 3B2E 0000"            /* }uL%....1;... */
	$"2CA1 A6A5 A19B 8C99 0D97 8F81 7879 4800"            /* ,.xyH. */
	$"45E3 E2E0 DEE6 F88A FF10 F4DF E0E0 EEEE"            /* E. */
	$"F0F5 DA92 1C40 A7A7 A9A3 9B8C 990A A16B"            /* ڒ.@¡k */
	$"0023 9EA9 B7BC B3A4 9C91 9904 958A 8563"            /* .#.c */
	$"1C81 0002 090F 0981 0005 0A7A A3A0 9F9D"            /* ....Ɓ..z */
	$"8D99 0C97 8D80 7879 4500 47E6 E2DF E9FD"            /* .xyE.G */
	$"89FF 12FE F7E8 DFE0 E0DD E0D3 AEAB B22F"            /* .Ӯ/ */
	$"2CA2 A6A6 A29B 8C99 0AA4 5300 3EA4 ABB9"            /* ,¤S.> */
	$"BBB1 A39B 9099 1698 928F 5D01 001F 415F"            /* .]...A_ */
	$"6E87 9390 7556 381F 61A3 9C9D 9C9A 8D99"            /* nuV8.a */
	$"0B96 8C7F 7679 4200 45D9 E2E8 FE89 FF04"            /* ..vyB.E. */
	$"FBF2 EEE7 DF80 E00B E1DC B5A0 A949 119B"            /* ߀.ܵI. */
	$"A3A2 9F9B 8B99 0B9A 9F3B 0063 A8AD BABA"            /* .;.c */
	$"AEA0 9A90 9912 9696 6F0E 3070 939D 9F9E"            /* .o.0p */
	$"9C9B 9CA0 A29D 989D 9980 9A8E 9909 968C"            /* Ɩ */
	$"7F76 793B 0025 54CE 89FF 06FB F3EE EEEF"            /* .vy;.%TΉ. */
	$"E7DF 81E0 0AE1 E3BD B89B 0F81 A19D 9C9A"            /* ߁㽸. */
	$"8B99 0A9B 991D 098E A6B1 BBB9 AA9E 9199"            /* .Ǝ */
	$"0697 8B36 6798 9C9A 8599 019A 9B93 9909"            /* .6g. */
	$"958A 7C76 7936 0042 A0EE 87FF 08FB F5EF"            /* |vy6.B. */
	$"EDEE EEEF E7DF 83E0 07E5 DED5 2D51 A49A"            /* ߃.-Q */
	$"9A8C 990A 9C8F 0623 9FA5 B4BC B6A8 9C91"            /* .# */
	$"9904 9B6C 759D 989F 9908 9488 7B75 772E"            /* .lu.{uw. */
	$"0032 D286 FF02 FEF5 EF82 EE02 EFE7 DF83"            /* .2҆..߃ */
	$"E006 E1DF C151 219D 9A8D 990A 9E7E 003A"            /* .Q!~.: */
	$"A2A7 B6BB B4A5 9B91 9902 947F 98A0 9909"            /* .. */
	$"9892 867A 7574 2200 65F3 84FF 03FE FAF2"            /* zut".e. */
	$"EE81 EF04 EEEE EFE7 DF85 E004 E2B6 0A6A"            /* .߅.j */
	$"A38D 990A A267 0056 A8A9 B8BB B2A4 9B91"            /* ¢g.V */
	$"9901 9797 A199 0897 9183 7875 6F14 00B2"            /* ..xuo.. */
	$"84FF 03FA F2EF EE84 EF01 EEE6 86E0 05E2"            /* ... */
	$"EB69 0E8A 9F8C 990A A350 006E A7AB B9BA"            /* i.£P.n */
	$"AFA1 9AB7 9908 968E 8076 7566 0309 DB82"            /* .vuf.ۂ */
	$"FF03 FAF3 EFEE 83EF 03F0 EEE8 E388 E005"            /* ... */
	$"E6CF 0E22 9A9E 8A99 0A9A 9F3E 0082 A5AE"            /* .">. */
	$"BAB8 AC9F B899 0894 8A7F 7577 5600 38F6"            /* ..uwV.8 */
	$"80FF 03FD F5EF EE82 EF05 F0F0 EDE8 E2DF"            /* .. */
	$"8AE0 06EA 9905 3197 A19A 8899 0A9A 9D29"            /* ..1) */
	$"0994 A5B1 BAB6 AA9E B799 0E98 9288 7B74"            /* Ɣ.{t */
	$"7940 0081 FFFF FDF7 F1EE 82EF 05F0 EFEB"            /* y@.. */
	$"E7E2 DF8D E007 ECAD 111E 759E 9E9A 8699"            /* ߍ...u */
	$"0A9A 9812 229C A6B3 BBB4 A79B B799 0C96"            /* .". */
	$"8E83 7873 7523 01C7 FFF8 F0EE 82EF 05F0"            /* xsu#.. */
	$"EEEA E3E0 DF90 E009 F0A6 0D00 3D88 9FA2"            /* ߐ..= */
	$"9D9A 8399 0A9E 8703 36A2 A8B5 BAB2 A49B"            /* .6 */
	$"B799 0A94 8A7F 7674 6D07 1CEC F8EE 81EF"            /* .vtm.. */
	$"06F0 F0EE E9E2 E0DF 8CE0 01DF DF82 E00B"            /* .ߌ.߂. */
	$"EABD 4E05 0031 5F89 9FA2 9D9A 8099 0AA1"            /* N..1_¡ */
	$"6E00 4DA9 A9B6 BAAF A29A B699 0A98 9186"            /* n.M */
	$"7C74 7951 0061 F9F0 80EF 04F0 EFEC E8E2"            /* |tyQ.a. */
	$"8FE0 21E2 E7E5 E2E0 E0DF E0E0 E8E7 BA5D"            /* !] */
	$"1100 0132 6489 9EA0 9A99 A155 0064 A8AC"            /* ...2dU.d */
	$"B8B8 ACA1 9AB6 9911 958B 8078 756E 1602"            /* .xun.. */
	$"B6FA EFEF F0EE EAE4 E0DF 8FE0 22DF E4EF"            /* ߏ" */
	$"EEEE ECE9 E6E2 E0DF E0E8 E9D0 A254 0200"            /* ТT.. */
	$"002D 729C A2A6 4000 77A8 AEB9 B7A9 9F9A"            /* .-r@.w */
	$"B599 1097 9085 7A74 7A48 0035 F0F2 F0EE"            /* .ztzH.5 */
	$"E7E2 E0DF 8AE0 01DF DF82 E001 DFE4 81EE"            /* ߊ.߂. */
	$"1BEF EFEE EBE9 E6E3 E2E4 EAE8 BE84 4E0D"            /* .辄N. */
	$"0017 4E81 3201 89A7 B0B9 B6A8 9EB6 990D"            /* ..N2.. */
	$"948B 7F77 7572 1800 92FC EDE8 E2DF 8AE0"            /* .wur..ߊ */
	$"05DF DEE0 E2E4 E181 E001 DFE4 81EE 80EF"            /* .. */
	$"80F0 15EF EDEA E8E6 E9EE E8CB 8739 0001"            /* .ˇ9.. */
	$"0415 95A7 B2BA B4A6 9DB5 990C 948D 8378"            /* ...x */
	$"747A 3D00 35E8 E8E0 DF88 E00F DFDE DFE1"            /* tz=.5߈. */
	$"E6F0 F6FB FEFA F6F7 E0E0 DFE4 82EE 84EF"            /*  */
	$"13F0 F0EF EEED ECEC F0E7 920C 0029 9CA9"            /* ...) */
	$"B4BA B2A3 9BB3 990C 9894 8C82 7A74 7959"            /* .ztyY */
	$"0424 C6E8 DF86 E008 DFDE DEE0 E5ED F3FA"            /* .$߆. */
	$"FE84 FF03 E0E0 DFE4 83EE 88EF 0EF0 F0EF"            /* .. */
	$"F1FD 8300 36A2 A9B5 B9B0 A19B B299 0C97"            /* .6. */
	$"948D 837B 7578 6913 0097 F5DF 83E0 08DF"            /* {uxi..߃. */
	$"DEDF E0E2 EAF0 F9FE 88FF 03E0 E0DF E483"            /* . */
	$"EE8C EF0A F7D0 0046 A7AB B6B8 AEA0 9BAF"            /* .F */
	$"991A 9897 9490 8B83 7B77 7B5E 0F07 164A"            /* .{w{^...J */
	$"D2E9 E0DF DFDE E0E1 E4EA F3F8 FD8C FF03"            /* . */
	$"E0E0 DFE4 84EE 8BEF 0AF9 B000 5BA8 ADB7"            /* .[ */
	$"B7AB 9F9A AD99 1897 9593 8F8A 857F 7979"            /* ..yy */
	$"7849 0819 BCD2 1321 C3E7 E2E7 EDF6 FAFE"            /* xI...! */
	$"90FF 03E0 E0DF E384 ED02 EEEF EE88 EF0A"            /* .. */
	$"FB98 0069 A8AE B7B6 A99D 9A96 9903 9DA1"            /* .i. */
	$"A19D 8D99 1697 9593 908C 8985 7F7B 797B"            /* ..{y{ */
	$"6632 0000 2CE3 FFB2 012C E4FD 95FF 0DDE"            /* f2..,.,. */
	$"DEDF F0FB F9F7 F6F4 F2F1 F0EF EF82 EE83"            /*  */
	$"EF09 FD77 007B A7B0 B8B5 A89C 9699 05A0"            /* w.{. */
	$"8449 3E86 9D88 9909 9897 9592 8F8C 8986"            /* I>Ƙ */
	$"807D 807B 0C6C 3800 003B 8A04 3CFC FFAF"            /* }{.l8..;.< */
	$"018F 94FF 04FD FDF0 EFF5 84FF 18FE FDFC"            /* ... */
	$"FAF9 F7F5 F4F3 F1F0 EFEF EEEF F95C 028C"            /* \. */
	$"A6B1 B7B2 A59C 9599 07A0 6917 4B1E 2398"            /* .i.K.# */
	$"9B83 991E 9897 9594 928E 8A87 837F 7C79"            /* ..|y */
	$"7778 785E 3207 003E 9CEC FF6A 00D5 FFFF"            /* wxx^2..>j. */
	$"8312 E792 FF02 F3E2 E290 FF0F FEFD FCFA"            /* ... */
	$"F8F8 F53D 1998 A6B2 B7B1 A49B 9499 089E"            /* =.. */
	$"8209 ABFF C008 8A9D 8099 1697 9694 928F"            /* ƫ.. */
	$"8C88 8682 7D7B 7876 7679 7761 2600 0021"            /* }{xvvywa&..! */
	$"ADFD 80FF 07D4 048D FFFF FA22 8F91 FF03"            /* ..". */
	$"F7E0 DFDF 96FF 09F5 242F A1A6 B2B7 AFA2"            /* ߖ$/ */
	$"9A94 9920 A136 49FF FFEB 1677 9D97 9694"            /*  6I.w */
	$"928F 8C89 8581 7E7B 7977 777A 776C 4D20"            /* ~{ywwzwlM  */
	$"0000 3B93 E482 FF08 FA1B 49FE FFFF 7F38"            /* ..;..I.8 */
	$"FA84 FF0F FEFE FDFC FBFB F9F8 F8F6 F5F5"            /* . */
	$"E9DE E0E0 96FF 09EB 0B46 A4A6 B3B7 AEA1"            /* .F */
	$"9A93 9921 9F7C 05BE FFFF F526 6498 8F8C"            /* !|.&d */
	$"8985 817F 7C7A 7676 787A 766C 5025 0100"            /* .|zvvxzvlP%.. */
	$"2069 B6F0 FDFD 82FF 12FC 1F2B FBFF FFD0"            /*  i..+ */
	$"1ADC FDF8 F7F6 F6F4 F3F2 F2F1 80F0 82EF"            /* . */
	$"04F0 E8DF E0E0 96FF 08D3 015F A6A7 B4B5"            /* ..._ */
	$"AB9F 9499 299E 351B F7FF FFFB 354F 8C82"            /* )5.5O */
	$"7F7C 7977 7675 777A 7561 4223 0500 2060"            /* .|ywvuwzuaB#.. ` */
	$"A8E4 FBF9 F1EE F2FC FEFF FFC3 5100 6480"            /* Q.d */
	$"FF03 F528 AAFA 82EF 89F0 04F1 E8DF E0E0"            /* .(. */
	$"96FF 08C0 0069 A6A8 B4B4 AA9E 9199 0598"            /* ..i. */
	$"9797 9214 4681 FF22 473B 837A 7979 7A79"            /* .F"G;zyyzy */
	$"746F 5C42 1B00 0006 358B E6FC FDF6 F2F2"            /* to\B....5 */
	$"F3F6 FBF9 E5BF 6400 0043 E080 FF05 FB2A"            /* d..C.* */
	$"7EF9 ECEC 81ED 84EE 81EF 04F0 E8DF E0E0"            /* ~. */
	$"95FF 09FD 9800 77A3 A9B4 B3A9 9E91 9905"            /* .w. */
	$"9591 8F7F 006B 81FF 2161 1A79 7268 5B49"            /* ..k!a.yrh[I */
	$"3018 0200 0B2B 67AA E4FB FFF9 F2EC ECEB"            /* 0....+g */
	$"E6E0 CC9A 5017 000D 55B1 FB81 FF09 F81D"            /* ̚P...U. */
	$"4FE9 E1E0 E1E0 E1E0 84E1 82E2 00E1 80E0"            /* O. */
	$"94FF 0AA8 3B0C 0884 A2AB B4B2 A79D 9099"            /* ¨;.. */
	$"0696 8E86 8467 0086 81FF 038E 0128 0F80"            /* .g...(. */
	$"0017 1544 76A7 C8D5 C8AC 8D79 6148 3C29"            /* ...DvȬyaH<) */
	$"2721 1411 0D19 4E6A A5E6 84FF 04F5 143F"            /* '!....Nj..? */
	$"E4E2 92E0 02F7 F6FA 87FF 81FD 10FA FBFD"            /* .. */
	$"F8EF 6700 0008 0A8A A2AB B4B1 A59B 9099"            /* g... */
	$"0694 8A80 7C5C 0093 81FF 0CC7 0007 2C4E"            /* .|\....,N */
	$"75B0 E0E2 B162 210E 8000 0A07 162B 3C4B"            /* ub!....+<K */
	$"4F57 688A BDEC 88FF 04DF 0058 F6E7 94E0"            /* OWh..X */
	$"04E1 EAF0 EBE8 82E9 00E8 81E2 10E1 E1E2"            /* ... */
	$"E4D3 0200 050D 1193 A2AC B3AF A49B 9099"            /* ..... */
	$"0692 867B 7857 0099 81FF 12F9 3D01 7DB0"            /* .{xW..=.} */
	$"A881 491D 294A 6C8A A5C3 D9E9 F6FB 88FF"            /* I.)Jl */
	$"01F5 E582 FF07 D257 0B92 85BB EFE3 93E0"            /* ..W. */
	$"80DE 88DF 10E0 E0DF E7CC 0B00 0305 1A99"            /* ވ...... */
	$"A2AC B3AE A39A 8F99 0797 9084 7978 5500"            /* .yxU. */
	$"9B82 FF08 E355 1015 213D 73B2 F48F FF11"            /* .U..!=s. */
	$"FEFF F88A D3FF FFF6 A30F 0E58 3900 1782"            /* ..X9.. */
	$"E2E5 A2E0 0EE5 E754 0000 060E 219B A2AC"            /* .T....! */
	$"B2AC A19A 8F99 0797 9082 7978 5500 9284"            /* .yxU. */
	$"FF02 E7E5 F290 FF0E E199 92F8 FFFF D949"            /* ..ᙒI */
	$"F1EF 2F00 3D48 0A81 0004 4CDF E9DF DF9E"            /* /.=H..Lߞ */
	$"E002 E5E2 5980 0009 0408 2D9D A2AD B1AA"            /* .Y...- */
	$"A09A 8F99 0797 8F80 7776 6000 8092 FF01"            /* .wv`.. */
	$"E9FE 83FF 02F1 4D52 81FF 069D 5432 2C7C"            /* .MR.T2,| */
	$"5707 8300 073A C2F7 E7E1 E0DE DE80 DF96"            /* W...:ހߖ */
	$"E002 E4E5 5881 0008 0300 39A0 A2AD AFA9"            /* .X....9 */
	$"9F90 9907 978D 7F77 7370 0B5B 91FF 03E1"            /* ..wsp.[. */
	$"3F6B F483 FF02 D677 FA81 FF04 9700 3342"            /* ?k.w..3B */
	$"0185 000E 1393 FFFF F7F2 ECE8 E9E4 E0E0"            /* .... */
	$"DEDF DF90 E002 E3E9 5F82 0008 1B03 3FA2"            /* ߐ._....? */
	$"A2AC AEA8 9E90 9908 968C 7E76 7276 3D21"            /* .~vrv=! */
	$"F48E FF06 D364 1600 0035 D883 FF01 DFE9"            /* .d...5؃. */
	$"82FF 04B2 2900 0C0C 8600 015B EE82 FF06"            /* .).....[. */
	$"FEF8 F6F0 E9E5 DF8E E002 E3EA 8083 0008"            /* ߎ.ꀃ.. */
	$"3505 45A3 A2AC AEA6 9D90 9908 958B 7D75"            /* 5.E.}u */
	$"7272 6F0E B78D FF01 B817 8200 0154 FE83"            /* rro.....T */
	$"FF02 E9D4 FA81 FF08 EC69 030E 1B2B 3417"            /* ..i...+4. */
	$"0482 0001 46DA 86FF 02FE EEDF 8CE0 02E3"            /* ...Fچ.ߌ. */
	$"EA70 8300 0918 3A00 50A5 A2AC ACA5 9D90"            /* p..:.P */
	$"9909 958A 7D75 7271 773C 3FFB 8BFF 01F2"            /* ƕ}urqw<?. */
	$"1D83 0001 11E8 84FF 01F0 F782 FF09 E806"            /* ...... */
	$"0235 505E 5A50 2609 8100 0116 9F87 FF01"            /* .5P^ZP&Ɓ.... */
	$"F7F6 8AE0 02E1 E978 8300 0A03 AFA8 0058"            /* .x...X */
	$"A6A2 ABAB A29B 8F99 0A98 948A 7C75 7271"            /* |urq */
	$"7272 1D78 8BFF 01D6 0683 0001 06D2 8BFF"            /* rr.x.....ҋ */
	$"0CDF 4425 0700 000F 1F2E 3529 1804 8000"            /* .D%......5)... */
	$"0169 EF87 FF00 E185 E005 DFE0 E0E2 F793"            /* .i.. */
	$"8400 0A21 A075 005E A6A2 ABA9 A29B 9099"            /* .!u.^ */
	$"0B94 887B 7572 7171 7758 0253 F689 FF00"            /* .{urqqwX.S. */
	$"B884 0001 07D4 8CFF 11FE F6DC B581 3704"            /* ...Ԍ.ܵ7. */
	$"0000 0113 1010 0400 002D C286 FF0E E8EC"            /* .........-. */
	$"E5E5 E2E0 E0E1 E3E5 E6E9 F59E 1384 000A"            /* .. */
	$"4072 4C00 62A5 A2AA A8A1 9B90 990D 9488"            /* @rL.b. */
	$"7B74 7271 7176 5408 0040 B9FB 83FF 00FA"            /* {trqqvT..@. */
	$"80FF 009A 8400 0110 E591 FF0D FBDA AB78"            /* .....ګx */
	$"4824 0700 030F 0000 17AC 85FF 0D57 9CCA"            /* H$........W */
	$"CAE6 F3ED EBEA EAEB F797 0284 000B 0B41"            /* ....A */
	$"4530 0068 A5A2 A8A7 A09A 9099 0393 887B"            /* E0.h.{ */
	$"7480 710D 7652 0004 2317 346F A3CB DDE0"            /* tq.vR..#.4o */
	$"9FE0 80FF 0091 8400 012B F896 FF0A F6D2"            /* ...+ */
	$"9A32 0310 0000 0175 EE83 FF0C 0000 110D"            /* 2.....u..... */
	$"3F86 DBEF F8F2 FAAE 0685 000B 0F20 1E17"            /* ?.... .. */
	$"006E A4A2 A8A6 A09A 9099 0393 877A 7480"            /* .n.zt */
	$"710D 7751 0000 3044 3106 0003 0A0C 68FD"            /* q.wQ..0D1....h */
	$"80FF 01DD 0A83 0000 5E9A FF03 EC2E 1226"            /* ...^...& */
	$"8000 0126 CE82 FF83 0005 1748 84C4 C521"            /* ..&΂...H! */
	$"8500 0C22 6261 6638 0074 A3A1 A7A5 9F9A"            /* .."baf8.t */
	$"9099 0393 877A 7480 710C 7751 0003 0A03"            /* .ztq.wQ... */
	$"1B20 1D16 0024 EE82 FF00 5A82 0001 23C9"            /* . ...$.Z..# */
	$"9BFF 03C5 1145 1D80 0005 1DB6 FFF5 C89C"            /* ..E....Ȝ */
	$"8600 0107 0985 000D 0294 DCD2 E070 007A"            /* ...ƅ...p.z */
	$"A1A1 A6A3 9E9A 9099 0393 877A 7480 7104"            /* .ztq. */
	$"7653 0005 1280 0004 0111 0F0E DE82 FF06"            /* vS.........ނ. */
	$"DA20 0002 45A3 EC8D FF13 FAD1 FEFF FFFD"            /*  ..E. */
	$"EACC A5B5 F6FF FFFD 9435 031D 6317 8000"            /* ̥5..c.. */
	$"0306 4D20 0491 000D 2DB0 ADAC B85B 007C"            /* ..M ...-[.| */
	$"A1A1 A4A1 9D9A 9099 0393 877A 7480 7104"            /* .ztq. */
	$"7654 0005 1482 0003 0C06 48D3 82FF 02D7"            /* vT.......Hӂ. */
	$"89BC 90FF 14F9 3B42 6159 3B18 0500 0032"            /* .;BaY;....2 */
	$"B3FF DE02 0114 042E 753E 9700 0C5E 9E94"            /* .....u>..^ */
	$"959F 4E00 7DA1 A0A3 A09C 9199 0393 877A"            /* N.}.z */
	$"7480 7104 7656 0004 1082 0004 0111 0014"            /* tq.vV......... */
	$"C897 FF01 FB2F 8600 0B0D C381 0009 6D44"            /* ȗ./...Á.mD */
	$"002B 9A3B 0194 000D 1581 8583 838C 4500"            /* .+;....E. */
	$"7EA0 9EA1 9F9C 9199 0393 887A 7480 7104"            /* ~.ztq. */
	$"765A 0101 0784 0002 1100 8C98 FF00 6787"            /* vZ........g */
	$"0000 0380 0006 0A9E A90C 3C52 0E94 000D"            /* ......<R... */
	$"4A7E 7677 777F 3E00 80A0 9E9F 9E9A 9199"            /* J~vww.>. */
	$"0394 887B 7480 7104 755E 0300 0483 0003"            /* .{tq.u^..... */
	$"0A2C 18DA 98FF 03EC A266 2285 0009 1616"            /* ,.ژ.f"... */
	$"0222 C0FF 5F00 0606 9300 020F 686C 806A"            /* ."_......hlj */
	$"0471 3600 819F 809D 009A 9199 0394 887B"            /* .q6...{ */
	$"7480 7104 7463 0402 1183 0002 4116 7C9C"            /* tq.tc.....A.| */
	$"FF02 ED8F 1582 0007 47E9 EBC3 E5FF FF8A"            /* ....G */
	$"9500 0301 3B69 6580 6408 6B34 0081 9E9B"            /* ...;ied.k4. */
	$"9C9B 9A91 9903 9488 7B74 8071 0574 6504"            /* .{tq.te. */
	$"011C 0982 0002 3002 A79E FF02 DA86 2D80"            /* ..Ƃ..0..چ- */
	$"0000 7483 FF00 9F95 0002 1F69 6781 6504"            /* ..t....ige. */
	$"6C34 0182 9D80 9A92 9903 9488 7B74 8071"            /* l4..{tq */
	$"0D74 6607 001A 1904 0000 0219 1C00 80A0"            /* .tf........... */
	$"FF04 F4B0 6754 CE83 FF00 B795 000B 1861"            /* .gT΃....a */
	$"6A65 6465 656B 3401 829D 9599 0394 887B"            /* jedeek4..{ */
	$"7480 710E 7468 0800 86BC B94B 0035 7D74"            /* tq.th..K.5}t */
	$"0F20 F3AA FF02 8300 1580 1601 170C 8F00"            /* . ........ */
	$"0A0D 4D74 6F6D 6D74 3800 819D 9499 0498"            /* .Mtommt8.. */
	$"9489 7B74 8071 0E73 6D0C 00A2 E7E5 B625"            /* {tq.sm..% */
	$"8198 9A44 00AC A9FF 09E3 123B 9F99 9A9B"            /* D..; */
	$"9D8E 108F 0009 023B 777D 777F 3E00 819E"            /* ...;w}w.>. */
	$"9499 0498 9489 7B74 8071 0F72 7212 0075"            /* .{tq.rr..u */
	$"A6A1 835C A2B2 B595 0434 F9A8 FF09 5C03"            /* \.4\. */
	$"91AE AEAD A8A8 AE43 9100 071E 668E 8F46"            /* C...fF */
	$"007F 9E94 9904 9894 897B 7480 710F 7273"            /* ...{tq.rs */
	$"1600 4D6D A245 46B4 77B7 E46B 008A A7FF"            /* ..MmEFwk. */
	$"0A89 005A C2BC A255 3434 3728 9200 0606"            /* .Z¼U447(... */
	$"75B3 5400 81A2 819D 019E A080 A18B A204"            /* uT... */
	$"A19D 9184 7D81 7A0F 7B1E 002E 66C2 4A47"            /* }z.{...fJG */
	$"B539 64D4 D035 0EE3 A6FF 0554 0060 7B70"            /* 9d5..T.`{p */
	$"1598 0012 057A 6700 6F8D 8888 8786 7B70"            /* ....zg.o{p */
	$"6963 5D55 514B 4B85 451B 484B 4B4A 4C47"            /* ic]UQKKE.HKKJLG */
	$"484A 4F52 555D 1E00 2770 BB48 4ABB 436E"            /* HJORU]..'pHJCn */
	$"8A79 A815 3DDE 8AFF 00F3 96FF 05F5 8300"            /* y.=ފ... */
	$"1512 049A 0004 051D 0006 0880 0701 0603"            /* .............. */
	$"9800 1101 0100 0816 240F 1E48 1F40 4D2F"            /* .......$..H.@M/ */
	$"834D 0921 C188 FF05 DD2E 4576 B4FA 80FF"            /* M!..Ev */
	$"02F9 CCE9 89FF 07CF A275 2908 0927 05CC"            /* ..Ϣu).'. */
	$"0006 0201 0915 030A 9486 FF01 DC2C 8100"            /* .......,. */
	$"0630 6CED DA3B 0443 85FF 04FE 9E4B 4B0E"            /* .0l;.C.KK. */
	$"8000 020A 0702 9400 0308 1A10 0080 01B3"            /* ........... */
	$"0021 0805 0048 92D3 F1F1 E5CB A977 1B00"            /* .!...H˩w.. */
	$"0B0B 0906 0000 2215 0004 0870 8B97 9DA0"            /* ....."....p */
	$"9894 833F 8000 0408 0F0A 0701 9600 061C"            /* ?......... */
	$"5E3A 0004 0302 B400 1705 1507 0004 1517"            /* ^:............. */
	$"0B01 0000 150E 0300 0103 0206 0806 0412"            /* ................ */
	$"1780 0002 0101 0380 0005 192C 2F41 2208"            /* .........,/A". */
	$"9800 061C 5E3B 0004 0302 B500 0B24 5344"            /* ...^;......$SD */
	$"271A 1626 1C15 395B 1083 0013 130D 0021"            /* '..&..9[......! */
	$"5236 4B52 3B3D 3522 0000 2F43 3643 2008"            /* R6KR;=5"../C6C . */
	$"8900 FFFF FBFF FFFF FFFF 06FF FFF8 7112"            /* ..q. */
	$"0B0F 820E 010F 0F81 0E03 0F0F 0E0D 8A0F"            /* ............. */
	$"0103 7088 FF02 DA2A 0A81 0F00 0E81 0F00"            /* ..p.*..... */
	$"0E88 0F02 0E04 9687 FF02 C021 0B80 0E80"            /* ......!.. */
	$"0F04 0E0E 0F0F 108B 0F02 0146 F88D FF03"            /* ..........F. */
	$"CC5D 5458 8059 005A 8259 8058 025A 2C0B"            /* ]TXY.ZYX.Z,. */
	$"890F 0102 9989 FF0E DC58 5053 5558 5C59"            /* ....XPSUX\Y */
	$"5656 585C 5C2A 0A85 0F02 0C1A E288 FF02"            /* VVX\\*..... */
	$"AE4C 5581 5606 5757 5657 5B37 0C89 0F02"            /* LUV.WWVW[7... */
	$"0830 DB8F FF07 CB73 7A7B 7B7C 7B7B 807C"            /* .0ۏ.sz{{|{{| */
	$"077B 7B7A 7A7D 6211 0D88 0F02 0552 FD89"            /* .{{zz}b.....R */
	$"FF0F 8E6F 7866 5041 342A 2A32 4153 3114"            /* .oxfPA4**2AS1. */
	$"0F0E 830F 020B 1DF2 88FF 03A9 6E76 7681"            /* .......nvv */
	$"7705 7878 797A 300B 880F 020E 0ABD 90FF"            /* w.xxyz0....½ */
	$"07FE A870 7778 7777 7980 7880 7704 7677"            /* .pwxwwyxw.vw */
	$"7830 0A88 0F02 0C18 E789 FF03 A15A 3608"            /* x0.....Z6. */
	$"8500 0504 1A1F 1711 0E81 0F02 092D F487"            /* ..........- */
	$"FF06 FC8C 6C71 7272 7380 7404 7376 6D17"            /* .lqrrst.svm. */
	$"0D88 0F02 0637 FB91 FF02 F891 7484 7A00"            /* ....7.tz. */
	$"7980 7804 777B 5F11 0D87 0F02 0E07 9B88"            /* yx.w{_...... */
	$"FF02 AD33 0489 0009 040C 1919 0E0E 0F0F"            /* .3.......... */
	$"0452 88FF 04E4 7670 7272 8073 0574 7575"            /* .R.vprrs.tuu */
	$"7A55 0D88 0F02 0E01 A493 FF02 E07E 7A80"            /* zU......~z */
	$"7C05 7D7C 7C7B 7A79 8078 027B 3D0B 880F"            /* |.}||{zyx.{=.. */
	$"0209 20F2 85FF 01D6 618F 0006 0F1B 150C"            /* . .a...... */
	$"0B00 5088 FF04 B86A 7172 7280 7305 7475"            /* ..P.jqrrs.tu */
	$"7579 350A 880F 0206 46F9 94FF 06B9 767E"            /* uy5...F.v~ */
	$"7F7D 7E7D 807C 077B 7A79 797A 7425 0B87"            /* .}~}|.{zyyzt%. */
	$"0F02 0E06 A384 FF01 BF18 8000 0301 0202"            /* ........... */
	$"018A 0005 0415 1D1E 135C 88FF 0198 6B81"            /* ........\.k */
	$"7207 7374 7575 7770 1C0D 870F 020E 05B0"            /* r.stuuwp...... */
	$"95FF 11F4 927A 8080 7F7F 7E7E 7D7C 7B7A"            /* .z..~~}|{z */
	$"7978 7D51 0B88 0F01 0543 83FF 01C7 1980"            /* yx}Q....C.. */
	$"0005 0205 0807 0401 8A00 0501 71F0 E5EA"            /* ...........q */
	$"FE86 FF0E F884 6E72 7273 7273 7475 757A"            /* .nrrsrstuuz */
	$"5D0F 0E87 0F02 0532 EC96 FF11 E88F 7E82"            /* ].....2.~ */
	$"8281 807F 7E7E 7C7A 7A79 7A78 290B 870F"            /* .~~|zzyzx).. */
	$"080C 18DB F9F8 F8FC C517 8000 0603 0B11"            /* ......... */
	$"130C 0401 8B00 0411 B5E6 D9F0 86FF 07E5"            /* ........ */
	$"7570 7272 7373 7480 7502 7937 0A87 0F02"            /* uprrsstu.y7.. */
	$"0D07 A798 FF00 DA81 830C 8181 807F 7D7C"            /* ...ځ..}| */
	$"7C7B 7A7D 5D0F 0E86 0F07 0D10 88B0 ABB2"            /* |{z}]...... */
	$"7D0C 8000 0703 0D19 1F1A 0E03 018C 0003"            /* }............. */
	$"44DE D6E7 86FF 02CA 6E72 8073 0774 7475"            /* D.nrs.ttu */
	$"7579 6513 0D87 0F01 026A 9AFF 10AC 7E85"            /* uye.....j.~ */
	$"8483 8281 7F7E 7E7D 7B7A 7B7B 2C09 860F"            /* .~~}{z{{,Ɔ. */
	$"060C 19A4 B1B4 A31D 8000 0702 0A1A 2727"            /* ........'' */
	$"190A 028D 0003 04A5 DDE1 86FF 01B1 6C84"            /* ......l */
	$"7403 757C 4C0A 870F 020C 10CD 9AFF 11EE"            /* t.u|L....͚. */
	$"9182 8584 8382 817F 7F7E 7D7C 7B7E 5E10"            /* ..~}|{~^. */
	$"0E85 0F05 0936 C0C7 CC47 8000 0702 0A19"            /* ...6G.... */
	$"2B30 2512 058F 0003 3BC1 C7FC 84FF 06FE"            /* +0%....;. */
	$"976F 7475 7474 8075 0376 7830 0A87 0F01"            /* otuttu.vx0.. */
	$"0167 9CFF 00D6 8085 0C84 8482 817F 7E7E"            /* .g.ր..~~ */
	$"7C7C 7B7F 480C 850F 0402 6DE9 E87F 8000"            /* ||{.H....m.. */
	$"0801 091A 2D39 2D1A 0801 8F00 0307 AACE"            /* ...-9-...... */
	$"FC84 FF02 F583 7383 7504 7679 6B16 0D86"            /* .su.vyk.. */
	$"0F02 0D0E C29D FF10 BA81 8685 8482 8281"            /* ..... */
	$"807E 7E7D 7C7E 741B 0C84 0F04 007C F9DC"            /* ~~}|~t.....| */
	$"2380 0007 0414 2B3C 3B24 0F03 9100 0276"            /* #....+<;$....v */
	$"B9FA 84FF 02E4 7975 8476 027B 550C 870F"            /* .yuv.{U.. */
	$"0102 5C8A FF02 FEC1 BB8E FF10 FAA2 8186"            /* ..\.. */
	$"8584 8381 817F 7E7E 7D7C 814C 0A84 0F0E"            /* .~~}|L.. */
	$"045B B945 0000 0102 0D26 3E44 3316 0692"            /* .[E.....&>D3.. */
	$"0002 4FAF FA84 FF02 CA72 7684 7702 7B38"            /* ..O.rvw.{8 */
	$"0986 0F02 0C0B BD8A FF02 BF0D 0C8F FF10"            /* Ɔ........ */
	$"E98D 8485 8583 8281 807F 7F7E 7D7E 7925"            /* 鍄..~}~y% */
	$"0B83 0F02 0277 9380 0008 0208 1E3C 4A40"            /* ....w.....<J@ */
	$"240A 0192 0002 35AE F784 FF02 AF70 7883"            /* $...5.px */
	$"7703 7970 1C0C 860F 0206 79FE 8AFF 0552"            /* w.yp.....y.R */
	$"020D 877F C28D FF09 C680 8685 8483 8281"            /* ...ƀ */
	$"807F 807E 0283 580C 820F 030E 0B8F 4480"            /* .~.X.....D */
	$"0007 0613 314A 4A33 1404 9300 021C 6FEF"            /* ....1JJ3.....o */
	$"83FF 02FE 9774 8178 8077 037C 5A0E 0E85"            /* .txw.|Z.. */
	$"0F02 0B1A E78A FF07 BE0C 0D0F 0000 1AAF"            /* ........... */
	$"8CFF 10F6 9D81 8684 8382 8281 8080 7F7E"            /* ..~ */
	$"807A 240A 810F 0E0E 1562 0A00 0002 0E24"            /* z$....b....$ */
	$"4250 4024 0A01 9300 0212 B0FA 83FF 0CF4"            /* BP@$..... */
	$"8677 7A79 7879 7978 787E 4109 860F 0102"            /* wzyxyyxx~AƆ... */
	$"818B FF01 7100 800F 0310 0808 A08C FF06"            /* .q....... */
	$"ED97 8185 8483 8280 8106 807F 7F83 6615"            /* 헁...f. */
	$"0D80 0F02 0E17 1F80 0007 071D 3A52 4C2F"            /* ..........:RL/ */
	$"1504 9400 020E A9F4 83FF 03DE 7B79 7B80"            /* ......{y{ */
	$"7A05 797A 7B77 230C 850F 020A 1EDE 8AFF"            /* z.yz{w#....ފ */
	$"02DB 4107 820F 020A 0AA0 8CFF 04E0 8683"            /* .A... . */
	$"8483 8082 0781 8080 7F7F 8649 0A81 0F0B"            /* ...I.. */
	$"2007 0000 0312 314D 563E 1E0A 9500 0207"            /*  .....1MV>.... */
	$"6EF3 83FF 01C3 7584 7B02 8053 0D86 0F01"            /* n.u{.S... */
	$"0479 8AFF 03EE 893B 0883 0F02 0815 E08C"            /* .y.;..... */
	$"FF13 B481 8685 8584 8382 8180 807F 8274"            /* ..t */
	$"190C 0F0E 1516 8000 0707 1E41 5751 3012"            /* ..........AWQ0. */
	$"0495 0002 0562 F882 FF0C FEA1 777D 7D7C"            /* ....b.w}}| */
	$"7C7B 7B7C 7D30 0985 0F02 0B13 DB8A FF03"            /* |{{|}0ƅ....ۊ. */
	$"A971 4108 840F 020A 2DA3 8BFF 09FE 967C"            /* qA...-| */
	$"7C77 7A7E 8489 8480 8011 8548 090F 0E1A"            /* |wz~.H... */
	$"0800 0004 1131 525A 4420 0801 9500 0206"            /* .....1RZD ..... */
	$"63F7 82FF 02EC 847B 817D 057C 7C7F 7117"            /* c.{}.||.q. */
	$"0D85 0F01 0070 8AFF 04C9 747A 4108 850F"            /* ....p.tzA.. */
	$"0205 09A1 88FF 1FF5 B975 330F 0807 0810"            /* ..ơ.u3..... */
	$"2A4E 7687 8180 8279 200B 1115 0100 010A"            /* *Nvy ...... */
	$"2045 5B53 3311 0396 0002 0A86 FA82 FF02"            /*  E[S3..... */
	$"D37A 7D80 7E80 7D02 8356 0B85 0F02 0642"            /* z}~}.V....B */
	$"F689 FF05 D176 757D 4108 860F 0209 0ECD"            /* .vu}A.... */
	$"86FF 01BD 3D87 0013 105B 8782 8087 4D07"            /* .=...[M. */
	$"130D 0000 0413 2F53 5C48 2409 9700 0211"            /* ....../S\H$Ɨ... */
	$"C1FE 82FF 02C0 787F 817E 047D 7D82 3A09"            /* .x.~.}}: */
	$"850F 0100 9989 FF06 F58B 7478 7E42 0887"            /* ....tx~B. */
	$"0F02 053B D783 FF05 DA5A 0400 0302 8600"            /* ...;׃.Z..... */
	$"1202 4887 8383 7C2A 1204 0000 0921 415C"            /* ..H|*....!A\ */
	$"5539 1703 9700 010E AA83 FF0B AA79 8080"            /* U9......y */
	$"7E7F 7E7E 8078 1E0C 840F 0206 31EA 89FF"            /* ~.~~x.....1 */
	$"06AC 757B 797E 4308 870F 0E10 032D D3DD"            /* .u{y~C.....- */
	$"DBE1 D979 1300 0C10 0C04 8800 0F4C 8782"            /* y........L */
	$"8671 1700 0003 1434 525E 4727 0C98 0001"            /* q.....4R^G'... */
	$"1C93 82FF 02FA 917C 8080 807F 0384 5F0E"            /* ..|.._. */
	$"0E83 0F02 0E0A B189 FF07 CA78 7B7B 7A80"            /* ....±.x{{z */
	$"4308 880F 0D0C 16BC CFCB D85E 0004 161E"            /* C.....^.... */
	$"190F 0488 000F 0162 8783 8217 0000 0720"            /* ......b....  */
	$"455D 5937 1805 9800 013E E782 FF02 E783"            /* E]Y7....>. */
	$"7E80 8080 7F02 8440 0984 0F01 0541 89FF"            /* ~..@Ƅ...A */
	$"08DB 817B 7E7B 7A81 4308 880F 0D0D 0F9F"            /* .ہ{~{zC..... */
	$"E0C3 8403 0717 2628 1B0D 0389 000E 3688"            /* Ä...&(.....6 */
	$"8869 0300 020E 2E53 604F 290E 0398 0001"            /* i.....S`O).... */
	$"30C3 82FF 01D3 7D84 8002 7D26 0B84 0F01"            /* 0Â.}.}&... */
	$"0089 88FF 09F1 8F79 7E7D 7D7B 8144 0888"            /* .y~}}{D. */
	$"0F0C 0D0E 94DA 7B04 0318 2C36 2B15 078A"            /* ....{...,6+.. */
	$"000D 127D 8932 0000 0619 405E 5E3F 1906"            /* ...}2....@^^?.. */
	$"9900 0163 EE82 FF03 BC7A 8385 8084 0482"            /* ..c.z. */
	$"8569 110E 830F 0207 33E8 87FF 0AFC A478"            /* i.....3x */
	$"7F7E 7D7E 7C82 4408 880F 0C0E 0580 A907"            /* .~}~|D...... */
	$"0011 2B3D 3B23 0C03 8A00 0D03 7369 0100"            /* ..+=;#.....si.. */
	$"020E 2850 6254 2F0F 0299 0001 78EC 82FF"            /* ..(PbT/....x */
	$"02AA 7F79 816D 037E 8A43 0883 0F02 0C13"            /* ..ym.~C..... */
	$"CA88 FF0A C077 7E7E 7F7E 7D7D 8345 0889"            /* ʈw~~.~}}E. */
	$"0F0A 0466 5500 071E 3B45 3619 058C 000B"            /* ..fU...;E6.... */
	$"6648 0000 0516 3659 6049 2207 9900 0204"            /* fH....6Y`I".... */
	$"74DE 81FF 13D5 5D2A 1205 0404 061C 3D21"            /* tށ.]*......=! */
	$"1311 0E0F 0E0D 0E00 5988 FF02 EB83 7B82"            /* ........Y.{ */
	$"7E03 7D83 4507 890F 0A0C 2B0A 0211 2F46"            /* ~.}E...+../F */
	$"432A 0D01 8B00 0C01 5B1F 0000 0A24 455F"            /* C*.....[...$E_ */
	$"593A 1504 9900 0714 97F2 FFFF BF47 0A86"            /* Y:.....G */
	$"0009 0108 1118 130F 0E0D 0BB1 87FF 02EC"            /* ........... */
	$"9279 837E 037D 8446 0789 0F09 1210 000B"            /* y~.}F...... */
	$"2140 4A39 1B06 8C00 0B09 4804 0002 1434"            /* !@J9....H....4 */
	$"5460 4B29 0C9A 0005 38B2 FFF5 7B05 8B00"            /* T`K)...8{.. */
	$"0505 1252 9981 AE87 FF04 F99B 757E 7D81"            /* ...R.u~} */
	$"7E04 7D7E 843F 0888 0F0A 0E16 0803 1530"            /* ~.}~?.......0 */
	$"4A45 2B10 018C 000B 0A1E 0000 061E 435D"            /* JE+.........C] */
	$"5C3C 1C06 9A00 0356 BDD3 428F 0004 22BC"            /* \<....VB.." */
	$"BDEB FC86 FF02 BC74 7C82 7D05 7E7D 8363"            /* .t|}.~}c */
	$"130D 820F 010D 0B82 0F08 1803 0920 3D4C"            /* .......... =L */
	$"3B1F 098D 000B 0404 0000 0A29 4F61 542F"            /* ;.ƍ......)OaT/ */
	$"1302 9900 090A 8FD6 6400 0004 0604 018B"            /* ...d...... */
	$"0003 32A8 E6F6 85FF 04E7 827A 7D7C 827D"            /* ..2.z}|} */
	$"0382 7220 0B82 0F10 0D22 260A 0F0F 0E17"            /* .r ...."&.... */
	$"1901 1330 4749 2D12 0390 0007 0313 3859"            /* ...0GI-......8Y */
	$"6046 200A 9A00 092D C3A4 0401 0A13 120B"            /* `F .-ä..... */
	$"048C 0002 35CC F384 FF03 F094 777C 807D"            /* ...5.w|} */
	$"067C 7C7D 8076 2709 830F 0F09 3787 3106"            /* .||}v'ƃ..71. */
	$"0D0E 1B06 051E 3D4C 401F 0991 0007 051D"            /* ......=L@.Ƒ.... */
	$"455F 5B38 1404 9A00 0956 D147 000B 1A25"            /* E_[8...VG...% */
	$"1F11 048D 0001 83FB 83FF 03FC 9A76 7D83"            /* ......v} */
	$"7C03 8073 260A 840F 0F09 3394 8640 100D"            /* |.s&..3@.. */
	$"1901 0B29 464C 3514 0491 0007 0A27 4F61"            /* ...)FL5....'Oa */
	$"522B 0D02 9A00 0974 B812 0217 2A33 2310"            /* R+...t...*3#. */
	$"048D 0000 4D84 FF03 C378 7C7D 827C 037F"            /* ...M.x|}|.. */
	$"7C30 0885 0F0F 0A33 8D91 9368 2510 0114"            /* |0...3h%... */
	$"364C 4627 0B01 9000 0704 1235 585E 451E"            /* 6LF'......5X^E. */
	$"079A 000A 10B2 7A00 0C26 3B3A 200A 018D"            /* ...z..&;: . */
	$"0001 18EE 82FF 05DF 807C 7E7D 7D80 7C03"            /* ....߀|~}}|. */
	$"7E7E 3809 860F 0E0A 328C 8D8D 9474 0705"            /* ~~8Ɔ..2t.. */
	$"1F40 4C3B 1A05 9100 0708 1C42 5D56 3613"            /* .@L;......B]V6. */
	$"029A 0009 42AB 4200 1634 4437 1704 8E00"            /* ..BB..4D7... */
	$"0102 BC81 FF0C F391 797E 7E7D 7D7C 7C7D"            /* ...y~~}}||} */
	$"7E3F 0A87 0F0E 0A32 8B8C 8A91 6501 0A28"            /* ~?..2e.( */
	$"4749 3211 0291 0006 0D26 4C5E 4C2A 0C9B"            /* GI2.....&L^L*. */
	$"0009 63A2 1700 1D3B 4732 1101 8F00 008A"            /* .c...;G2.... */
	$"80FF 02FD AC78 807E 077D 7D7C 7D80 430B"            /* .x~.}}|}C. */
	$"0E87 0F0D 0A31 8A8A 8991 4100 1333 4B42"            /* ...1A..3KB */
	$"270B 9100 0702 1432 545A 3F1F 079A 0009"            /* '.....2TZ?... */
	$"016B C127 0021 4048 2E0D 9000 0058 80FF"            /* .k'.!@H....X */
	$"05BD 797F 7F7E 7E80 7D03 814A 0C0E 880F"            /* .y..~~}.J... */
	$"0D0A 3188 898A 881E 031D 3D4B 381C 0591"            /* .1...=K8.. */
	$"0007 061E 3F59 5330 1303 9A00 0912 A3A9"            /* ....?YS0.... */
	$"1D01 2443 4A2E 0D90 000F 26F4 FFD7 7E7E"            /* ..$CJ....&~~ */
	$"807F 7F7E 7D7E 8253 0D0D 890F 0D0A 3188"            /* ..~}~S....1 */
	$"888A 7A06 0B25 4348 2F14 0291 0006 0A28"            /* z..%CH/....( */
	$"495B 4923 0C9B 0009 39BC 9B1A 0226 474C"            /* I[I#..9..&GL */
	$"300D 9000 040A DDF8 8E7C 8080 067F 7E7E"            /* 0...|..~~ */
	$"8460 100D 8A0F 0C0A 3187 878E 5F01 122D"            /* `....1_..- */
	$"4844 270E 9100 0701 1032 515A 3F1B 079B"            /* HD'.....2QZ?.. */
	$"0009 5DC4 9119 0327 4950 340F 9000 0301"            /* .]đ..'IP4.... */
	$"B9C0 7A80 8006 7F7F 7E84 5F17 0C8B 0F0C"            /* z...~_.... */
	$"0A30 8587 8F41 001A 364A 3D1D 0991 0007"            /* 0A..6J=.Ƒ.. */
	$"0418 3D58 5532 1103 9B00 0A75 A67E 1604"            /* ..=XU2...u~.. */
	$"284D 5639 1201 9000 0B5F 8A80 8180 807F"            /* (MV9...._. */
	$"7F83 6615 0B86 0F81 0D0E 0F0F 0A2F 8587"            /* .f......./ */
	$"8729 0020 3D4A 3616 0591 0007 0621 475A"            /* ). =J6.....!GZ */
	$"4D26 0A01 9A00 0B08 8F86 6813 0529 4F5A"            /* M&....h..)OZ */
	$"3D14 0290 0003 3987 8181 8080 0384 741B"            /* =....9.t. */
	$"0A86 0F01 080D 800E 0E0F 0F09 2B81 8682"            /* ........+ */
	$"1505 2641 492F 1103 9100 060B 294E 5A45"            /* ..&AI/.....)NZE */
	$"1D06 9B00 0B3A D890 520F 052A 515D 4116"            /* ....:ؐR..*Q]A. */
	$"0290 0009 1F7F 8281 8080 8479 2E0A 850F"            /* ....y.. */
	$"030E 0045 B980 BC80 000B 3D8E 816B 030C"            /* ...E..=k.. */
	$"2C45 4528 0B01 9000 0702 1133 5457 3A15"            /* ,EE(......3TW:. */
	$"029B 000B 76C3 5C35 0B06 2A54 6247 1A04"            /* ...v\5..*TbG.. */
	$"9000 0805 7484 8081 8475 2609 850F 0307"            /* ...tu&ƅ... */
	$"0053 EA81 FF0D 8784 9EDD EFB5 4300 1131"            /* .S.C..1 */
	$"4640 2107 9100 0605 183E 5851 2F0D 9B00"            /* F@!.....>XQ/.. */
	$"0C03 7795 5F3E 0506 2B56 664B 1D05 9000"            /* ..w_>..+VfK... */
	$"0701 6286 8084 7B29 0985 0F03 0630 95FD"            /* ..b{)ƅ...0 */
	$"88FF 0750 0014 3447 3C1C 0591 0006 081F"            /* .P..4G<...... */
	$"4658 4B27 099B 000C 0B1C 22C3 A203 062B"            /* FXK'ƛ...."â..+ */
	$"5868 4D1D 0591 0005 5C87 8386 3E08 850F"            /* XhM....\>.. */
	$"0202 22D9 89FF 08FE 4200 1636 4637 1704"            /* .."ى.B..6F7.. */
	$"9000 0701 0C27 4D56 411E 059B 000C 1210"            /* ....'MVA...... */
	$"1278 6401 072D 5867 4C1D 0591 0005 4D8A"            /* .xd..-XgL....M */
	$"8145 0D0E 830F 030D 003D CD8A FF08 F728"            /* E......=͊.( */
	$"0019 3744 3213 0290 0007 0313 3253 5237"            /* ..7D2......2SR7 */
	$"1502 9A00 0D01 1610 1456 3F00 082D 5764"            /* ........V?..-Wd */
	$"461A 0491 0004 438B 3D08 0E83 0F03 0A0D"            /* F....C=..... */
	$"76EB 8BFF 07F2 1800 1A37 412D 1091 0006"            /* v....7A-... */
	$"051A 3A56 4C2E 0F9B 000D 0419 092E A963"            /* ..:VL.......c */
	$"0009 2D54 5C3E 1402 9100 0344 5309 0E83"            /* .-T\>....DS. */
	$"0F02 050B AB8D FF07 ED12 001B 363E 2A0D"            /* ........6>*. */
	$"9100 0608 2142 5745 260B 9B00 0C0A 2009"            /* ...!BWE&...  */
	$"2A77 3C00 0A2C 4F53 340F 9200 0221 190D"            /* *w<.,OS4...!.. */
	$"820F 030E 0528 B08E FF07 E80F 001B 343A"            /* ....(....4: */
	$"260B 9100 060D 2949 563D 1D07 9B00 0C28"            /* &....)IV=....( */
	$"2803 4DC9 3300 0C2B 4643 2508 9200 010B"            /* (.M3..+FC%.... */
	$"1082 0F03 0E03 6EF4 8FFF 07E7 0F00 1932"            /* .....n....2 */
	$"3622 0A90 0007 0111 314F 5334 1504 9B00"            /* 6"....1OS4... */
	$"0C48 3600 9BDF 0E00 0D27 3A31 1804 9200"            /* .H6....':1... */
	$"010B 1181 0F02 0C00 6389 FF02 E055 5082"            /* .......c.UP */
	$"FF07 F212 0018 2F32 1F08 9000 0702 1639"            /* ..../2......9 */
	$"534F 2C10 029B 000C 5B3B 67BB 6E00 000E"            /* SO,....[;gn... */
	$"232D 230E 0192 0001 0A11 800F 0305 0E7A"            /* #-#.........z */
	$"FB89 FF02 7400 0482 FF07 D211 0015 292D"            /* .t......)- */
	$"1B08 9000 0605 1D41 5549 240A 9C00 0B13"            /* ......AUI$... */
	$"1940 3000 0003 0E1B 1D14 0693 0006 0A11"            /* .@0........... */
	$"0F0F 003E C88A FF10 A206 0D0F E2E0 EDF8"            /* ...>Ȋ.... */
	$"D992 2500 1122 2617 0690 0006 0925 4955"            /* ْ%.."&....%IU */
	$"411C 07A2 0005 030B 1110 0802 9300 050A"            /* A............ */
	$"100D 0452 EB89 FF12 F6C2 4803 0F0F 190F"            /* ...R.H..... */
	$"61BC ADB2 3700 0D1B 1F13 0690 0006 0C2C"            /* a7........., */
	$"4D55 3B16 04A2 0004 0207 0A07 0394 0004"            /* MU;.......... */
	$"0D10 044C F989 FF13 E098 7B42 070F 0F0B"            /* ...L.{B.... */
	$"0B08 4EAB AC4D 0008 1215 0E04 8F00 0701"            /* ..NM......... */
	$"1033 5252 3311 03A2 0004 0103 0402 0194"            /* .3RR3......... */
	$"0003 233E 83F9 88FF 06E2 A47D 7883 4507"            /* ..#>.}xE. */
	$"810F 0A0D 0D5F BFA0 0A01 080A 0702 8F00"            /* ..._..... */
	$"0603 163B 554E 2B0B BF00 0243 A5F9 87FF"            /* ...;UN+...C */
	$"08E1 AE81 787C 7D84 4607 820F 090C 0A79"            /* .ᮁx|}F...y */
	$"DE35 0002 0302 018F 0006 051C 4156 4923"            /* 5.........AVI# */
	$"08BF 0001 32D2 86FF 0AF7 B180 797D 7F7E"            /* ...2҆y}.~ */
	$"7E84 4607 830F 030B 1385 6794 0006 0821"            /* ~F.....g...! */
	$"4656 441E 05BF 0001 65F3 84FF 0CF9 D099"            /* FVD....e.Й */
	$"7A7F 8080 7F7F 7E88 4807 840F 030B 125A"            /* z...~H.....Z */
	$"1292 0007 010B 284C 553D 1803 BF00 00B2"            /* .....(LU=.... */
	$"83FF 04FE D498 7C7C 8081 0680 8082 857E"            /* .Ԙ||.~ */
	$"3909 850F 030C 101F 0191 0007 020F 2F50"            /* 9ƅ........../P */
	$"5135 1202 BE00 010B DB82 FF04 D4A1 7E7D"            /* Q5.....ۂ.ԡ~} */
	$"8081 8105 8385 754D 220E 870F 020D 170A"            /* .uM"..... */
	$"9100 0604 1334 524D 2F0E BF00 013A F680"            /* ....4RM/...: */
	$"FF0F F1B0 7D7C 8182 8182 8387 8676 4C1C"            /* .}|vL. */
	$"090B 890F 0210 1706 9000 0606 183A 5348"            /* ..........:SH */
	$"280A BF00 1281 FFFF EFC1 8F7D 8182 8382"            /* (¿..} */
	$"8389 8264 3F1A 0A0C 8C0F 0212 1A09 8F00"            /* d?......Ə. */
	$"0608 1D41 5342 2207 BE00 1104 CDFB C38D"            /* ...ASB"....Í */
	$"7C80 8382 8386 887B 5527 0D09 0C8F 0F02"            /* |{U'.... */
	$"1016 098E 0006 0A22 4552 3D1D 05BE 000F"            /* ..Ǝ.."ER=.... */
	$"20D1 A57B 7F83 8384 8788 7B52 1E0A 0A0E"            /*  ѥ{.{R.. */
	$"8A0F 0B0E 090A 0C0D 0E0F 0F10 1815 088C"            /* ............ */
	$"0006 0E27 4951 3718 03BE 000C 3F8A 7D82"            /* ...'IQ7....?} */
	$"8385 8983 6A46 1E0B 0C8C 0F0F 0C23 4730"            /* jF......#G0 */
	$"1D13 0C0A 0C0E 0E13 1915 0B04 8800 0702"            /* .............. */
	$"122E 4D4E 2F13 02BD 000B 0468 8682 8588"            /* ..MN/.....h */
	$"7D5A 2D10 090C 8E0F 0D0A 2F81 7E77 6B56"            /* }Z-..../~wkV */
	$"381B 0F09 080A 1080 1701 0701 8500 0602"            /* 8........... */
	$"1634 4F4A 290F BE00 0921 8687 897A 441D"            /* .4OJ)..!zD. */
	$"0B0A 0E88 0F1D 0D0B 090C 0D0D 0F0F 0A2D"            /* ...........- */
	$"7C7E 7F82 8583 7764 4D39 2615 0C08 0F14"            /* |~.wdM9&..... */
	$"1110 0802 8200 0604 1938 5046 240C BE00"            /* ........8PF$.. */
	$"075A 8B6F 4C21 090C 0E86 0F0E 0E0C 0700"            /* .ZoL!........ */
	$"0C1D 2914 0D0E 0F0F 0A2D 7A80 7D11 7F81"            /* ..).....-z}.. */
	$"8386 8986 8074 5E4B 351E 1311 0E12 0D02"            /* t^K5....... */
	$"8000 0605 1E3D 5142 1F08 BD00 0521 6133"            /* ....=QB....!a3 */
	$"1209 0B86 0F30 0C08 0005 123B 87B8 E3F4"            /* ...0.....; */
	$"D6B9 BC0F 0F0A 2D7A 7C7C 7D7F 7F80 8182"            /* ֹ..-z||}.. */
	$"8383 8589 8A86 7E71 5E45 2F21 1603 0000"            /* ~q^E/!.... */
	$"0824 4250 3C19 05BC 0004 0D22 0F09 0D83"            /* .$BP<.....".. */
	$"0F0A 0E0C 0B03 0011 3875 9ED5 F984 FF23"            /* .......8u# */
	$"0F0F 0A2C 797B 7C7D 7F7F 8081 8281 8282"            /* ..,y{|}.. */
	$"8383 8485 8789 8984 7A63 3901 0009 2746"            /* zc9..'F */
	$"4F37 1504 BC00 021C 0E0E 810F 0A0D 0C09"            /* O7.......... */
	$"0205 111E 5D87 D2F8 88FF 100F 0F0A 2C78"            /* ....]...,x */
	$"7A7B 7C7E 7F7F 8081 8182 8182 8083 0F84"            /* z{|~... */
	$"8383 8485 8A79 0700 0C2C 494E 3211 03BA"            /* y...,IN2.. */
	$"000F 0B18 0A17 0F0E 0B06 020C 132A 5E9F"            /* ............*^ */
	$"CAF1 8CFF 100F 0F0A 2C77 7979 7B7C 7D7E"            /* ...,wyy{|}~ */
	$"8081 8182 8181 8083 0084 8183 0A87 6501"            /* .e. */
	$"000E 304A 4B2C 0D01 B900 0C1C BCD2 1A07"            /* ..0JK,....... */
	$"1C04 1B3F 70B5 D5F4 90FF 130F 0F08 2478"            /* ...?p....$x */
	$"7572 7475 787A 7D7E 7F80 8181 8283 8282"            /* urtuxz}~. */
	$"830A 895B 0000 1133 4C48 270B 0198 0000"            /* [...3LH'.... */
	$"019D 0008 2BE3 FFB2 0621 85EA FB94 FF23"            /* ...+.!# */
	$"0000 0784 DECF BFB3 A89B 9088 827F 7B7A"            /* ...Ͽ.{z */
	$"7A7B 7E80 8082 8283 838B 4700 0114 374D"            /* z{~G...7M */
	$"4423 0801 9600 0303 0000 089A 0008 0827"            /* D#...........' */
	$"013D FCFF AF04 9C94 FF04 F2F0 8781 B183"            /* .=.. */
	$"FF19 FEFA F2E7 D9CD C0B4 AA9C 9189 8581"            /* . */
	$"7D7D 8639 0003 183B 4C40 1E05 9500 0601"            /* }}9...;L@..... */
	$"050F 5329 0703 9700 0B42 939A D36D 00D5"            /* ..S)....Bm. */
	$"FFFF 8312 E792 FF02 A11A 1C8F FF10 FDF9"            /* ..... */
	$"F1E5 D7CA BDA3 2E00 041B 3D4C 3C1A 0495"            /* ʽ....=L<.. */
	$"0006 0706 B0FF C306 0795 0002 26AD FD80"            /* ........& */
	$"FF07 D304 8DFF FFFA 228F 91FF 03BB 0C07"            /* .."... */
	$"0B96 FF09 F42C 0005 1D3F 4B38 1602 9400"            /* .,...?K8... */
	$"0702 0152 FFFF ED14 0392 0003 0325 57D5"            /* ...R.....%W */
	$"82FF 08FA 1B49 FEFF FF7F 38FE 83FF 10FD"            /* ..I.8. */
	$"FBF9 F2E8 E2DA D2C8 C1BA B2B0 5001 0F0F"            /* P... */
	$"96FF 09EC 1200 0720 4149 3412 0193 0007"            /* ... AI4.... */
	$"010D 06C0 FFFF F727 9100 051A 4168 8484"            /* ...'...Ah */
	$"C682 FF16 FB1F 2BFB FFFF D119 C2D6 C9C0"            /* Ƃ..+. */
	$"BAB4 AAA0 9A95 918C 8A89 8681 8404 8D49"            /* .I */
	$"070F 0F96 FF08 D406 0008 2442 472F 0F94"            /* .......$BG/. */
	$"0007 0204 24F7 FFFF FC39 8E00 101A 3D62"            /* ....$9...=b */
	$"7F8A 8783 7E98 DFD8 D4CE A24D 0064 80FF"            /* .~΢M.d */
	$"0CF6 295E 8C83 8284 8485 8788 898A 808C"            /* .)^ */
	$"018D 8D80 8E04 944D 060F 0F96 FF08 C100"            /* ..M..... */
	$"000A 2643 442A 0C94 0002 0400 4A81 FF02"            /* .&CD*.....J. */
	$"4F01 0189 0006 0923 5583 8B89 8580 8409"            /* O....#U */
	$"8588 897C 6634 0000 43E0 80FF 19FB 3239"            /* |f4..C.29 */
	$"706C 6E71 7374 7476 787A 7B7D 7E7F 7F81"            /* plnqsttvxz{}~.. */
	$"8281 8A48 070F 0F95 FF09 FD9A 0000 0B28"            /* H......( */
	$"4342 260A 9400 0209 006D 81FF 0266 0105"            /* CB&...m.f.. */
	$"8500 160B 1E3E 6280 8A8F 8785 8181 807D"            /* ....>b} */
	$"7C71 5328 0700 1256 B1FB 81FF 06F8 2805"            /* |qS(...V.(. */
	$"1311 1112 8013 8014 0415 1717 1819 801A"            /* ............. */
	$"041E 160E 0F0F 94FF 0AA8 3B0E 0100 0C2B"            /* ......¨;....+ */
	$"433F 2308 9400 0208 0088 81FF 028F 0009"            /* C?#....... */
	$"8000 1801 142E 4762 7278 705D 4C42 3425"            /* .....Gbrxp]LB4% */
	$"1F12 120E 0608 0A1C 546C A6E6 84FF 05F5"            /* .......Tl. */
	$"1E04 100E 0E89 0D81 0C00 0E80 0F02 BCB8"            /* ........... */
	$"D687 FF00 F280 F010 DBDF EBC0 B763 0000"            /* և..c.. */
	$"0B00 010E 2D42 3C1F 0694 0002 0700 9481"            /* ....-B<...... */
	$"FF1A C700 0B20 3148 697F 7D62 330B 0500"            /* ... 1Hi.}b3... */
	$"0004 0E1D 3041 4F53 5A6B 8CBF EC88 FF03"            /* ....0AOSZk. */
	$"DF08 0D13 930F 060E 0C17 5E87 6250 8252"            /* ........^bPR */
	$"154F 211D 1E1E 1718 1C0F 0C00 0005 1100"            /* .O!............. */
	$"0211 2E41 371B 0594 0002 0700 9A81 FF12"            /* ...A7....... */
	$"F93E 0049 625C 4324 132B 5070 8CA6 C4D9"            /* >.Ib\C$.+Pp */
	$"E9F6 FB88 FF01 F5E5 82FF 06D2 5803 1609"            /* ..X.. */
	$"0D10 910F 060D 0D0C 0300 0305 8204 0105"            /* .............. */
	$"0A80 0B10 0C0B 0B0D 0C01 0003 0A00 0212"            /* ............. */
	$"2F40 3317 0394 0002 0500 9C82 FF08 E356"            /* /@3.......V */
	$"1215 2343 78B4 F48F FF0F FEFF F88A D3FF"            /* ..#Cx. */
	$"FFF6 A30F 0111 0700 0209 A50F 0D10 0600"            /* ......ƥ..... */
	$"0006 1400 0213 303E 2F14 0296 0000 9384"            /* ......0>/.... */
	$"FF02 E8E6 F390 FF0E E199 92F8 FFFF D949"            /* ..ᙒI */
	$"F1EF 2F00 3D41 0381 0007 050F 0703 080C"            /* /.=A......... */
	$"0D0E 9C0F 0110 0780 0009 040F 0003 1431"            /* ............1 */
	$"3C2C 1201 9400 0201 0081 92FF 01E9 FE83"            /* <,....... */
	$"FF02 F14D 5281 FF06 9D54 322C 7C57 0883"            /* .MR.T2,|W. */
	$"000C 0457 6D38 160E 0201 0504 090D 0D95"            /* ...Wm8........ */
	$"0F01 1007 8100 0803 0600 0415 3139 2810"            /* ...........19(. */
	$"9500 0204 005D 91FF 03E1 3F6B F483 FF02"            /* ....].?k. */
	$"D677 FA81 FF04 9700 3342 0185 000F 2298"            /* w..3B..." */
	$"F9E5 BC96 6A4F 522C 100C 0004 080E 900F"            /* 弖jOR,....... */
	$"0110 0782 0008 1B0B 0005 1730 3624 0D95"            /* ..........06$. */
	$"0003 020A 28F4 8EFF 06D3 6416 0000 35D8"            /* ...(.d...5 */
	$"83FF 01DF E982 FF04 B229 000C 0C86 0001"            /* ..)..... */
	$"5EF3 82FF 08F5 CAB6 8755 3709 0C0D 8D0F"            /* ^.ʶU7... */
	$"0110 0983 0008 350E 0006 1730 3220 0A96"            /* ..ƃ..5....02  */
	$"0002 0B06 BA8D FF01 B817 8200 0154 FE83"            /* ........T */
	$"FF02 E9D4 FA81 FF08 EC69 030E 1B2B 3417"            /* ..i...+4. */
	$"0482 0001 46DA 86FF 03F8 7A07 0D8C 0F01"            /* ...Fچ.z.... */
	$"1008 8300 0918 3A04 0006 182E 301D 0996"            /* ....:.....0.Ɩ */
	$"0003 0101 46FC 8BFF 01F2 1D83 0001 11E8"            /* ....F..... */
	$"84FF 01F0 F782 FF09 E806 0235 505E 5A50"            /* ...5P^ZP */
	$"2609 8100 0116 9F86 FF02 FDBF BB88 0F04"            /* &Ɓ...... */
	$"0E0D 0B0F 0983 000A 03AF A801 0007 182D"            /* ....ƃ......- */
	$"2C1A 0897 0002 0301 7C8B FF01 D606 8300"            /* ,......|... */
	$"0106 D28B FF0C DF44 2507 0000 0F1F 2E35"            /* ..ҋ.D%......5 */
	$"2918 0480 0001 69EF 87FF 820F 090E 0E0D"            /* )....i.... */
	$"0C0B 0D0F 1830 1E84 000A 21A0 7600 0007"            /* .....0..!v... */
	$"182B 2816 0698 0003 0704 54F6 89FF 00B8"            /* .+(......T. */
	$"8400 0107 D48C FF11 FEF6 DCB5 8137 0400"            /* ...Ԍ.ܵ7.. */
	$"0001 1310 1004 0000 2DC2 86FF 0E10 100F"            /* ........-.... */
	$"0E0C 0E11 1825 333E 4A58 400B 8400 0A40"            /* .....%3>JX@..@ */
	$"724D 0000 0717 2925 1404 9900 0409 0140"            /* rM....)%.....@ */
	$"B9FB 83FF 00FA 80FF 009A 8400 0110 E591"            /* ..... */
	$"FF0D FBDA AB78 4824 0700 030F 0000 17AC"            /* .ګxH$....... */
	$"85FF 0D06 0B0C 1537 4A52 575B 5D5D 613B"            /* .....7JRW[]]a; */
	$"0184 000B 0B41 4531 0000 0716 2722 1103"            /* ....AE1....'".. */
	$"9A00 0A05 2317 346F A3CB DDE0 9FE0 80FF"            /* ..#.4o */
	$"0091 8400 012B F896 FF0A F6D2 9A32 0310"            /* ...+Қ2.. */
	$"0000 0175 EE83 FF0C 0000 0104 1D39 595F"            /* ...u......9Y_ */
	$"605C 5E41 0285 000B 0F20 1E18 0000 0816"            /* `\^A.... ...... */
	$"251E 1003 9B00 0930 4431 0600 030A 0C68"            /* %....0D1....h */
	$"FD80 FF01 DD0A 8300 005E 9AFF 03EC 2E12"            /* ...^... */
	$"2680 0001 26CE 82FF 8300 0509 1C33 4B4A"            /* &..&΂...3KJ */
	$"0C85 000C 2262 6166 3A00 0007 1522 1C0E"            /* ..."baf:....".. */
	$"039A 0009 040A 031B 201D 1600 24EE 82FF"            /* ..... ...$ */
	$"005A 8200 0123 C99B FF03 C511 451D 8000"            /* .Z..#ɛ..E.. */
	$"051D B6FF F5C8 9C86 0001 0303 8500 0D02"            /* ..Ȝ....... */
	$"94DC D2E0 7200 0007 141F 180C 029A 0001"            /* r.......... */
	$"0612 8000 0401 110F 0EDE 82FF 06DA 2000"            /* ........ނ. . */
	$"0245 A3EC 8DFF 13FA D1FE FFFF FDEA CCA5"            /* .E.̥ */
	$"B5F6 FFFF FD94 3503 1D63 1780 0003 064D"            /* 5..c....M */
	$"2004 9100 0D2D B0AD ACB8 5D00 0007 111B"            /*  ...-]..... */
	$"1409 019A 0001 0614 8200 030C 0648 D382"            /* ..........Hӂ */
	$"FF02 D789 BC90 FF14 F93B 4261 593B 1805"            /* .׉.;BaY;.. */
	$"0000 32B3 FFDE 0201 1404 2E75 3E97 000D"            /* ..2.....u>.. */
	$"5E9E 9495 9F50 0000 060E 1811 0701 9A00"            /* ^P......... */
	$"0105 1082 0004 0111 0014 C897 FF01 FB2F"            /* .........ȗ./ */
	$"8600 0B0D C381 0009 6D44 002B 9A3B 0194"            /* ...Á.mD.+;. */
	$"000D 1581 8583 838C 4700 0005 0D14 0E06"            /* ...G....... */
	$"9B00 0102 0784 0002 1100 8C98 FF00 6787"            /* .........g */
	$"0000 0380 0006 0A9E A90C 3C52 0E94 000D"            /* ......<R... */
	$"4A7E 7677 777F 4000 0004 0A0F 0B04 9B00"            /* J~vww.@....... */
	$"0102 0483 0003 0A2C 18DA 98FF 03EC A266"            /* .....,.ژ.f */
	$"2285 0009 1616 0222 C0FF 5F00 0606 9300"            /* "...."_.... */
	$"020F 686C 806A 0871 3900 0003 070A 0703"            /* ..hlj.q9...... */
	$"9B00 0103 1183 0002 4116 7C9C FF02 ED8F"            /* ......A.|. */
	$"1582 0007 47E9 EBC3 E5FF FF8A 9500 0301"            /* ...G... */
	$"3B69 6580 6408 6B36 0000 0205 0704 019B"            /* ;ied.k6....... */
	$"0002 021C 0982 0002 3002 A79E FF02 DA86"            /* ....Ƃ..0..چ */
	$"2D80 0000 7483 FF00 9F95 0002 1F69 6781"            /* -..t....ig */
	$"6501 6C36 8000 0202 0302 9C00 0A02 1A19"            /* e.l6......... */
	$"0400 0002 191C 0080 A0FF 04F4 B067 54CE"            /* ........gT */
	$"83FF 00B7 9500 0818 616A 6564 6565 6B36"            /* ....ajedeek6 */
	$"A300 0A86 BCB9 4B00 357D 740F 20F3 AAFF"            /* .K.5}t.  */
	$"0283 0015 8016 0117 0C8F 0007 0D4D 746F"            /* ..........Mto */
	$"6D6D 743A A300 0AA2 E7E5 B625 8198 9A44"            /* mmt:.¢%D */
	$"00AC A9FF 09E3 123B 9F99 9A9B 9D8E 108F"            /* ..;. */
	$"0006 023B 777D 777F 40A3 000B 75A6 A183"            /* ...;w}w.@..u */
	$"5CA2 B2B5 9504 34F9 A8FF 095C 0391 AEAE"            /* \.4\. */
	$"ADA8 A8AE 4391 0004 1E66 8E8F 48A3 000B"            /* C...fH.. */
	$"4D6D A245 46B4 77B7 E46B 008A A7FF 0A89"            /* MmEFwk. */
	$"005A C2BC A255 3434 3728 9200 0306 75B3"            /* .Z¼U447(...u */
	$"56A3 000C 2E66 C24A 47B5 3964 D4D0 350E"            /* V...fJG9d5. */
	$"E3A6 FF05 5400 607B 7015 9800 0205 7A69"            /* .T.`{p....zi */
	$"A300 0D27 70BB 484A BB43 6E8A 79A8 153D"            /* ..'pHJCny.= */
	$"DE8A FF00 F396 FF05 F583 0015 1204 9A00"            /* ފ....... */
	$"0105 1DA3 000E 0816 240F 1E48 1F40 4D2F"            /* .......$..H.@M/ */
	$"834D 0921 C188 FF05 DD2E 4576 B4FA 80FF"            /* M!..Ev */
	$"02F9 CCE9 89FF 07CF A275 2908 0927 05CC"            /* ..Ϣu).'. */
	$"0006 0201 0915 030A 9486 FF01 DC2C 8100"            /* .......,. */
	$"0630 6CED DA3B 0443 85FF 04FE 9E4B 4B0E"            /* .0l;.C.KK. */
	$"8000 020A 0702 9400 0308 1A10 0080 01B3"            /* ........... */
	$"0021 0805 0048 92D3 F1F1 E5CB A977 1B00"            /* .!...H˩w.. */
	$"0B0B 0906 0000 2215 0004 0870 8B97 9DA0"            /* ....."....p */
	$"9894 833F 8000 0408 0F0A 0701 9600 061C"            /* ?......... */
	$"5E3A 0004 0302 B400 1705 1507 0004 1517"            /* ^:............. */
	$"0B01 0000 150E 0300 0103 0206 0806 0412"            /* ................ */
	$"1780 0002 0101 0380 0005 192C 2F41 2208"            /* .........,/A". */
	$"9800 061C 5E3B 0004 0302 B500 0B24 5344"            /* ...^;......$SD */
	$"271A 1626 1C15 395B 1083 0013 130D 0021"            /* '..&..9[......! */
	$"5236 4B52 3B3D 3522 0000 2F43 3643 2008"            /* R6KR;=5"../C6C . */
	$"8900 FFFF FBFF 7438 6D6B 0000 4008 0000"            /* .t8mk..@... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0001 2F4A 4646 4646 4646 4647"            /* ....../JFFFFFFFG */
	$"4849 4949 4A4A 4B4C 4D4D 4E4E 4F4F 5154"            /* HIIIJJKLMMNNOOQT */
	$"4405 0000 0000 0000 0000 0000 0000 0000"            /* D............... */
	$"0000 0014 5759 5858 5757 5756 5656 5757"            /* ....WYXXWWWVVVWW */
	$"5757 5757 5656 5754 1000 0000 0000 0000"            /* WWWWVVWT........ */
	$"0000 0000 0000 0000 114D 4E4C 4B4A 4A49"            /* .........MNLKJJI */
	$"4947 4746 4747 4646 4646 4645 4646 4816"            /* IGGFGGFFFFFEFFH. */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0009 1F1F 1F1F 2B5E 6563 6363 6464 6566"            /* .....+^ecccddef */
	$"6768 6868 696A 6C5E 5456 5758 5959 5B5C"            /* ghhhijl^TVWXYY[\ */
	$"6022 0000 0000 0000 0000 000C 2524 2424"            /* `"..........%$$$ */
	$"2424 232D 747C 7A76 7474 7879 7978 7574"            /* $$#-t|zvttxyyxut */
	$"6660 6363 6362 6361 1800 0000 0000 0002"            /* f`cccbca........ */
	$"2025 2424 2424 2420 4071 6E6C 6B6A 6967"            /*  %$$$$$ @qnlkjig */
	$"6766 6465 594B 4C4C 4C4C 4C4C 4B4F 3D04"            /* gfdeYKLLLLLLKO=. */
	$"0000 0000 0000 0000 031D 0F00 0000 0000"            /* ................ */
	$"000D 2D2E 2E2E 2B44 6E6D 6D6D 6F70 7071"            /* ..-...+Dnmmmoppq */
	$"7172 7474 7576 7970 5858 5A5B 5C5D 5E5F"            /* qrttuvypXXZ[\]^_ */
	$"6547 0100 0000 0000 0000 0006 3238 3737"            /* eG..........2877 */
	$"3737 3638 7587 88A0 B8C9 D7DB DBD8 CBB8"            /* 7768u˸ */
	$"9269 6065 6767 6862 1200 0000 0000 0005"            /* i`egghb........ */
	$"3338 3737 3636 3532 5F80 7A79 7876 7573"            /* 38776652_zyxvus */
	$"7271 6F6E 5649 4B4B 4B4B 4B4B 4B4D 1C00"            /* rqonVIKKKKKKKM.. */
	$"0000 0000 0000 0000 152F 1500 0000 0000"            /* ........./...... */
	$"000C 2C2C 2C2E 2D2C 516F 6D6E 6F70 7072"            /* ..,,,.-,Qomnoppr */
	$"7374 7576 7778 7A7B 655A 5D5E 6061 6263"            /* stuvwxz{eZ]^`abc */
	$"6663 1000 0000 0000 0000 0000 2639 3737"            /* fc..........&977 */
	$"3737 352B 6FAC D8FD FFFF FFFF FFFF FFFF"            /* 775+o */
	$"FEDD 9D76 6769 6E61 0700 0000 0000 0008"            /* ݝvgina........ */
	$"3538 3736 3636 3434 6D82 7D7C 7A78 7674"            /* 58766644m}|zxvt */
	$"7372 706B 504B 4C4B 4B4B 4B4B 4D42 0500"            /* srpkPKLKKKKKMB.. */
	$"0000 0000 0000 0003 242C 1400 0000 0000"            /* ........$,...... */
	$"000C 2C2D 2E2E 2F2F 3161 7270 7071 7374"            /* ..,-..//1arppqst */
	$"7577 7879 7B7D 7E80 7960 6063 6466 6769"            /* uwxy{}~y``cdfgi */
	$"6A70 3400 0000 0000 0000 0000 183B 393A"            /* jp4..........;9: */
	$"3A33 3475 DAFF FFFF FFFF FFFF FFFF FFFF"            /* :34u */
	$"FFFF FFEF BC7F 6E64 0600 0000 0000 000C"            /* .nd........ */
	$"393B 3939 3838 3541 8186 8280 7F7D 7B79"            /* 9;99885A.}{y */
	$"7674 7566 4E4D 4D4C 4B4B 4B4B 5027 0000"            /* vtufNMMLKKKKP'.. */
	$"0000 0000 0000 0017 2A2B 1400 0000 0000"            /* ........*+...... */
	$"000D 2D2F 2F30 3131 2F3E 6E73 7375 7777"            /* ..-//011/>nssuww */
	$"797B 7C7E 8081 8384 8774 6569 6A6B 6D6F"            /* y{|~teijkmo */
	$"7176 6004 0000 0000 0000 0000 0939 3E3D"            /* qv`.........9>= */
	$"3657 B6FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* 6W */
	$"FFFF FFFF FFEE B168 0300 0000 0000 0011"            /* h........ */
	$"3D3D 3D3C 3C3B 365E 908B 8887 8482 807E"            /* ===<<;6^~ */
	$"7B79 775F 5050 4E4D 4C4B 4B4D 4208 0000"            /* {yw_PPNMLKKMB... */
	$"0000 0000 0000 0E2A 292B 1400 0000 0000"            /* .......*)+...... */
	$"000D 2F30 3031 3233 3331 5479 7677 797A"            /* ../0012331Tyvwyz */
	$"7C7F 8082 8486 8789 8C8B 726C 6F71 7375"            /* |.rloqsu */
	$"7678 7C23 0000 0000 0000 0000 002F 4334"            /* vx|#........./C4 */
	$"71EE FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* q */
	$"FFFF FFFF FFFF FFBB 0000 0000 0000 0017"            /* ........ */
	$"4240 3F3F 3E3D 3B77 9791 8E8D 8A88 8582"            /* B@??>=;w */
	$"807D 785A 5352 504F 4D4C 4C4D 1C00 0000"            /* }xZSRPOMLLM.... */
	$"0000 0000 0001 212A 282B 1400 0000 0000"            /* ......!*(+...... */
	$"000D 3031 3132 3334 3535 3A6C 7C7A 7D7E"            /* ..01123455:l|z}~ */
	$"8082 8486 888B 8C8E 9094 8671 7476 787A"            /* qtvxz */
	$"7C7D 864D 0000 0000 0000 0000 0020 3A6D"            /* |}M......... :m */
	$"EDFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFE 6800 0000 0000 001D"            /* h....... */
	$"4643 4241 413F 438A 9C97 9492 918D 8A86"            /* FCBAA?C */
	$"8483 7659 5654 5251 4E4D 4F42 0500 0000"            /* vYVTRQNMOB.... */
	$"0000 0000 000E 2A29 282B 1400 0000 0000"            /* ......*)(+...... */
	$"000D 3132 3334 3637 3738 3744 7381 8182"            /* ..123467787Ds */
	$"8587 898B 8D90 9294 9799 9981 7A7C 7F81"            /* z|. */
	$"8384 897D 1600 0000 0000 0000 0003 70F0"            /* }..........p */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF F330 0000 0000 0025"            /* 0.....% */
	$"4A46 4545 4541 519E A19E 9B99 9794 918E"            /* JFEEEAQ */
	$"8A88 6E5C 5B58 5553 514F 5223 0000 0000"            /* n\[XUSQOR#.... */
	$"0000 0000 0322 2B29 292B 1400 0000 0000"            /* ....."+))+...... */
	$"000E 3233 3436 3739 3A3B 3C39 5082 8687"            /* ..234679:;<9P */
	$"898C 8E90 9395 979A 9C9E A299 8183 8588"            /*  */
	$"898B 8D96 5700 0000 0000 0000 004C F3FF"            /* W........L */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFB1 0000 0000 002C"            /* ....., */
	$"4E49 4948 4742 67AB A7A5 A2A0 9D9A 9794"            /* NIIHGBg */
	$"9286 6763 5F5C 5955 5354 4706 0000 0000"            /* gc_\YUSTG..... */
	$"0000 0000 132C 2929 292B 1400 0000 0000"            /* .....,)))+...... */
	$"000F 3434 3637 383B 3C3D 3F3F 3E6D 8C8B"            /* ..44678;<=??>m */
	$"8D90 9394 989A 9C9E A2A4 A6A8 9088 8B8D"            /*  */
	$"8F91 9298 870A 0000 0000 0000 13DD FFFF"            /* ....... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFC 4100 0000 0031"            /* A....1 */
	$"514C 4C4B 4A44 7CB3 ACAA A8A5 A4A0 9D9A"            /* QLLKJD| */
	$"9883 6968 635F 5C59 5658 2E00 0000 0000"            /* ihc_\YVX...... */
	$"0000 0003 242C 2A2A 292C 1400 0000 0000"            /* ....$,**),...... */
	$"000A 3238 3739 3B3D 3E40 4142 414C 8491"            /* .2879;=>@ABAL */
	$"9195 989A 9DA0 A2A5 A8A9 ABAF A68F 9093"            /*  */
	$"9596 979A A03A 0000 0000 0000 A0FF FFFF"            /* :...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF BA01 0000 0039"            /* ....9 */
	$"5350 4F4E 4D4B 95B9 B2B0 AEAC AAA6 A3A1"            /* SPONMK */
	$"9D80 6F6D 6864 615D 5B53 0E00 0000 0000"            /* omhda][S...... */
	$"0000 001C 2D2A 2A2A 292C 1500 0000 0000"            /* ....-***),...... */
	$"0000 1338 3A3B 3D3E 4042 4445 4643 5F93"            /* ...8:;=>@BDEFC_ */
	$"979A 9DA0 A3A5 A8AA ADAF B0B3 B6A6 9699"            /*  */
	$"9B9C 9E9F A777 0100 0000 005D FFFF FFFF"            /* w.....] */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF F826 0000 0243"            /* &...C */
	$"5552 5351 4F56 AEBC B9B7 B5B2 B0AD A9A8"            /* URSQOV */
	$"9F7E 7873 6E6A 6762 6238 0000 0000 0000"            /* ~xsnjgbb8...... */
	$"0000 0C2D 2C2B 2A2A 2A2C 1500 0000 0000"            /* ...-,+***,...... */
	$"0000 0020 3F3D 3F41 4244 4647 4949 4773"            /* ... ?=?ABDFGIIGs */
	$"9E9E A1A3 A7AA ACAF B1B3 B5B7 BAB8 9F9C"            /*  */
	$"9FA1 A2A4 A79F 1800 0000 0FD7 FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF5A 0000 044A"            /* Z...J */
	$"5754 5454 5063 BCC0 BDBB B9B7 B5B2 AFAE"            /* WTTTPc */
	$"9D81 7E79 746F 6A68 5B0D 0000 0000 0000"            /* ~ytojh[....... */
	$"0000 202F 2C2C 2A2A 2A2D 1500 0000 0000"            /* .. /,,***-...... */
	$"0000 0002 2641 4243 4546 484A 4B4D 4C4F"            /* ....&ABCEFHJKMLO */
	$"8BA7 A5A8 ABAE B0B3 B5B7 BABC BDC0 B3A1"            /*  */
	$"A3A5 A7A8 A9B2 5300 0000 A6FF FFFF FFFF"            /* S... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF8B 0000 0850"            /* ...P */
	$"5957 5756 507C C7C4 C1C0 BEBC BBB7 B5B4"            /* YWWVP| */
	$"9986 8480 7975 7070 3800 0000 0000 0000"            /* yupp8....... */
	$"000D 2F2E 2D2C 2B2A 2A2D 1500 0000 0000"            /* ../.-,+**-...... */
	$"0000 0000 0022 4546 4749 4B4D 4E4F 514F"            /* ....."EFGIKMNOQO */
	$"5FA1 ACAD B0B3 B5B8 BBBD BFC1 C2C4 C4AD"            /* _ĭ */
	$"A7AA ABAC ACB4 9308 0049 FEFF FFFF FFFF"            /* ..I */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFB4 0100 0E57"            /* ...W */
	$"5C5A 5A59 5397 CFC8 C6C5 C3C2 C0BD BBB5"            /* \ZZYS */
	$"978D 8B86 807C 796B 0F00 0000 0000 0000"            /* |yk........ */
	$"0126 322F 2E2C 2C2B 2A2D 1404 0900 0000"            /* .&2/.,,+*-..... */
	$"0000 0000 0000 2D4C 494B 4D4E 5052 5354"            /* ......-LIKMNPRST */
	$"4F7B B3B1 B4B7 B9BC BFC1 C2C4 C5C7 C9BE"            /* O{ɾ */
	$"ABAD AEB0 B0B3 B631 00C0 FFFF FFFF FFFF"            /* 1. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFD6 0700 135B"            /* ...[ */
	$"5D5C 5C5A 5AAE D1CB CAC8 C7C5 C3C1 C0B3"            /* ]\\ZZ */
	$"9894 908C 8681 844A 0000 0000 0000 0000"            /* J........ */
	$"1235 3230 2F2E 2C2C 2B2D 1228 1900 0000"            /* .520/.,,+-.(.... */
	$"0000 0000 0000 073B 504D 4F50 5253 5556"            /* .......;PMOPRSUV */
	$"555B 9EB9 B8BA BCBF C1C3 C5C7 C8C9 CBCA"            /* U[ */
	$"B4AF B1B3 B3B5 BD72 3AFA FFFF FFFF FFFF"            /* r: */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFE6 0E00 1B5F"            /* ..._ */
	$"5F5E 5D5B 63C1 D1CE CDCC CAC9 C7C5 C4B0"            /* _^][cİ */
	$"9B99 9591 8C88 821F 0000 0000 0000 0007"            /* ......... */
	$"2F36 3331 302F 2C2C 2C2A 3247 1600 0000"            /* /6310/,,,*2G.... */
	$"0000 0000 0000 000A 3A53 5152 5556 5758"            /* .......:SQRUVWX */
	$"5A57 64A9 BFBD C0C2 C5C6 C8CA CCCC CDCF"            /* ZWd */
	$"C9B5 B4B6 B6B7 B8AF CCFF FFFF FFFF FFFF"            /* ɵ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFF3 1E00 2463"            /* ..$c */
	$"6160 605B 77D0 D2D0 D0CF CECC CBC9 C6AC"            /* a``[wƬ */
	$"A29E 9B97 9193 6100 0000 0000 0000 0023"            /* a........# */
	$"3B36 3332 3130 2E2D 293D 5A4B 1500 0000"            /* ;63210.-)=ZK.... */
	$"0000 0000 0000 0000 053D 5755 5658 595A"            /* .........=WUVXYZ */
	$"5B5D 5872 BCC3 C2C6 C8C9 CACC CECF D0D1"            /* []Xr */
	$"D4C4 B6B7 B9B9 B6CF FFFF FFFF FFFF FFFF"            /* Ķ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFF7 2A00 2B66"            /* *.+f */
	$"6161 615A 90D8 D4D3 D2D1 D0CF CECD C0AA"            /* aaaZ */
	$"A8A4 A19C 9995 2700 0000 0000 0000 0D3B"            /* '........; */
	$"3A38 3634 3130 302C 3263 5D48 1500 0000"            /* :864100,2c]H.... */
	$"0000 0000 0000 0000 000D 4E59 5859 5B5C"            /* ..........NYXY[\ */
	$"5D5E 5E5A 98C8 C4C6 C8CA CCCD CFD0 D1D3"            /* ]^^Z */
	$"D4D1 BBB8 BABA B9EC FFFF FFFF FFFF FFFF"            /* ѻ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFF8 2D00 3168"            /* -.1h */
	$"6363 615F ADDB D5D5 D4D3 D2D1 D0CF B9AC"            /* cca_Ϲ */
	$"ABA8 A5A1 A36A 0200 0000 0000 0000 2841"            /* j........(A */
	$"3B39 3735 3332 302B 5170 5B49 1500 0000"            /* ;975320+Qp[I.... */
	$"0000 0000 0000 0000 0000 1654 5D5B 5C5E"            /* ...........T][\^ */
	$"5E5F 5D57 62B7 CFD2 D6D5 D2D0 CFD1 D3D4"            /* ^_]Wb */
	$"D4D7 C8BA BCBB C9FD FFFF FFFF FFFF FFFF"            /* Ⱥ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFF8 2C00 3A6A"            /* ,.:j */
	$"6464 6170 CCD9 D7D6 D5D5 D4D3 D3CE B5B1"            /* ddapε */
	$"AFAB A9A7 9D21 0000 0000 0000 000E 4140"            /* !........A@ */
	$"3D3B 3836 3533 2E45 6B6D 5B49 1500 0002"            /* =;8653.Ekm[I.... */
	$"0C00 0000 0000 0000 0000 0015 5160 5D5F"            /* ............Q`]_ */
	$"5E59 6790 BBE7 FCFD FEFE FCF4 E8DC D3D5"            /* ^Yg */
	$"D6D7 D5C1 BCBB E0FF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFF5 2400 426A"            /* $.Bj */
	$"6565 6087 DAD9 D8D7 D7D6 D6D6 D6C9 B5B4"            /* ee`ɵ */
	$"B2AF ACB2 6E00 0000 0000 0000 0032 4741"            /* n........2GA */
	$"3F3C 3A38 3631 456E 6E6D 5B49 1500 0001"            /* ?<:861Ennm[I.... */
	$"381E 0000 0000 0000 0000 0000 1B5D 615A"            /* 8............]aZ */
	$"5E8E E0FF FFFF FFFF FFFF FFFF FFFD E6D5"            /* ^ */
	$"D7D7 D9CB BBC0 F3FF FFFF FFFF FFFF FFFF"            /* ˻ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFF0 1800 4A6A"            /* ..Jj */
	$"6565 5F99 DFD9 D8D8 D8D8 D7D7 D6C4 B7B6"            /* ee_ķ */
	$"B5B2 B0B1 3300 0000 0000 0000 1B4A 4642"            /* 3........JFB */
	$"403F 3C39 3638 6772 6D6E 5C49 1500 0000"            /* @?<968grmn\I.... */
	$"3F59 2100 0000 0000 0000 0000 0024 5779"            /* ?Y!..........$Wy */
	$"CBFF FFFF FFFF FFFF FFFF FFFF FFFF FFED"            /*  */
	$"D7D7 D9D8 C3CD FEFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFE4 0B00 536A"            /* ..Sj */
	$"6766 62AF E0D9 DAD9 D9D9 D8D8 D6C0 BAB8"            /* gfb */
	$"B7B5 BA8C 0600 0000 0000 0007 444D 4744"            /* ........DMGD */
	$"4341 3E3B 365D 7671 6E6E 5C49 1500 0000"            /* CA>;6]vqnn\I.... */
	$"3D5D 5B25 0000 0000 0000 0000 0000 92F7"            /* =][%.......... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"EDD8 D9DA D2E6 FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFD2 0503 5A6A"            /* ..Zj */
	$"6765 6BC6 DEDA DADA DADA D9DA D1BE BCBB"            /* gekѾ */
	$"B9B8 BA40 0000 0000 0000 002B 534D 4A47"            /* @.......+SMJG */
	$"4542 3F39 537C 7672 7170 5C49 1500 0000"            /* EB?9S|vrqp\I.... */
	$"3E5B 5E61 2700 0000 0000 0000 0089 FFFF"            /* >[^a'........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFE6 D8D9 DCFB FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFB4 000B 6169"            /* ..ai */
	$"6864 78D7 DCDB DBDA DADA DADB CCBF BFBD"            /* hdx̿ */
	$"BBC0 9C06 0000 0000 0000 0B4E 524E 4C49"            /* ........NRNLI */
	$"4644 3D4E 7D7E 7774 7171 5C49 1500 0000"            /* FD=N}~wtqq\I.... */
	$"3F5E 5D63 662E 0000 0000 0000 60FE FFFF"            /* ?^]cf.......` */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFF3 DAD8 E5FF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF9E 0016 6769"            /* ..gi */
	$"6862 8BDD DCDB DBDB DBDB DADA C6C0 BFBF"            /* hb */
	$"BEC3 5200 0000 0000 0000 2D59 524F 4D4A"            /* R.......-YROMJ */
	$"4843 487C 877E 7976 7372 5D49 1500 0000"            /* HCH|~yvsr]I.... */
	$"405F 5F63 6A6E 3400 0000 0061 F7FF FFFF"            /* @__cjn4....a */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFD DDDB F6FF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF7A 0026 6B69"            /* z.&ki */
	$"6862 A0E1 DADA D9DA DADA DBD5 C2C1 C1C0"            /* hb */
	$"C78D 0400 0000 0000 000E 5458 5452 4F4C"            /* Ǎ........TXTROL */
	$"4946 7891 8882 7C79 7574 5F4A 1500 0000"            /* IFx|yut_J.... */
	$"4160 6165 6970 7638 0000 34F5 FFFF FFFF"            /* A`aeipv8..4 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF E3E5 FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FF55 0034 6F69"            /* U.4oi */
	$"6763 B5E2 E0E3 E5E4 E2DF DBC9 BFC1 C1C2"            /* gcɿ */
	$"C43A 0000 0000 0000 0544 5D57 5553 514E"            /* :.......D]WUSQN */
	$"476E 9A90 8B85 7F7B 7776 604B 1500 0000"            /* Gn.{wv`K.... */
	$"4262 6267 6B6F 777F 3E00 A6FF FFFF FFFF"            /* Bbbgkow.>. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF E7EF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FC32 003E 6F62"            /* 2.>ob */
	$"6785 DFFA FDFF FFFF FEFC F2DB C9BF BEC7"            /* gɿ */
	$"A206 0000 0000 0000 2562 5B59 5754 524B"            /* .......%b[YWTRK */
	$"589B 9D93 8E88 827D 7977 604B 1500 0000"            /* X}yw`K.... */
	$"4363 6369 6E72 777F 7F72 F5FF FFFF FFFF"            /* Cccinrw..r */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF EBF9 FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF E610 0041 6990"            /* ..Ai */
	$"D8FB FFFF FFFF FFFF FFFF FFFF FBE9 CEC6"            /*  */
	$"4F00 0000 0000 0005 4F61 5C5B 5856 505A"            /* O.......Oa\[XVPZ */
	$"98A8 9E97 928B 8580 7B79 634C 1600 0000"            /* {ycL.... */
	$"4466 666A 7074 7A7F 81D7 FFFF FFFF FFFF"            /* Dffjptz. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF F6FF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF B901 0051 BFFE"            /* ..Q */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FEE5"            /*  */
	$"2E00 0000 0000 002E 655F 5D5C 5A56 5698"            /* ........e_]\ZVV */
	$"B5A9 A29B 968F 8884 7E7C 624D 1600 0000"            /* ~|bM.... */
	$"4567 686D 7176 7C80 8FF5 FFFF FFFF FFFF"            /* Eghmqv| */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF 8400 0BCE FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"DA23 0000 0000 085A 645F 5E5D 5A52 86BD"            /* #.....Zd_^]ZR */
	$"B3AC A59F 9992 8B86 8372 5451 1600 0000"            /* rTQ.... */
	$"4768 686E 7478 7E7E ADFF FFFF FFFF FFFF"            /* Ghhntx~~ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFF7 3400 88FF FFFF"            /* 4. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFC2 1700 0000 2E67 6261 5F5E 566A B8BD"            /* .....gba_^Vj */
	$"B5AF A8A2 9C95 8E8B 7F5D 5452 1700 0000"            /* .]TR.... */
	$"4772 736F 767B 8088 E1FF FFFF FFFF FFFF"            /* Grsov{ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFC7 013B FBFF FFFF"            /* .; */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF C109 0013 5E65 6261 605C 65AF C7BD"            /* ..^eba`\eǽ */
	$"B8B3 ACA6 A099 9489 6859 5854 1700 0000"            /* hYXT.... */
	$"467B 997E 747C 7EA6 FFFF FFFF FFFF FFFF"            /* F{~t|~ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FF8E 00AD FFFF FFFF"            /* . */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF5B 004E 6A64 6362 5F5F AECE C4C0"            /* [.Njdcb__ */
	$"BBB6 AFA9 A39E 9270 615E 5956 1700 0000"            /* pa^YV.... */
	$"477B A0A0 8A7E 7DC5 FFFF FFFF FFFF FFFF"            /* G{~} */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FF53 10EF FFFF FFFF"            /* S. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFA7 1866 6664 6462 5B8F D1CB C6C1"            /* .ffddb[ */
	$"BEB9 B2AC A79F 7D6A 6560 5C57 1800 0000"            /* }je`\W.... */
	$"497D A0A6 AC9F 8EE6 FFFF FFFF FFFF FFFF"            /* I} */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF EF11 54FF FFFF FFFF"            /* .T */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFE8 6167 6564 645E 7ACD D1CC C8C4"            /* agedd^z */
	$"C0BC B5B1 AA8C 746F 6963 5F5A 1800 0000"            /* toic_Z.... */
	$"4A7F A1A7 ACAF BDFD FFFF FFFF FFFF FFFF"            /* J. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF B900 9CFF FFFF FFFF"            /* . */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF 9460 6766 616A C0D7 CFCD CAC6"            /* `gfaj */
	$"C2BE B9B4 9880 7973 6D66 615D 1A00 0000"            /* ¾ysmfa].... */
	$"4C80 A2A7 ACAC D2FF FFFF FFFF FFFF FFFF"            /* L */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF 8300 C8FF FFFF FFFF"            /* . */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF B05E 6764 62A7 DBD3 D1CF CBC8"            /* ^gdb */
	$"C4C0 BCA2 8B84 7D76 7069 645F 1A00 0000"            /* }vpid_.... */
	$"4D82 A3A9 ADAF E4FF FFFF FFFF FFFF FFFF"            /* M */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF 4805 DFFF FFFF FFFF"            /* H. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF CF64 6560 9CDC D6D4 D2D0 CDCA"            /* de` */
	$"C7C4 AE94 9088 817A 736C 6665 1B00 0000"            /* Įzslfe.... */
	$"4E84 A4AA ADB7 F6FF FFFF FFFF FFFF FFFF"            /* N */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFEB 1210 E4FF FFFF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF EC70 5F86 D8DA D6D5 D3D1 CFCC"            /* p_ */
	$"CAB8 9F98 938C 857E 7770 6F51 0C00 0000"            /* ʸ~wpoQ.... */
	$"4F85 A5AB ADC3 FEFF FFFF FFFF FFFF FFFF"            /* O */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFBE 0016 E5FF FFFF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FB7D 69CA DDD7 D6D5 D4D2 D0CE"            /* }i */
	$"C1A7 A19B 978F 8882 7C78 4609 0000 0000"            /* |xF.... */
	$"5087 A6AC ADD1 FFFF FFFF FFFF FFFF FFFF"            /* P */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FF90 0019 E7FF FFFF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FF93 A0DF D9D8 D7D6 D4D3 D2C6"            /*  */
	$"AFA8 A49E 9992 8A87 8347 0200 0000 0000"            /* G...... */
	$"5189 A7AD AFE2 FFFF FFFF FFFF FFFF FFFF"            /* Q */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FF57 001D EAFF FFFF FFFF"            /* W.. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFDA D6DB D9D9 D8D7 D5D5 CCB5"            /* ̵ */
	$"AEAC A6A1 9B95 9288 3E00 0000 0000 0000"            /* >....... */
	$"548A A8AD B4EF FFFF FFFF FFFF FFFF FFFF"            /* T */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF F925 0021 EDFF FFFF FFFF"            /* %.! */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFF8 DCDA DAD9 D8D7 D7D1 BAB3"            /* Ѻ */
	$"B0AD A8A4 9E9F 8628 0000 0000 0000 0000"            /* (........ */
	$"4E90 ABAD BBF9 FFFF FFFF FFFF FFFF FFFF"            /* N */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF C104 0024 F0FF FFFF FFFF"            /* ..$ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFB DED9 DAD9 D8D9 D5C1 B6B4"            /*  */
	$"B2AE AAA6 A988 2200 0000 0000 0000 0000"            /* "......... */
	$"0B4A A3B2 CFFF FFFF FFFF FFFF FFFF FFFF"            /* .J */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 6B00 0029 F3FF FFFF FFFF"            /* k..) */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF E3D9 DAD9 DAD5 C2BA B9B6"            /* º */
	$"B3AF AEB2 7E16 0000 0000 0000 0000 0000"            /* ~........... */
	$"000F 5B8A DEFF FFFF FFFF FFFF FFFF FFFF"            /* ..[ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFD 3B00 0030 F8FF FFFF FFFF"            /* ;..0 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF E7D9 DADA D8C4 BCBC B9B8"            /* ļ */
	$"B5B5 AF5A 0A00 0000 0000 0000 0000 0000"            /* Z........... */
	$"0016 4D51 CDFF FFFF FFFF FFFF FFFF FFFF"            /* ..MQ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFF2 2000 003D FDFF FFFF FFFF"            /*  ..= */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EAD9 DBDB CABD BDBD BAB8"            /* ʽ */
	$"BBBA 5500 0000 0000 0003 0A00 0000 0000"            /* U............ */
	$"0016 5056 D7FF FFFF FFFF FFFF FFFF FFFF"            /* ..PV */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFE3 1700 0050 FFFF FFFF FFFF"            /* ...P */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EEDA DBCC C0BF BDBD BCC2"            /*  */
	$"B34A 0000 0000 0000 0939 2600 0000 0000"            /* J......9&..... */
	$"0016 4E5B E8FF FFFF FFFF FFFF FFFF FFFF"            /* ..N[ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFCF 0F00 0061 FFFF FFFF FFFF"            /* ...a */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF F0D9 CCBF C1C0 BFBE C592"            /* ̿Œ */
	$"2A00 0000 0000 001B 4556 2500 0000 0000"            /* *.......EV%..... */
	$"0016 4E5D F0FF FFFF FFFF FFFF FFFF FFFF"            /* ..N] */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFC3 0C00 0077 FFFF FFFF FFFF"            /* ...w */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF F3CE C0C1 C1C0 C0CA 8C0C"            /* ʌ. */
	$"0000 0000 0002 3656 5352 2500 0000 0000"            /* ......6VSR%..... */
	$"0016 4D64 F6FF FFFF FFFF FFFF FFFF FFFF"            /* ..Md */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFB5 0A00 0094 FFFF FFFF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EEC2 C1C2 C1C4 C98A 1200"            /* Ɋ.. */
	$"0000 0000 0A3C 5B55 5254 2600 0000 0000"            /* ....<[URT&..... */
	$"0016 4D69 F8FF FFFF FFFF FFFF FFFF FFFF"            /* ..Mi */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FCAC 0900 02C2 FFFF FFFF FFFF"            /* .. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF ECC1 C2C2 C6BB 5806 0000"            /* ƻX... */
	$"0000 0023 505F 5754 5254 2600 0000 0000"            /* ...#P_WTRT&..... */
	$"0017 506C F8FF FFFF FFFF FFFF FFFF FFFF"            /* ..Pl */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF F6A4 0300 1EF1 FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EDC2 C2C8 C13B 0000 0000"            /* ;.... */
	$"0000 3963 605B 5855 5354 2700 0000 0000"            /* ..9c`[XUST'..... */
	$"0008 2C5E F7FF FFFF FFFF FFFF FFFF FFFF"            /* ..,^ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF F1A5 0001 7FFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EDC2 CBB9 4400 0000 0000"            /* ˹D..... */
	$"0B40 6560 5D5C 5956 5455 2400 0000 0000"            /* .@e`]\YVTU$..... */
	$"0000 0016 E9FF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FEEB B6BE FCFF FFFF FFFF FFFF"            /* 붾 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF F0CC 8F24 0000 0000 0027"            /* ̏$.....' */
	$"5A68 625F 5E5C 5957 5250 3237 1C00 0000"            /* Zhb_^\YWRP27.... */
	$"0000 0005 D1FF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF F274 0700 0000 0006 4068"            /* t......@h */
	$"6763 6260 5E5C 5952 5781 9487 2600 0000"            /* gcb`^\YRW&... */
	$"0000 0000 B4FF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF C200 0000 0000 0E49 6D66"            /* ......Imf */
	$"6463 6260 5F58 576A 9FBD A182 2400 0000"            /* dcb`_XWj$... */
	$"0000 0000 8EFF FFFF FFFF FFFF FFFF FFFF"            /* .... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF A900 0000 0027 5F6B 6765"            /* ....'_kge */
	$"6463 625D 5A70 A1BE BEB7 9E82 2400 0000"            /* dcb]Zp$... */
	$"0000 0000 38F8 FFFF FFFF FFFF FFFF FFFF"            /* ....8 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 9A00 0008 406B 6A67 6766"            /* ...@kjggf */
	$"6562 5E74 9EC4 CAC1 BBB8 9E82 2400 0000"            /* eb^t$... */
	$"0000 0000 01C7 FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 8800 1B5A 6E69 6767 6764"            /* ..Znigggd */
	$"5E66 A0CC D1CA C4C0 BBB7 9D82 2400 0001"            /* ^f$... */
	$"3A37 0F00 007E FFFF FFFF FFFF FFFF FFFF"            /* :7...~ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 711B 626E 6968 6866 6168"            /* q.bnihhfah */
	$"87B9 D6D0 CBC8 C4BF BAB8 9D81 2300 0000"            /* Ŀ#... */
	$"6694 845F 3031 ECFF FFFF FFFF FFFF FFFF"            /* f_01 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 8360 6C69 6967 6265 88BE"            /* `liigbe */
	$"D8D7 D0CD CBC7 C4C0 BCB3 9780 2300 0000"            /* #... */
	$"6090 929D 9D88 C9FF FFFF FFFF FFFF FFFF"            /* ` */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFB 8566 6969 6666 88B7 DADB"            /* fiiff */
	$"D5D3 D0CD CAC8 C4BB A994 8880 2300 0000"            /* Ļ#... */
	$"5F8F 8F95 9BA0 AFF9 FFFF FFFF FFFF FFFF"            /* _ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFE5 7067 6663 70AA DCDE D8D6"            /* pgfcp */
	$"D4D3 D0CE CCC3 B19E 928B 8680 2200 0000"            /* ñ"... */
	$"5F8E 8F95 9A9F A0C7 FDFF FFFF FFFF FFFF"            /* _ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFBA 6163 739C CBDF DAD8 D7D6"            /* acs */
	$"D5D4 CFC3 B6A7 9D98 928B 857E 2200 0000"            /* ö~"... */
	$"5F8E 8F95 9A9E A3A4 C2F9 FFFF FFFF FFFF"            /* _ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FD88 649A CFE1 DDDA D8D8 D7D6"            /* d */
	$"D1C5 B5AB A6A2 9C97 9188 827C 2100 0000"            /* ŵ|!... */
	$"5F8E 8E94 9A9E A3A7 A5C6 FAFF FFFF FFFF"            /* _ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF EE8A B7E2 DEDA DAD9 D9D9 D4C8"            /*  */
	$"B9B1 ADAA A6A1 9A95 8F87 817A 2000 0000"            /* z ... */
	$"5F8D 8C92 999D A3A7 ABAA C1E9 FDFF FFFF"            /* _ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF EDD7 E0DB DBDA DBD9 D2C8 BDB7"            /* Ƚ */
	$"B4B2 ADA8 A49F 9994 8D86 807B 2100 0000"            /* {!... */
	$"5E93 9F9E 9C9D A1A5 A9AD AFB3 C6E4 F9FF"            /* ^ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF E6DB DBDC DCD9 D0C4 BCB9 B9B6"            /* ļ */
	$"B3B0 ACA7 A39C 9792 8E89 7D6A 1900 0000"            /* }j.... */
	$"5C96 B2B7 B8B8 B7B1 ADAD B0B1 B2B6 C2D1"            /* \ */
	$"E9FE FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFF9 DCDC DDD9 CCC2 BDBC BCBA B8B6"            /* ½ */
	$"B3AF AAA6 A4A1 9D93 7A48 210B 0000 0000"            /* zH!..... */
	$"5B95 AFB6 BABF C4C7 C6C4 C1BE BCB9 B8B6"            /* [ */
	$"BACA DBEB FBFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFED DAD7 CEC4 BEBE BDBD BBBA B7B5"            /* ľ */
	$"B4B3 B2A9 9979 502F 0F00 0000 0000 0000"            /* yP/........ */
	$"5A94 AEB4 B9BD C2C6 CACD D0D2 D2D1 CDC9"            /* Z */
	$"C5BF BBBE C6DB F0FF FFFF FFFF FFFF FFFF"            /* ſ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF F8D5 C9C2 BFBF BFBE BDBC BBBD C0BA"            /* ¿ */
	$"AB90 643A 1A02 0000 0000 0000 0000 0000"            /* d:............ */
	$"5A93 ADB3 B8BC C1C5 C8CB CED0 D2D5 D7D8"            /* Z */
	$"D8D7 D5D1 CBC4 C4D9 FBFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFF7 CEBF C0C1 C0C0 BFBF C1C5 BEA3 7747"            /* οžwG */
	$"2206 0000 0000 0005 1324 1500 0000 0000"            /* "........$...... */
	$"5A91 ACB2 B7BB C0C4 C8CB CED0 D2D4 D5D6"            /* Z */
	$"D7D9 DADB DBDA D8CE E7FF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFDA BCC1 C1C2 C3C8 C8BF A87E 4312 0000"            /* ڼȿ~C... */
	$"0000 0004 0E1E 314A 5458 2900 0000 0000"            /* ......1JTX)..... */
	$"5991 ABB1 B6BA BFC4 C7CA CDCF D2D4 D5D6"            /* Y */
	$"D7D8 D9D9 DADA DCDB E2FF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFEC C7C4 CBC4 B48E 5C33 0E00 0000 010F"            /* Ĵ\3...... */
	$"1E2F 4052 5B5D 5D59 5455 2600 0000 0000"            /* ./@R[]]YTU&..... */
	$"5A91 AAB0 B5B9 BEC3 C5C9 CCCF D1D3 D5D6"            /* Z */
	$"D7D8 D9D9 DADA DBD9 E6FF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF F7AB 653A 1600 0000 071E 3341 5360"            /* e:......3AS` */
	$"6568 6663 5F5C 5855 5254 2600 0000 0000"            /* ehfc_\XURT&..... */
	$"4C86 A6B0 B8BD C3C6 C8CB CDCF D1D3 D4D5"            /* L */
	$"D7D8 D9D9 DADA DBD9 EBFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFB3 0000 0218 3147 5E6A 6C6D 6965"            /* ....1G^jlmie */
	$"6463 615F 5D5A 5855 5253 2600 0000 0000"            /* dca_]ZXURS&..... */
	$"0421 5B6A 7985 94A3 AFBD C7CD D3D7 DADB"            /* .![jy */
	$"DBDB DBDB DBDB DAD9 EFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF D796 ECFF"            /* ז */
	$"FFFF FFFF 8647 5D69 6E6D 6A68 6766 6664"            /* G]inmjhgffd */
	$"6362 615F 5D5A 5754 5153 2500 0000 0000"            /* cba_]ZWTQS%..... */
	$"0010 4245 474A 4F55 5A63 6E7B 8795 A2AC"            /* ..BEGJOUZcn{ */
	$"B9C7 D0D5 DADE E0DF F4FF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF DE8B 1709 9DFF"            /* ދ.Ɲ */
	$"FFFF FFFF F67D 686A 6968 6867 6766 6564"            /* }hjihhggfed */
	$"6362 605E 5C59 5553 5051 2400 0000 0000"            /* cb`^\YUSPQ$..... */
	$"0012 4448 4B4E 5154 5558 595A 5A5C 5E61"            /* ..DHKNQTUXYZZ\^a */
	$"656B 717B 8895 9FB6 F0FF FFFF FFFF FFFF"            /* ekq{ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF EC9C 6B5B 5860 80F8"            /* k[X` */
	$"FFFF FFFF FFA9 6069 6868 6767 6665 6463"            /* `ihhggfedc */
	$"615E 5C59 5653 504E 4D50 2502 0200 0000"            /* a^\YVSPNMP%..... */
	$"0012 4246 494D 5053 5659 5B5D 5F61 6263"            /* ..BFIMPSVY[]_abc */
	$"6464 6564 6362 616E EAFF FFFF FFFF FFFF"            /* ddedcban */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF F8E7 885E 676A 6C68 6CE6"            /* ^gjlhl */
	$"FFFF FFFF FFD2 6462 6262 6263 6566 6667"            /* dbbbbceffg */
	$"6B6F 7274 787C 7C7D 7D80 6448 1600 0000"            /* kortx||}}dH.... */
	$"0012 4145 484A 4E51 5457 5A5C 5E60 6263"            /* ..AEHJNQTWZ\^`bc */
	$"6465 6667 6767 6576 F6FF FFFF FFFF FFFF"            /* defgggev */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFB F1E6 DCDE 995F 6463 625F 6DE9"            /* ޙ_dcb_m */
	$"FFFF FFFF FFF3 9088 939A 9FA4 ABB1 B4B6"            /* 󐈓 */
	$"B8B9 B6B3 B0AC A6A1 9B95 785B 1900 0000"            /* x[.... */
	$"0011 3E42 4548 4C50 5255 585A 5C5F 6062"            /* ..>BEHLPRUXZ\_`b */
	$"6365 6666 6767 6387 FDFF FFFF FFFF FFFF"            /* ceffggc */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FBF2 E8DE DAD9 DBE0 C381 888E 97AB D3FD"            /* Á */
	$"FFFF FFFF FFFF E3D7 D9D9 D8D6 D2CF CBC6"            /*  */
	$"C2BD B7B2 ADA6 A09A 9591 7355 1800 0000"            /* ½sU.... */
	$"0011 3F43 4649 4D51 5457 5A5D 5F61 6466"            /* ..?CFIMQTWZ]_adf */
	$"6769 6A6A 6C6D 6694 FFFF FFFF FFFF FFFF"            /* gijjlmf */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFE F8ED"            /*  */
	$"DED9 D9DA DADA DADA DAD9 DEE6 F5FF FFFF"            /*  */
	$"FFFF FFFF FFFF E6CC CECC CAC8 C4C1 BEBA"            /*  */
	$"B7B3 ADA8 A39D 9793 8D8A 6F54 1700 0000"            /* oT.... */
	$"000C 2C2E 3032 3436 3839 3A3B 3C3E 3F3F"            /* ..,.024689:;<>?? */
	$"3F3F 4040 3F40 3887 FFFF FFFF FFFF FFFF"            /* ??@@?@8 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFD F9F1 E7DE DAD8"            /*  */
	$"DADB DCDC DCDD DEE1 E8F3 FBFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF E5B4 B4B2 AFAB A7A3 9E98"            /* 崴 */
	$"928E 8781 7B74 6F6A 6560 5B55 1700 0000"            /* {toje`[U.... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 029C FFFF FFFF FFFF FFFF"            /* ....... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFC F6EF E8E2 E0E2 E5E9 EDF0"            /*  */
	$"F3F5 F8F8 F9FA FCFE FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EAB5 B1AF ABA7 A39E 9893"            /* 굱 */
	$"8D87 807A 746E 6762 5E58 5654 1700 0000"            /* ztngb^XVT.... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0009 4CC4 FFFF FFFF FFFF FFFF"            /* .....L */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFA F5EF E7DE DEE5 F0F8 FCFE FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF E6B4 B2AD AAA6 A19C 9690"            /* 洲 */
	$"8B85 7D77 716B 6560 5C58 5552 1700 0000"            /* }wqke`\XUR.... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0856 76CB FFFF FFFF FFFF FFFF"            /* .....Vv */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FEEE E5E7 EAF3 FCFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF CA8D A1AE A8A2 9E99 938C"            /* ʍ */
	$"8782 7B74 6E68 635F 5A56 5451 1600 0000"            /* {tnhc_ZVTQ.... */
	$"0000 0000 0000 0000 0000 0000 0000 0409"            /* ............... */
	$"090C 161E 5379 72D5 FFFF FFFF FFFF FFFF"            /* ...Syr */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF F6BB 7D6E 768E A3A1 9B97 9089"            /* }nv */
	$"837D 7671 6B65 605C 5854 5250 1600 0000"            /* }vqke`\XTRP.... */
	$"0000 0207 1012 1929 3645 5766 707D 8B95"            /* .......)6EWfp} */
	$"9BA7 AF84 7471 76E3 FFFF FFFF FFFF FFFF"            /* tqv */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFDA 806B 7173 726F 7F95 9697 938B"            /* ڀkqsro. */
	$"857C 746E 6963 5D5A 5653 524F 1600 0000"            /* |tnic]ZVSRO.... */
	$"3452 5966 7176 808C 949C A4A9 ACAF B2B4"            /* 4RYfqv */
	$"B8B7 8C73 7371 79EC FFFF FFFF FFFF FFFF"            /* ssqy */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFE2 A273 6D73 7376 7473 7367 413E 4A54"            /* smssvtssgA>JT */
	$"5D65 6A6A 6865 605B 5754 514F 1600 0000"            /* ]ejjhe`[WTQO.... */
	$"4C71 7177 7B80 868B 8F94 999E A2A7 ABAF"            /* Lqqw{ */
	$"B188 6F73 7372 7EF3 FFFF FFFF FFFF FFFF"            /* ossr~ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFDC 9673 6F75 7762 7179 7373 674E 3529"            /* ܖsouwbqyssgN5) */
	$"2016 141B 202A 353D 454A 4D4F 1600 0000"            /*  ... *5=EJMO.... */
	$"476B 6C71 777C 8188 8C91 979B A0A4 AAAD"            /* Gklqw| */
	$"8970 7373 7471 61F4 FFFF FFFF FFFF FFFF"            /* psstqa */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFDB 8772 4007 205A 7974 7576 6C5C"            /* ۇr@. Zytuvl\ */
	$"564F 4232 2416 0A04 0105 0F18 0900 0000"            /* VOB2$......... */
	$"476A 6A70 757A 8086 8A90 959A 9EA4 A98E"            /* Gjjpuz */
	$"7173 7374 7A3F 29F7 FFFF FFFF FFFF FFFF"            /* qsstz?) */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF BB14 0000 0002 4878 7773 7569"            /* .....Hxwsui */
	$"5751 5151 4F49 4137 2314 0300 0000 0000"            /* WQQQOIA7#....... */
	$"4668 696E 7378 7D83 888E 9498 9DA2 8871"            /* Fhinsx}q */
	$"7373 737A 5001 35FD FFFF FFFF FFFF FFFF"            /* ssszP.5 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF D979 5928 0700 001F 6176 7475"            /* yY(....avtu */
	$"705B 4B4A 4845 4241 3F3E 1B00 0000 0000"            /* p[KJHEBA?>...... */
	$"4566 666C 7175 7B81 858B 9095 9B87 7173"            /* Efflqu{qs */
	$"7373 7A56 0600 46FF FFFF FFFF FFFF FFFF"            /* sszV..F */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFF6 D3AA 7940 1F3D 666F"            /* Ӫy@.=fo */
	$"7374 6049 4443 403E 3A3B 1B00 0000 0000"            /* st`IDC@>:;...... */
	$"4365 656A 6E72 787D 8289 919E 8C71 7373"            /* Ceejnrx}qss */
	$"737A 5309 0000 58FF FFFF FFFF FFFF FFFF"            /* szS..X */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF E9C2 A68C"            /* ¦ */
	$"7570 7569 4B3E 3D3B 3939 1A00 0000 0000"            /* upuiK>=;99...... */
	$"4363 6268 6D74 7D87 8F98 A395 7672 7373"            /* Ccbhmt}vrss */
	$"7A5D 0A00 0000 62FF FFFF FFFF FFFF FFFF"            /* z]...b */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFA"            /*  */
	$"E297 6C76 6D4C 3939 3738 1900 0000 0000"            /* lvmL9978...... */
	$"4165 6D77 7F85 8C92 979D 8E72 7273 7379"            /* Aemw.rrssy */
	$"610E 0000 0000 6AFF FFFF FFFF FFFF FFFF"            /* a.....j */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFCC DDFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFEF 8271 7673 5538 3437 1800 0000 0016"            /* qvsU847...... */
	$"6674 7577 7F84 8A8F 958C 7272 7373 796C"            /* ftuw.rrssyl */
	$"1200 0000 0000 6FFF FFFF FFFF FFFF FFFF"            /* ......o */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF6A 0F77"            /* j.w */
	$"DCFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF CF48 7278 7666 3932 1800 0000 336D"            /* Hrxvf92....3m */
	$"7974 7372 7276 7C86 8976 7273 7378 681E"            /* ytsrrv|vrssxh. */
	$"0000 0000 0000 74FF FFFF FFFF FFFF FFFF"            /* ......t */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF96 2C19"            /* ,. */
	$"2E5D A9FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* .] */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FF94 2B65 7A78 6840 1200 0000 4362"            /* +ezxh@....Cb */
	$"7178 7A76 7472 7273 7372 7373 786B 1700"            /* qxzvtrrssrssxk.. */
	$"0000 0000 0000 85FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFAE 7175"            /* qu */
	$"6C58 55D7 FFFF FFFF FFFF FFFF FFFF FFFF"            /* lXU */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFD7 0904 4B75 7B72 3E06 0000 0003"            /* .Ku{r>..... */
	$"152D 4764 777A 7674 7373 7377 6E1C 0000"            /* .-Gdwzvtssswn... */
	$"0000 0000 0000 95FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFA4 6C74"            /* lt */
	$"7476 718A F6FF FFFF FFFF FFFF FFFF FFFF"            /* tvq */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFEC 9A19 001D 5C7B 7A5C 1500 0000"            /* ...\{z\.... */
	$"0000 0005 294A 6573 7979 7877 2D00 0000"            /* ....)Jesyyxw-... */
	$"0000 0000 0000 9EFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFA0 6C73"            /* ls */
	$"7373 736D 9AF6 FFFF FFFF FFFF FFFF FFFF"            /* sssm */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFC5 0D00 0851 767B 6716 0000"            /* ...Qv{g... */
	$"0000 0000 0000 061C 3550 6628 0000 0000"            /* ........5Pf(.... */
	$"0000 0000 0000 A5FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF9F 7074"            /* pt */
	$"7373 7373 6B95 FCFF FFFF FFFF FFFF FFFF"            /* ssssk */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 6700 0001 1D21 2418 0000"            /* g....!$... */
	$"0000 0000 0000 0000 0000 0400 0000 0000"            /* ................ */
	$"0000 0000 0000 AAFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FE7C 5F73"            /* |_s */
	$"7977 7477 5E81 FDFF FFFF FFFF FFFF FFFF"            /* ywtw^ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF 9E00 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 AFFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FE3E 051D"            /* >.. */
	$"3662 7573 3EDA FFFF FFFF FFFF FFFF FFFF"            /* 6bus> */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF B400 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 B1FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FE3F 0000"            /* ?.. */
	$"0006 1D1E 3FFE FFFF FFFF FFFF FFFF FFFF"            /* ....? */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF CB05 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 B1FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FE40 0000"            /* @.. */
	$"0000 0000 34FC FFFF FFFF FFFF FFFF FFFF"            /* ....4 */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF E30C 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 B1FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF43 0000"            /* C.. */
	$"0000 0000 0BDB FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF EF0E 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 AEFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF4E 0000"            /* N.. */
	$"0000 0000 0092 FFFF FFFF FFFF FFFF FFFF"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF A502 0000 0000 0000 0000"            /* ......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 A9FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF5A 0000"            /* Z.. */
	$"0000 0000 002B F5FF FFFF FFFF FFFF FFFF"            /* .....+ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFF1 2600 0000 0000 0000 0000"            /* &......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 A4FF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF65 0000"            /* e.. */
	$"0000 0000 0000 73FF FFFF FFFF FFFF FFFF"            /* ......s */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FF83 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 9AFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF6A 0000"            /* j.. */
	$"0000 0000 0000 00B5 FFFF FFFF FFFF FFFF"            /* ....... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FD37 0000 0000 0000 0000 0000"            /* 7.......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 8FFF FFFF FFFF FFFF FFFF"            /* ...... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FF85 120B"            /* .. */
	$"0601 0000 0000 001C DBFF FFFF FFFF FFFF"            /* ........ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FF4C 0000 0000 0000 0000 0000"            /* L.......... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 103B 75AB DDFF FFFF FFFF FFFF FFFF"            /* ...;u */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFF7 E6D9"            /*  */
	$"D0BE A798 856A 5835 5EEF FFFF FFFF FFFF"            /* оjX5^ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FF62 110F 0F08 0000 0000 0000"            /* b.......... */
	$"0000 0000 0000 0000 0000 0000 0000 0820"            /* ...............  */
	$"7ABF F1FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* z */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFC ECF6 FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFEF DAA9 5C1A 0000 0000 0000"            /* ک\....... */
	$"0000 0000 0000 0000 0000 0001 0C42 93B6"            /* .............B */
	$"CED2 D4D1 CED3 DAD9 D9DF E5E5 E4E9 F0F0"            /*  */
	$"F0F1 F3F3 F3F5 F6F6 F6F9 FAFA FAFC FDFD"            /*  */
	$"FDFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FBE2"            /*  */
	$"BFA3 846A 5239 1F0F 0100 0000 0000 0000"            /* jR9.......... */
	$"0000 0000 0000 0000 0000 0000 040F 1209"            /* ............... */
	$"0303 0605 0507 0909 090B 0C0C 0C0D 0F0F"            /* ............. */
	$"0F15 1C1B 1A21 2726 262E 3231 313A 3D3C"            /* .....!'&&.211:=< */
	$"3D46 4848 4952 5353 535D 5E5E 5F69 6A69"            /* =FHHIRSSS]^^_iji */
	$"6B74 7574 7880 8080 848B 8B89 99DD FFFF"            /* ktutx */
	$"FFFF FFFF FFFB C8A3 A0A4 ADAC ACAC AFAE"            /* ȣ */
	$"ACB1 D0DC E3E6 E6E4 D8D4 C1A4 8762 350E"            /* b5. */
	$"0100 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 000F 4984"            /* ..............I */
	$"A7AF A588 6635 0400 0000 0000 0000 0000"            /* f5.......... */
	$"0000 060A 0E0F 110E 0A07 0200 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000"                 /* .............. */
};

